// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include <bayonne.h>
#include <sys/stat.h>

static char *filelink(scriptsymbol_t *sym, char **args)
{
	if(!*args[0])
		return "file-link-invalid";

	if(!*args[1])
		return "file-link-invalid";

	if(link(args[0], args[1]))
		return "file-link-failed";

	return NULL;
}

static char *filemove(scriptsymbol_t *sym, char **args)
{
	if(!*args[0])
		return "file-move-invalid";

	if(!*args[1])
		return "file-move-invalid";

	if(link(args[0], args[1]))
		return "file-move-failed";

	if(unlink(args[0]))
	{
		unlink(args[1]);
		return "file-move-failed";
	}

	return NULL;
}
	
static char *fileunlink(scriptsymbol_t *sym, char **args)
{
	int count = 0;
	char *msg = NULL;

	while(*args)
	{
		if(unlink(*(args++)))
			msg = "file-unlink-failed";
		else
			++count;
	}
	sprintf(sym->data, "%s", count);
	return msg;
}

static char *filestat(scriptsymbol_t *sym, char **args)
{
	struct stat ino;
	struct tm *dt;
	sym->data[0] = 0;
	char *fn = *(args++);
	if(!fn)
		return "no-file";

	if(stat(fn, &ino))
		return "no-file";

	dt = localtime(&ino.st_mtime);
	sprintf(sym->data, "%ld,%04d%02d%02d,%02d:%02d:%02d",
		(long)ino.st_size,
		dt->tm_year + 1900, dt->tm_mon + 1, dt->tm_mday,
		dt->tm_hour, dt->tm_min, dt->tm_sec);

	return NULL;
}

class FileFunctions : public Functions
{
private:
	char *getName(void)
		{return "file";};

public:
	FileFunctions()
	{
		static FUNCTIONS funs[] = {
			{"filestat", filestat},
			{"filemove", filemove},
			{"filelink", filelink},
			{"fileunlink", fileunlink},
			{NULL, NULL}};

		Load(funs);
	};
} myfile;

