// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of Bayonne as noted here.
//
// This exception is that permission is hereby granted to link Bayonne 
// with  the Pika MonteCarlo libraries to produce a executable image
// without requiring MonteCarlo itself to be supplied in source form so
// long as each source file so linked contains this exclusion.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name Bayonne.  If you copy code from other releases into a copy of
// Bayonne, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to Bayonne, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".

#include <ivrconfig.h>
#include <bayonne.h>
#include <cc++/audio.h>

typedef	enum
{
	CPA_DIALTONE = 0,
	CPA_BUSYTONE
} cpatone_t;

class TrunkDriver;

typedef union
{
#ifdef	IXJ_PHONEDEV
	IXJ_CID	ixjcid;
#endif
}	cid_t;

typedef enum
{
	generic_driver,
	ixj_driver
}	driver_t;

typedef	bool (TrunkDriver::*trunkhandler_t)(TrunkEvent *event);

class TrunkDriver : private TimerPort, private Trunk
{
private:
	friend class IVRDriver;
	friend class ServiceDriver;
	
	static char status[240];

	time_t lastring;
	trunkhandler_t handler;
	struct phone_capability *cap_list;
	TrunkDriver *next, *prev;
	ServiceDriver *service;
	driver_t driver;
	int cap_count;
	int dev;

#ifdef	IXJ_PHONEDEV
	IXJ_FILTER cpatone[4];
#endif

	TrunkDriver(int fd, int ts);
	~TrunkDriver();

	void setCPADetect(cpatone_t tone, bool flag);
	void getName(char *buffer);
	unsigned long getIdleTime(void);
	void setHookState(bool offhook);

	bool stepHandler(TrunkEvent *event);
	bool busyHandler(TrunkEvent *event);
	bool idleHandler(TrunkEvent *event);
	bool seizeHandler(TrunkEvent *event);
	bool ringHandler(TrunkEvent *event);
	bool waitHandler(TrunkEvent *event);
	bool dialHandler(TrunkEvent *event);
	bool playHandler(TrunkEvent *event);
	bool recordHandler(TrunkEvent *event);
	bool sleepHandler(TrunkEvent *event);
	bool hangupHandler(TrunkEvent *event);
	bool answerHandler(TrunkEvent *event);
	bool collectHandler(TrunkEvent *event);
	bool flashonHandler(TrunkEvent *event);
	bool flashoffHandler(TrunkEvent *event);

	struct phone_capability *getCapability(phone_cap id, int sub = -1);
	bool postEvent(TrunkEvent *event);
	void getEvents(void);
	void setTimer(timeout_t timeout = 0);
	void incTimer(timeout_t timeout);
	void Exit(void);
	void TrunkStep(trunkstep_t step);

public:
	inline int getDevice(void)
		{return dev;};

	inline driver_t getDriver(void)
		{return driver;};
};

class RecordAudio : private AudioFile, public Service
{
private:
	int dev;
	bool reset;
	driver_t driver;
	size_t bufsize, samples;

public:
	RecordAudio(TrunkDriver *trunk);
	~RecordAudio();
	void Initial(void);
	void Run(void);
};

class PlayAudio : private AudioFile, public Service
{
private:
	int dev;
	bool reset;
	driver_t driver;
	size_t bufsize, samples;
	void Initial(void);
	void Run(void);
	char *getContinuation(void);

public:
	PlayAudio(TrunkDriver *trunk);
	~PlayAudio();
};

class ServiceDriver : public Thread, private Mutex
{
private:
	friend class IVRDriver;
	friend class TrunkDriver;

	fd_set connect;
	int iosync[2];
	int hiwater;
	int count;
	TrunkDriver *first, *last;

	void Attach(TrunkDriver *trunk);
	void Detach(TrunkDriver *trunk);
	void Run(void);
	void Update(unsigned char id = 0xff);

	ServiceDriver();
	~ServiceDriver();
};	

class ConfigDriver : public Keydata
{
public:
	ConfigDriver();

	inline int getDevices(void)
		{return atoi(getLast("devices"));};

	inline int getWinkDuration(void)
		{return atoi(getLast("wink"));};

	inline int getAudioBuffers(void)
		{return atoi(getLast("buffers"));};
};

class IVRDriver : public Driver, public ConfigDriver
{
private:
	ServiceDriver *threads;
	int thread_count;
	int thread_select;

	TrunkDriver **ports;
	int port_count;

	int Start(void);
	void Stop(void);

public:
	IVRDriver();
	~IVRDriver();

	int getTrunkCount(void)
		{return port_count;};

	Trunk *getTrunkPort(int id);
	ServiceDriver *getService(void);
	aaScript *getScript(void);
	void Notify(unsigned char id);    // ALWAYS trunk + 1
};

extern IVRDriver ivr;
