# GNU Solfege - eartraining for GNOME
# Copyright (C) 2000, 2001, 2002, 2003  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

PAD = 8
PAD_SMALL = 4


APP_UI_ENDOFINFO          = 0
APP_UI_ITEM               = 1
APP_UI_TOGGLEITEM         = 2
APP_UI_RADIOITEMS         = 3
APP_UI_SUBTREE            = 4
APP_UI_SEPARATOR          = 5
APP_UI_HELP               = 6
#APP_UI_BUILDER_DATA       = 7
APP_UI_ITEM_CONFIGURABLE  = 8
APP_UI_ITEM_SUBTREE_STOCK = 9

APP_PIXMAP_NONE     = 0
APP_PIXMAP_STOCK    = 1
#APP_PIXMAP_DATA     = 2 # not supported by pygnome
APP_PIXMAP_FILENAME = 3

# UIInfo entries are (type, label, tooltip, callback, cbdata,
#                     pix_type, pixmap, accelerator_key, accelerator_mods)

UIINFO_END       = (APP_UI_ENDOFINFO, None, None, None, None,
		    APP_PIXMAP_NONE, None, 0, 0)
UIINFO_SEPARATOR = (APP_UI_SEPARATOR, None, None, None, None,
		    APP_PIXMAP_NONE, None, 0, 0)
def UIINFO_ITEM(label, tip=None, cb=None, image=None):
	if image:
		return (APP_UI_ITEM, label, tip, cb, None,
			APP_PIXMAP_FILENAME, image, 0, 0)
	else:
		return (APP_UI_ITEM, label, tip, cb, None,
			APP_PIXMAP_NONE, None, 0, 0)
def UIINFO_ITEM_STOCK(label, tip=None, cb=None, stock=None):
	return (APP_UI_ITEM, label, tip, cb, None,
		APP_PIXMAP_STOCK, stock, 0, 0)
	
def UIINFO_TOGGLEITEM(label, tip=None, cb=None, image=None):
	if image:
		return (APP_UI_TOGGLEITEM, label, tip, cb, None,
			APP_PIXMAP_FILENAME, image, 0, 0)
	else:
		return (APP_UI_TOGGLEITEM, label, tip, cb, None,
			APP_PIXMAP_NONE, None, 0, 0)
def UIINFO_HELP(name):
	return (APP_UI_HELP, None, None, name, None,
		APP_PIXMAP_NONE, None, 0, 0)
def UIINFO_SUBTREE(label, tree):
	return (APP_UI_SUBTREE, label, None, tree, None,
		APP_PIXMAP_NONE, None, 0, 0)
def UIINFO_SUBTREE_HINT(label, hint, tree):
	return (APP_UI_SUBTREE, label, hint, tree, None,
		APP_PIXMAP_NONE, None, 0, 0)
def UIINFO_SUBTREE_STOCK(label, tree, image):
	return (APP_UI_SUBTREE, label, None, tree, None,
		APP_PIXMAP_STOCK, image, 0, 0)
def UIINFO_RADIOLIST(list):
	return (APP_UI_RADIOITEMS, None, None, list, None,
		APP_PIXMAP_NONE, None, 0, 0)
def UIINFO_RADIOITEM(label, tip=None, cb=None, image=None):
	print "Deprecated -- just use UIINFO_ITEM for radio list items"
	if image:
		return (APP_UI_ITEM, label, tip, cb, None,
			APP_PIXMAP_FILENAME, image, 0, 0)
	else:
		return (APP_UI_ITEM, label, tip, cb, None,
			APP_PIXMAP_NONE, None, 0, 0)

_APP_CONFIGURABLE_ITEM_NEW          = 0
_APP_CONFIGURABLE_ITEM_OPEN         = 1
_APP_CONFIGURABLE_ITEM_SAVE         = 2
_APP_CONFIGURABLE_ITEM_SAVE_AS      = 3
_APP_CONFIGURABLE_ITEM_REVERT       = 4
_APP_CONFIGURABLE_ITEM_PRINT        = 5
_APP_CONFIGURABLE_ITEM_PRINT_SETUP  = 6
_APP_CONFIGURABLE_ITEM_CLOSE        = 7
_APP_CONFIGURABLE_ITEM_EXIT         = 8
_APP_CONFIGURABLE_ITEM_CUT          = 9
_APP_CONFIGURABLE_ITEM_COPY         = 10
_APP_CONFIGURABLE_ITEM_PASTE        = 11
_APP_CONFIGURABLE_ITEM_CLEAR        = 12
_APP_CONFIGURABLE_ITEM_UNDO         = 13
_APP_CONFIGURABLE_ITEM_REDO         = 14
_APP_CONFIGURABLE_ITEM_FIND         = 15
_APP_CONFIGURABLE_ITEM_FIND_AGAIN   = 16
_APP_CONFIGURABLE_ITEM_REPLACE      = 17
_APP_CONFIGURABLE_ITEM_PROPERTIES   = 18
_APP_CONFIGURABLE_ITEM_PREFERENCES  = 19
_APP_CONFIGURABLE_ITEM_ABOUT        = 20
_APP_CONFIGURABLE_ITEM_SELECT_ALL   = 21
_APP_CONFIGURABLE_ITEM_NEW_WINDOW   = 22
_APP_CONFIGURABLE_ITEM_CLOSE_WINDOW = 23
_APP_CONFIGURABLE_ITEM_NEW_GAME     = 24
_APP_CONFIGURABLE_ITEM_PAUSE_GAME   = 25
_APP_CONFIGURABLE_ITEM_RESTART_GAME = 26
_APP_CONFIGURABLE_ITEM_UNDO_MOVE    = 27
_APP_CONFIGURABLE_ITEM_REDO_MOVE    = 28
_APP_CONFIGURABLE_ITEM_HINT         = 29
_APP_CONFIGURABLE_ITEM_SCORES       = 30
_APP_CONFIGURABLE_ITEM_END_GAME     = 31

def UIINFO_MENU_NEW_ITEM(label, tip, cb=None, data=None):
	return (APP_UI_ITEM_CONFIGURABLE, label, tip, cb, data,
		APP_PIXMAP_NONE, None, _APP_CONFIGURABLE_ITEM_NEW, 0)
def UIINFO_MENU_OPEN_ITEM(cb=None, data=None):
	return (APP_UI_ITEM_CONFIGURABLE, None, None, cb, data,
		APP_PIXMAP_NONE, None, _APP_CONFIGURABLE_ITEM_OPEN, 0)
def UIINFO_MENU_SAVE_ITEM(cb=None, data=None):
	return (APP_UI_ITEM_CONFIGURABLE, None, None, cb, data,
		APP_PIXMAP_NONE, None, _APP_CONFIGURABLE_ITEM_SAVE, 0)
def UIINFO_MENU_SAVE_AS_ITEM(cb=None, data=None):
	return (APP_UI_ITEM_CONFIGURABLE, None, None, cb, data,
		APP_PIXMAP_NONE, None, _APP_CONFIGURABLE_ITEM_SAVE_AS, 0)
def UIINFO_MENU_REVERT_ITEM(cb=None, data=None):
	return (APP_UI_ITEM_CONFIGURABLE, None, None, cb, data,
		APP_PIXMAP_NONE, None, _APP_CONFIGURABLE_ITEM_REVERT, 0)
def UIINFO_MENU_PRINT_ITEM(cb=None, data=None):
	return (APP_UI_ITEM_CONFIGURABLE, None, None, cb, data,
		APP_PIXMAP_NONE, None, _APP_CONFIGURABLE_ITEM_PRINT, 0)
def UIINFO_MENU_PRINT_SETUP_ITEM(cb=None, data=None):
	return (APP_UI_ITEM_CONFIGURABLE, None, None, cb, data,
		APP_PIXMAP_NONE, None, _APP_CONFIGURABLE_ITEM_PRINT_SETUP, 0)
def UIINFO_MENU_CLOSE_ITEM(cb=None, data=None):
	return (APP_UI_ITEM_CONFIGURABLE, None, None, cb, data,
		APP_PIXMAP_NONE, None, _APP_CONFIGURABLE_ITEM_CLOSE, 0)
def UIINFO_MENU_EXIT_ITEM(cb=None, data=None):
	return (APP_UI_ITEM_CONFIGURABLE, None, None, cb, data,
		APP_PIXMAP_NONE, None, _APP_CONFIGURABLE_ITEM_EXIT, 0)
def UIINFO_MENU_CUT_ITEM(cb=None, data=None):
	return (APP_UI_ITEM_CONFIGURABLE, None, None, cb, data,
		APP_PIXMAP_NONE, None, _APP_CONFIGURABLE_ITEM_CUT, 0)
def UIINFO_MENU_COPY_ITEM(cb=None, data=None):
	return (APP_UI_ITEM_CONFIGURABLE, None, None, cb, data,
		APP_PIXMAP_NONE, None, _APP_CONFIGURABLE_ITEM_COPY, 0)
def UIINFO_MENU_PASTE_ITEM(cb=None, data=None):
	return (APP_UI_ITEM_CONFIGURABLE, None, None, cb, data,
		APP_PIXMAP_NONE, None, _APP_CONFIGURABLE_ITEM_PASTE, 0)
def UIINFO_MENU_SELECT_ALL_ITEM(cb=None, data=None):
	return (APP_UI_ITEM_CONFIGURABLE, None, None, cb, data,
		APP_PIXMAP_NONE, None, _APP_CONFIGURABLE_ITEM_SELECT_ALL, 0)
def UIINFO_MENU_CLEAR_ITEM(cb=None, data=None):
	return (APP_UI_ITEM_CONFIGURABLE, None, None, cb, data,
		APP_PIXMAP_NONE, None, _APP_CONFIGURABLE_ITEM_CLEAR, 0)
def UIINFO_MENU_UNDO_ITEM(cb=None, data=None):
	return (APP_UI_ITEM_CONFIGURABLE, None, None, cb, data,
		APP_PIXMAP_NONE, None, _APP_CONFIGURABLE_ITEM_UNDO, 0)
def UIINFO_MENU_REDO_ITEM(cb=None, data=None):
	return (APP_UI_ITEM_CONFIGURABLE, None, None, cb, data,
		APP_PIXMAP_NONE, None, _APP_CONFIGURABLE_ITEM_REDO, 0)
def UIINFO_MENU_FIND_ITEM(cb=None, data=None):
	return (APP_UI_ITEM_CONFIGURABLE, None, None, cb, data,
		APP_PIXMAP_NONE, None, _APP_CONFIGURABLE_ITEM_FIND, 0)
def UIINFO_MENU_FIND_AGAIN_ITEM(cb=None, data=None):
	return (APP_UI_ITEM_CONFIGURABLE, None, None, cb, data,
		APP_PIXMAP_NONE, None, _APP_CONFIGURABLE_ITEM_FIND_AGAIN, 0)
def UIINFO_MENU_REPLACE_ITEM(cb=None, data=None):
	return (APP_UI_ITEM_CONFIGURABLE, None, None, cb, data,
		APP_PIXMAP_NONE, None, _APP_CONFIGURABLE_ITEM_REPLACE, 0)
def UIINFO_MENU_PROPERTIES_ITEM(cb=None, data=None):
	return (APP_UI_ITEM_CONFIGURABLE, None, None, cb, data,
		APP_PIXMAP_NONE, None, _APP_CONFIGURABLE_ITEM_PROPERTIES, 0)
def UIINFO_MENU_PREFERENCES_ITEM(cb=None, data=None):
	return (APP_UI_ITEM_CONFIGURABLE, None, None, cb, data,
		APP_PIXMAP_NONE, None, _APP_CONFIGURABLE_ITEM_PREFERENCES, 0)
def UIINFO_MENU_NEW_WINDOW_ITEM(cb=None, data=None):
	return (APP_UI_ITEM_CONFIGURABLE, None, None, cb, data,
		APP_PIXMAP_NONE, None, _APP_CONFIGURABLE_ITEM_NEW_WINDOW, 0)
def UIINFO_MENU_CLOSE_WINDOW_ITEM(cb=None, data=None):
	return (APP_UI_ITEM_CONFIGURABLE, None, None, cb, data,
		APP_PIXMAP_NONE, None, _APP_CONFIGURABLE_ITEM_CLOSE_WINDOW, 0)
def UIINFO_MENU_ABOUT_ITEM(cb=None, data=None):
	return (APP_UI_ITEM_CONFIGURABLE, None, None, cb, data,
		APP_PIXMAP_NONE, None, _APP_CONFIGURABLE_ITEM_ABOUT, 0)
def UIINFO_MENU_NEW_GAME_ITEM(cb=None, data=None):
	return (APP_UI_ITEM_CONFIGURABLE, None, None, cb, data,
		APP_PIXMAP_NONE, None, _APP_CONFIGURABLE_ITEM_NEW_GAME, 0)
def UIINFO_MENU_PAUSE_GAME_ITEM(cb=None, data=None):
	return (APP_UI_ITEM_CONFIGURABLE, None, None, cb, data,
		APP_PIXMAP_NONE, None, _APP_CONFIGURABLE_ITEM_PAUSE_GAME, 0)
def UIINFO_MENU_RESTART_GAME_ITEM(cb=None, data=None):
	return (APP_UI_ITEM_CONFIGURABLE, None, None, cb, data,
		APP_PIXMAP_NONE, None, _APP_CONFIGURABLE_ITEM_RESTART_GAME, 0)
def UIINFO_MENU_UNDO_MOVE_ITEM(cb=None, data=None):
	return (APP_UI_ITEM_CONFIGURABLE, None, None, cb, data,
		APP_PIXMAP_NONE, None, _APP_CONFIGURABLE_ITEM_UNDO_MOVE, 0)
def UIINFO_MENU_REDO_MOVE_ITEM(cb=None, data=None):
	return (APP_UI_ITEM_CONFIGURABLE, None, None, cb, data,
		APP_PIXMAP_NONE, None, _APP_CONFIGURABLE_ITEM_REDO_MOVE, 0)
def UIINFO_MENU_HINT_ITEM(cb=None, data=None):
	return (APP_UI_ITEM_CONFIGURABLE, None, None, cb, data,
		APP_PIXMAP_NONE, None, _APP_CONFIGURABLE_ITEM_HINT, 0)
def UIINFO_MENU_SCORES_ITEM(cb=None, data=None):
	return (APP_UI_ITEM_CONFIGURABLE, None, None, cb, data,
		APP_PIXMAP_NONE, None, _APP_CONFIGURABLE_ITEM_SCORES, 0)
def UIINFO_MENU_END_GAME_ITEM(cb=None, data=None):
	return (APP_UI_ITEM_CONFIGURABLE, None, None, cb, data,
		APP_PIXMAP_NONE, None, _APP_CONFIGURABLE_ITEM_END_GAME, 0)

STOCK_MENU_EXEC        = "Menu_Exec"
STOCK_PIXMAP_BACK        = "Back"
STOCK_PIXMAP_FORWARD     = "Forward"

DOCK_TOP      = 0
DOCK_RIGHT    = 1
DOCK_BOTTOM   = 2
DOCK_LEFT     = 3
DOCK_FLOATING = 4

DOCK_ITEM_BEH_NORMAL           = 0
DOCK_ITEM_BEH_EXCLUSIVE        = 1 << 0
DOCK_ITEM_BEH_NEVER_FLOATING   = 1 << 1
DOCK_ITEM_BEH_NEVER_VERTICAL   = 1 << 2
DOCK_ITEM_BEH_NEVER_HORIZONTAL = 1 << 3
DOCK_ITEM_BEH_LOCKED           = 1 << 4


