/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jline.utils.AttributedCharSequence;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public class AttributedString
extends AttributedCharSequence {
    final char[] buffer;
    final int[] style;
    final int start;
    final int end;
    public static final AttributedString EMPTY = new AttributedString("");

    public AttributedString(CharSequence str) {
        this(str, 0, str.length(), null);
    }

    public AttributedString(CharSequence str, int start, int end) {
        this(str, start, end, null);
    }

    public AttributedString(CharSequence str, AttributedStyle s) {
        this(str, 0, str.length(), s);
    }

    public AttributedString(CharSequence str, int start, int end, AttributedStyle s) {
        if (end < start) {
            throw new InvalidParameterException();
        }
        if (str instanceof AttributedString) {
            AttributedString as = (AttributedString)str;
            this.buffer = as.buffer;
            if (s != null) {
                this.style = (int[])as.style.clone();
                for (int i = 0; i < this.style.length; ++i) {
                    this.style[i] = this.style[i] & ~s.getMask() | s.getStyle();
                }
            } else {
                this.style = as.style;
            }
            this.start = as.start + start;
            this.end = as.start + end;
        } else if (str instanceof AttributedStringBuilder) {
            AttributedStringBuilder asb = (AttributedStringBuilder)str;
            AttributedString as = asb.subSequence(start, end);
            this.buffer = as.buffer;
            this.style = as.style;
            if (s != null) {
                for (int i = 0; i < this.style.length; ++i) {
                    this.style[i] = this.style[i] & ~s.getMask() | s.getStyle();
                }
            }
            this.start = as.start;
            this.end = as.end;
        } else {
            int l = end - start;
            this.buffer = new char[l];
            for (int i = 0; i < l; ++i) {
                this.buffer[i] = str.charAt(start + i);
            }
            this.style = new int[l];
            if (s != null) {
                Arrays.fill(this.style, s.getStyle());
            }
            this.start = 0;
            this.end = l;
        }
    }

    AttributedString(char[] buffer, int[] style, int start, int end) {
        this.buffer = buffer;
        this.style = style;
        this.start = start;
        this.end = end;
    }

    public static AttributedString fromAnsi(String ansi) {
        if (ansi == null) {
            return null;
        }
        AttributedStringBuilder sb = new AttributedStringBuilder(ansi.length());
        sb.appendAnsi(ansi);
        return sb.toAttributedString();
    }

    public static String stripAnsi(String ansi) {
        if (ansi == null) {
            return null;
        }
        AttributedStringBuilder sb = new AttributedStringBuilder(ansi.length());
        sb.appendAnsi(ansi);
        return sb.toString();
    }

    @Override
    protected char[] buffer() {
        return this.buffer;
    }

    @Override
    protected int offset() {
        return this.start;
    }

    @Override
    public int length() {
        return this.end - this.start;
    }

    @Override
    public AttributedStyle styleAt(int index) {
        return new AttributedStyle(this.style[this.start + index], this.style[this.start + index]);
    }

    @Override
    int styleCodeAt(int index) {
        return this.style[this.start + index];
    }

    @Override
    public AttributedString subSequence(int start, int end) {
        return new AttributedString(this, start, end);
    }

    public AttributedString styleMatches(Pattern pattern, AttributedStyle style) {
        Matcher matcher = pattern.matcher(this);
        boolean result = matcher.find();
        if (result) {
            int[] newstyle = (int[])this.style.clone();
            do {
                for (int i = matcher.start(); i < matcher.end(); ++i) {
                    newstyle[this.start + i] = newstyle[this.start + i] & ~style.getMask() | style.getStyle();
                }
            } while (result = matcher.find());
            return new AttributedString(this.buffer, newstyle, this.start, this.end);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributedString that = (AttributedString)o;
        if (this.start != that.start) {
            return false;
        }
        if (this.end != that.end) {
            return false;
        }
        if (!Arrays.equals(this.buffer, that.buffer)) {
            return false;
        }
        return Arrays.equals(this.style, that.style);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.buffer);
        result = 31 * result + Arrays.hashCode(this.style);
        result = 31 * result + this.start;
        result = 31 * result + this.end;
        return result;
    }

    public static AttributedString join(AttributedString delimiter, AttributedString ... elements) {
        Objects.requireNonNull(delimiter);
        Objects.requireNonNull(elements);
        return AttributedString.join(delimiter, Arrays.asList(elements));
    }

    public static AttributedString join(AttributedString delimiter, Iterable<AttributedString> elements) {
        Objects.requireNonNull(elements);
        AttributedStringBuilder sb = new AttributedStringBuilder();
        int i = 0;
        for (AttributedString str : elements) {
            if (i++ > 0 && delimiter != null) {
                sb.append(delimiter);
            }
            sb.append(str);
        }
        return sb.toAttributedString();
    }
}

