/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.buffer;

import gnu.jemacs.buffer.Buffer;
import gnu.mapping.Environment;
import gnu.mapping.IndirectableLocation;
import gnu.mapping.Location;
import gnu.mapping.NamedLocation;
import gnu.mapping.Symbol;

public class BufferLocal
extends IndirectableLocation {
    boolean all;
    final Symbol name;
    Buffer cachedBuffer;
    int cachedIndex;

    BufferLocal(Symbol name, boolean all) {
        this.name = name;
        this.all = all;
    }

    public final Symbol getKeySymbol() {
        return this.name;
    }

    public static void make(Symbol symbol, boolean all) {
        Environment env = Environment.getCurrent();
        NamedLocation loc = env.getLocation(symbol, null, true);
        Location base = loc.getBase();
        if (base instanceof BufferLocal) {
            if (all) {
                ((BufferLocal)base).all = true;
            }
            return;
        }
        BufferLocal bloc = new BufferLocal(symbol, all);
        bloc.base = loc.getBaseForce();
        bloc.setAlias(loc);
    }

    public Object get(Object defaultValue) {
        Buffer buffer = Buffer.getCurrent();
        return buffer == null ? this.base.get(defaultValue) : this.get(buffer, defaultValue);
    }

    public Object get(Buffer buffer, Object defaultValue) {
        Object[] localBindings = buffer.localBindings;
        if (buffer == this.cachedBuffer) {
            int i = this.cachedIndex;
            if (i > 0) {
                return localBindings[i];
            }
        } else if (localBindings != null) {
            Symbol n = this.getKeySymbol();
            int len = localBindings.length;
            this.cachedBuffer = buffer;
            for (int i = 0; i < len; i += 2) {
                if (localBindings[i] != n) continue;
                this.cachedIndex = ++i;
                return localBindings[i];
            }
            this.cachedIndex = 0;
        }
        return this.base != null ? this.base.get(defaultValue) : (this.value == Location.UNBOUND ? defaultValue : this.value);
    }

    public boolean isBound() {
        Buffer buffer = Buffer.getCurrent();
        return buffer == null ? this.base.isBound() : this.isBound(buffer);
    }

    public boolean isBound(Buffer buffer) {
        Object[] localBindings = buffer.localBindings;
        String unb = Location.UNBOUND;
        if (buffer == this.cachedBuffer) {
            int i = this.cachedIndex;
            if (i >= 0) {
                return localBindings[i] != unb;
            }
        } else if (localBindings != null) {
            Symbol n = this.getKeySymbol();
            int len = localBindings.length;
            this.cachedBuffer = buffer;
            for (int i = 0; i < len; i += 2) {
                if (localBindings[i] != n) continue;
                this.cachedIndex = ++i;
                return localBindings[i] != unb;
            }
            this.cachedIndex = 0;
        }
        return super.isBound();
    }

    public final synchronized void set(Object newValue) {
        Buffer buffer = Buffer.getCurrent();
        if (buffer == null) {
            this.base.set(newValue);
        } else {
            this.set(buffer, newValue);
        }
    }

    public final synchronized void set(Buffer buffer, Object newValue) {
        Object[] localBindings = buffer.localBindings;
        int avail = -1;
        Symbol n = this.getKeySymbol();
        if (buffer == this.cachedBuffer) {
            int i = this.cachedIndex;
            if (i >= 0) {
                localBindings[i] = newValue;
                return;
            }
        } else if (localBindings != null) {
            int len = localBindings.length;
            for (int i = 0; i < len; i += 2) {
                Object key = localBindings[i];
                if (key == n) {
                    this.cachedBuffer = buffer;
                    this.cachedIndex = ++i;
                    localBindings[i] = newValue;
                    return;
                }
                if (key != null) continue;
                avail = i;
            }
            this.cachedIndex = 0;
        }
        if (this.all) {
            if (avail < 0) {
                if (localBindings == null) {
                    buffer.localBindings = localBindings = new Object[20];
                    avail = 0;
                } else {
                    avail = localBindings.length;
                    Object[] newBindings = new Object[2 * avail];
                    System.arraycopy(localBindings, 0, newBindings, 0, avail);
                    localBindings = newBindings;
                    buffer.localBindings = newBindings;
                }
            }
            localBindings[avail] = n;
            this.cachedBuffer = buffer;
            this.cachedIndex = ++avail;
            localBindings[avail] = newValue;
        } else if (this.base == null) {
            this.value = newValue;
        } else {
            this.base.set(newValue);
        }
    }
}

