/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;
import gnu.bytecode.Method;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.Compilation;
import gnu.expr.ConditionalTarget;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IfExp;
import gnu.expr.Inlineable;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.kawa.functions.AddOp;
import gnu.mapping.Procedure;
import gnu.mapping.ProcedureN;
import gnu.math.IntNum;
import gnu.math.Numeric;

public class NumberCompare
extends ProcedureN
implements CanInline,
Inlineable {
    static final int RESULT_GRT = 1;
    static final int RESULT_EQU = 0;
    static final int RESULT_LSS = -1;
    static final int RESULT_NAN = -2;
    static final int RESULT_NEQ = -3;
    static final int TRUE_IF_GRT = 16;
    static final int TRUE_IF_EQU = 8;
    static final int TRUE_IF_LSS = 4;
    static final int TRUE_IF_NAN = 2;
    static final int TRUE_IF_NEQ = 1;
    int flags;
    public static final NumberCompare $Eq = NumberCompare.make("=", 8);
    public static final NumberCompare $Gr = NumberCompare.make(">", 16);
    public static final NumberCompare $Gr$Eq = NumberCompare.make(">=", 24);
    public static final NumberCompare $Ls = NumberCompare.make("<", 4);
    public static final NumberCompare $Ls$Eq = NumberCompare.make("<=", 12);
    private static final int Unknown_KIND = 0;
    private static final int Number_KIND = 1;
    private static final int Numeric_KIND = 2;
    private static final int RealNum_KIND = 3;
    private static final int double_KIND = 4;
    private static final int IntNum_KIND = 5;
    private static final int long_KIND = 6;
    private static final int int_KIND = 7;

    public int numArgs() {
        return -4094;
    }

    public static boolean $Eq(Object object2, Object object3) {
        return NumberCompare.apply2(8, object2, object3);
    }

    public static boolean $Gr(Object object2, Object object3) {
        return NumberCompare.apply2(16, object2, object3);
    }

    public static boolean $Gr$Eq(Object object2, Object object3) {
        return NumberCompare.apply2(24, object2, object3);
    }

    public static boolean $Ls(Object object2, Object object3) {
        return NumberCompare.apply2(4, object2, object3);
    }

    public static boolean $Ls$Eq(Object object2, Object object3) {
        return NumberCompare.apply2(12, object2, object3);
    }

    public static boolean $Eq$V(Object object2, Object object3, Object object4, Object[] objectArray) {
        return NumberCompare.$Eq(object2, object3) && NumberCompare.$Eq(object3, object4) && (objectArray.length == 0 || NumberCompare.$Eq(object4, objectArray[0]) && NumberCompare.applyN(8, objectArray));
    }

    public static boolean $Gr$V(Object object2, Object object3, Object object4, Object[] objectArray) {
        return NumberCompare.$Gr(object2, object3) && NumberCompare.$Gr(object3, object4) && (objectArray.length == 0 || NumberCompare.$Gr(object4, objectArray[0]) && NumberCompare.applyN(16, objectArray));
    }

    public static boolean $Gr$Eq$V(Object object2, Object object3, Object object4, Object[] objectArray) {
        return NumberCompare.$Gr$Eq(object2, object3) && NumberCompare.$Gr$Eq(object3, object4) && (objectArray.length == 0 || NumberCompare.$Gr$Eq(object4, objectArray[0]) && NumberCompare.applyN(24, objectArray));
    }

    public static boolean $Ls$V(Object object2, Object object3, Object object4, Object[] objectArray) {
        return NumberCompare.$Ls(object2, object3) && NumberCompare.$Ls(object3, object4) && (objectArray.length == 0 || NumberCompare.$Ls(object4, objectArray[0]) && NumberCompare.applyN(4, objectArray));
    }

    public static boolean $Ls$Eq$V(Object object2, Object object3, Object object4, Object[] objectArray) {
        return NumberCompare.$Ls$Eq(object2, object3) && NumberCompare.$Ls$Eq(object3, object4) && (objectArray.length == 0 || NumberCompare.$Ls$Eq(object4, objectArray[0]) && NumberCompare.applyN(12, objectArray));
    }

    public static NumberCompare make(String string, int n) {
        NumberCompare numberCompare = new NumberCompare();
        numberCompare.setName(string);
        numberCompare.flags = n;
        return numberCompare;
    }

    public Object apply2(Object object2, Object object3) {
        if (NumberCompare.apply2(this.flags, object2, object3)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static boolean apply2(int n, Object object2, Object object3) {
        return (1 << 3 + ((Numeric)object2).compare(object3) & n) != 0;
    }

    static boolean applyN(int n, Object[] objectArray) {
        for (int i = 0; i < objectArray.length - 1; ++i) {
            Object object2 = objectArray[i];
            Object object3 = objectArray[i + 1];
            if (NumberCompare.apply2(n, object2, object3)) continue;
            return false;
        }
        return true;
    }

    public Object applyN(Object[] objectArray) {
        return NumberCompare.applyN(this.flags, objectArray) ? Boolean.TRUE : Boolean.FALSE;
    }

    public Expression inline(ApplyExp applyExp, ExpWalker expWalker) {
        Expression expression = applyExp.inlineIfConstant(this, expWalker);
        if (expression != applyExp) {
            return expression;
        }
        return applyExp;
    }

    public void compile(ApplyExp applyExp, Compilation compilation, Target target) {
        Expression[] expressionArray = applyExp.getArgs();
        if (expressionArray.length == 2) {
            Object object2 = expressionArray[0];
            Expression expression = expressionArray[1];
            int n = NumberCompare.classify((Expression)object2);
            int n2 = NumberCompare.classify(expression);
            CodeAttr codeAttr = compilation.getCode();
            if (n >= 3 && n2 >= 3 && (n != 3 || n2 != 3)) {
                Object object3;
                int n3;
                Object object4;
                Object object5;
                Object object6;
                Object object7;
                if (!(target instanceof ConditionalTarget)) {
                    IfExp.compile(applyExp, QuoteExp.trueExp, QuoteExp.falseExp, compilation, target);
                    return;
                }
                int n4 = this.flags;
                if (n4 == 1) {
                    n4 = 20;
                }
                if (n >= 5 && n2 >= 5 && (n < 6 || n2 < 6)) {
                    object7 = new Type[2];
                    object7[0] = AddOp.typeIntNum;
                    if (n2 >= 6) {
                        object7[1] = Type.long_type;
                    } else if (n >= 6 && (object2 instanceof QuoteExp || expression instanceof QuoteExp || object2 instanceof ReferenceExp || expression instanceof ReferenceExp)) {
                        object7[1] = Type.long_type;
                        expressionArray = new Expression[]{expression, object2};
                        if (n4 != 8 && n4 != 20) {
                            n4 ^= 0x14;
                        }
                    } else {
                        object7[1] = AddOp.typeIntNum;
                    }
                    object6 = AddOp.typeIntNum.getDeclaredMethod("compare", (Type[])object7);
                    object5 = new PrimProcedure((Method)object6);
                    object2 = new ApplyExp((Procedure)object5, expressionArray);
                    expression = new QuoteExp(IntNum.zero());
                    n2 = 7;
                    n = 7;
                }
                object7 = n >= 7 && n2 >= 7 ? Type.int_type : (n >= 6 && n2 >= 6 ? Type.long_type : Type.double_type);
                object6 = new StackTarget((Type)object7);
                object5 = (ConditionalTarget)target;
                if (object2 instanceof QuoteExp && !(expression instanceof QuoteExp)) {
                    object4 = expression;
                    expression = object2;
                    object2 = object4;
                    if (n4 != 8 && n4 != 20) {
                        n4 ^= 0x14;
                    }
                }
                Object object8 = object4 = ((ConditionalTarget)object5).trueBranchComesFirst ? ((ConditionalTarget)object5).ifFalse : ((ConditionalTarget)object5).ifTrue;
                if (((ConditionalTarget)object5).trueBranchComesFirst) {
                    n4 ^= 0x1C;
                }
                switch (n4) {
                    case 16: {
                        n3 = 157;
                        break;
                    }
                    case 8: {
                        n3 = 153;
                        break;
                    }
                    case 4: {
                        n3 = 155;
                        break;
                    }
                    case 20: {
                        n3 = 154;
                        break;
                    }
                    case 24: {
                        n3 = 156;
                        break;
                    }
                    case 12: {
                        n3 = 158;
                        break;
                    }
                    default: {
                        n3 = 0;
                    }
                }
                ((Expression)object2).compile(compilation, (Target)object6);
                if (n >= 7 && n2 >= 7 && expression instanceof QuoteExp && (object3 = ((QuoteExp)expression).getValue()) instanceof IntNum && ((IntNum)object3).isZero()) {
                    codeAttr.emitGotoIfCompare1((Label)object4, n3);
                } else {
                    expression.compile(compilation, (Target)object6);
                    codeAttr.emitGotoIfCompare2((Label)object4, n3);
                }
                ((ConditionalTarget)object5).emitGotoFirstBranch(codeAttr);
                return;
            }
        }
        ApplyExp.compile(applyExp, compilation, target);
    }

    static int classify(Expression expression) {
        Object object2;
        Type type = expression.getType();
        int n = NumberCompare.classify(type);
        if (n == 5 && expression instanceof QuoteExp && (object2 = ((QuoteExp)expression).getValue()) instanceof IntNum) {
            int n2 = ((IntNum)object2).intLength();
            if (n2 < 32) {
                return 7;
            }
            if (n2 < 64) {
                return 6;
            }
        }
        return n;
    }

    static int classify(Type type) {
        if (type instanceof PrimType) {
            char c = type.getSignature().charAt(0);
            if (c == 'V' || c == 'Z' || c == 'C') {
                return 0;
            }
            if (c == 'D' || c == 'F') {
                return 4;
            }
            if (c == 'J') {
                return 6;
            }
            return 7;
        }
        if (type.isSubtype(AddOp.typeIntNum)) {
            return 5;
        }
        if (type.isSubtype(AddOp.typeDFloNum)) {
            return 4;
        }
        if (type.isSubtype(AddOp.typeRealNum)) {
            return 3;
        }
        if (type.isSubtype(AddOp.typeNumeric)) {
            return 2;
        }
        return 0;
    }

    public Type getReturnType(Expression[] expressionArray) {
        return Compilation.scmBooleanType;
    }
}

