/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.view.View;
import android.widget.TextView;
import com.jayway.android.robotium.solo.ActivityUtils;
import com.jayway.android.robotium.solo.RobotiumUtils;
import com.jayway.android.robotium.solo.Scroller;
import com.jayway.android.robotium.solo.Searcher;
import com.jayway.android.robotium.solo.Sleeper;
import com.jayway.android.robotium.solo.ViewFetcher;
import java.util.ArrayList;
import java.util.HashSet;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Waiter {
    private final ActivityUtils activityUtils;
    private final ViewFetcher viewFetcher;
    private final int TIMEOUT = 20000;
    private final int SMALLTIMEOUT = 10000;
    private final Searcher searcher;
    private final Scroller scroller;
    private final Sleeper sleeper;

    public Waiter(ActivityUtils activityUtils, ViewFetcher viewFetcher, Searcher searcher, Scroller scroller, Sleeper sleeper) {
        this.activityUtils = activityUtils;
        this.viewFetcher = viewFetcher;
        this.searcher = searcher;
        this.scroller = scroller;
        this.sleeper = sleeper;
    }

    public boolean waitForActivity(String name) {
        return this.waitForActivity(name, 10000);
    }

    public boolean waitForActivity(String name, int timeout) {
        long now = System.currentTimeMillis();
        long endTime = now + (long)timeout;
        while (!this.activityUtils.getCurrentActivity().getClass().getSimpleName().equals(name) && now < endTime) {
            now = System.currentTimeMillis();
        }
        return now < endTime;
    }

    public <T extends View> boolean waitForView(Class<T> viewClass, int index, boolean sleep, boolean scroll) {
        HashSet uniqueViews = new HashSet();
        do {
            boolean foundMatchingView;
            if (sleep) {
                this.sleeper.sleep();
            }
            if (foundMatchingView = this.searcher.searchFor(uniqueViews, viewClass, index)) {
                return true;
            }
            if (!scroll || this.scroller.scroll(0)) continue;
            return false;
        } while (scroll);
        return false;
    }

    public <T extends View> boolean waitForView(Class<T> viewClass, int index, int timeout, boolean scroll) {
        HashSet uniqueViews = new HashSet();
        long endTime = System.currentTimeMillis() + (long)timeout;
        while (System.currentTimeMillis() < endTime) {
            this.sleeper.sleep();
            boolean foundMatchingView = this.searcher.searchFor(uniqueViews, viewClass, index);
            if (foundMatchingView) {
                return true;
            }
            if (!scroll) continue;
            this.scroller.scroll(0);
        }
        return false;
    }

    public <T extends View> boolean waitForViews(Class<T> viewClass, Class<? extends View> viewClass2) {
        long endTime = System.currentTimeMillis() + 10000L;
        while (System.currentTimeMillis() < endTime) {
            if (this.waitForView(viewClass, 0, false, false)) {
                return true;
            }
            if (this.waitForView(viewClass2, 0, false, false)) {
                return true;
            }
            this.scroller.scroll(0);
            this.sleeper.sleep();
        }
        return false;
    }

    public boolean waitForView(View view) {
        return this.waitForView(view, 20000, true);
    }

    public boolean waitForView(View view, int timeout) {
        return this.waitForView(view, timeout, true);
    }

    public boolean waitForView(View view, int timeout, boolean scroll) {
        long startTime = System.currentTimeMillis();
        long endTime = startTime + (long)timeout;
        while (System.currentTimeMillis() < endTime) {
            this.sleeper.sleep();
            boolean foundAnyMatchingView = this.searcher.searchFor(view);
            if (foundAnyMatchingView) {
                return true;
            }
            if (!scroll) continue;
            this.scroller.scroll(0);
        }
        return false;
    }

    public View waitForView(int id) {
        ArrayList<Object> views = new ArrayList();
        long startTime = System.currentTimeMillis();
        long endTime = startTime + 10000L;
        while (System.currentTimeMillis() <= endTime) {
            this.sleeper.sleep();
            views = this.viewFetcher.getAllViews(false);
            for (View view : views) {
                if (view.getId() != id) continue;
                views = null;
                return view;
            }
        }
        return null;
    }

    public boolean waitForText(String text) {
        return this.waitForText(text, 0, 20000L, true);
    }

    public boolean waitForText(String text, int expectedMinimumNumberOfMatches) {
        return this.waitForText(text, expectedMinimumNumberOfMatches, 20000L, true);
    }

    public boolean waitForText(String text, int expectedMinimumNumberOfMatches, long timeout) {
        return this.waitForText(text, expectedMinimumNumberOfMatches, timeout, true);
    }

    public boolean waitForText(String text, int expectedMinimumNumberOfMatches, long timeout, boolean scroll) {
        return this.waitForText(text, expectedMinimumNumberOfMatches, timeout, scroll, false);
    }

    public boolean waitForText(String text, int expectedMinimumNumberOfMatches, long timeout, boolean scroll, boolean onlyVisible) {
        boolean foundAnyTextView;
        long endTime = System.currentTimeMillis() + timeout;
        do {
            boolean timedOut;
            boolean bl = timedOut = System.currentTimeMillis() > endTime;
            if (timedOut) {
                return false;
            }
            this.sleeper.sleep();
        } while (!(foundAnyTextView = this.searcher.searchFor(TextView.class, text, expectedMinimumNumberOfMatches, scroll, onlyVisible)));
        return true;
    }

    public <T extends View> T waitForAndGetView(int index, Class<T> classToFilterBy) {
        int newIndex;
        long endTime = System.currentTimeMillis() + 10000L;
        while (System.currentTimeMillis() <= endTime && !this.waitForView(classToFilterBy, index, true, true)) {
        }
        int numberOfUniqueViews = this.searcher.getNumberOfUniqueViews();
        ArrayList<T> views = RobotiumUtils.removeInvisibleViews(this.viewFetcher.getCurrentViews(classToFilterBy));
        if (views.size() < numberOfUniqueViews && (newIndex = index - (numberOfUniqueViews - views.size())) >= 0) {
            index = newIndex;
        }
        View view = null;
        try {
            view = (View)views.get(index);
        }
        catch (IndexOutOfBoundsException exception) {
            Assert.assertTrue((String)(classToFilterBy.getSimpleName() + " with index " + index + " is not available!"), (boolean)false);
        }
        views = null;
        return (T)view;
    }
}

