/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.id.LayerId;
import com.sun.electric.database.text.PrefPackage;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.user.User;
import java.awt.Color;
import java.io.Serializable;
import java.util.Arrays;
import java.util.prefs.Preferences;

public class GraphicsPreferences
extends PrefPackage {
    private static final String KEY_TRANSPARENT_COLOR = "TransparentLayer";
    private static final String KEY_PATTERN_DISPLAY = "UsePatternDisplayFor";
    private static final String KEY_PATTERN_PRINTER = "UsePatternPrinterFor";
    private static final String KEY_OUTLINE = "OutlinePatternFor";
    private static final String KEY_TRANSPARENT = "TransparentLayerFor";
    private static final String KEY_COLOR = "ColorFor";
    private static final String KEY_OPACITY = "OpacityFor";
    private static final String KEY_PATTERN = "PatternFor";
    private static final String KEY_TRANSPARENCY_MODE = "3DTransparencyModeOf";
    private static final String KEY_TRANSPARENCY_FACTOR = "3DTransparencyFactorOf";
    private static final String KEY_TEXT_VISIBILITY = "TextVisibility";
    public static final int RGB_MASK = 0xFFFFFF;
    @PrefPackage.IntegerPref(node="tool/user", key="PortDisplayLevel", factory=0)
    public int portDisplayLevel;
    private static final int DEF_PORT_DISPLAY_LEVEL = 0;
    @PrefPackage.IntegerPref(node="tool/user", key="ExportDisplayLevel", factory=0)
    public int exportDisplayLevel;
    private static final int DEF_EXPORT_DISPLAY_LEVEL = 0;
    @PrefPackage.StringPref(node="tool/user", key="DefaultFont", factory="SansSerif")
    public String defaultFont;
    public static final String FACTORY_DEFAULT_FONT = "SansSerif";
    @PrefPackage.BooleanPref(node="tool/user", key="ShowTempNames", factory=false)
    public boolean showTempNames;
    private final transient TechPool techPool;
    private final Color[] defaultColors;
    private final boolean[] textVisibility;
    private final TechData[] techData;

    public GraphicsPreferences(boolean factory) {
        this(factory, TechPool.getThreadTechPool());
    }

    public GraphicsPreferences(boolean factory, TechPool techPool) {
        super(factory);
        this.techPool = techPool;
        int maxTechIndex = -1;
        for (Technology tech : techPool.values()) {
            maxTechIndex = Math.max(maxTechIndex, tech.getId().techIndex);
        }
        this.techData = new TechData[maxTechIndex + 1];
        Preferences prefRoot = factory ? GraphicsPreferences.getFactoryPrefRoot() : GraphicsPreferences.getPrefRoot();
        Preferences techPrefs = prefRoot.node("technology/technologies");
        Preferences userPrefs = prefRoot.node("tool/user");
        for (Technology tech : techPool.values()) {
            this.techData[tech.getId().techIndex] = new TechData(tech, techPrefs);
        }
        User.ColorPrefType[] colorPrefTypes = (User.ColorPrefType[])User.ColorPrefType.class.getEnumConstants();
        this.defaultColors = new Color[colorPrefTypes.length];
        for (int i = 0; i < colorPrefTypes.length; ++i) {
            Color color;
            User.ColorPrefType e = colorPrefTypes[i];
            Color factoryColor = e.getFactoryDefaultColor();
            int factoryRgb = factoryColor.getRGB();
            int rgb = userPrefs.getInt(e.getPrefKey(), factoryRgb);
            this.defaultColors[i] = color = rgb == factoryRgb ? factoryColor : new Color(rgb);
        }
        AbstractTextDescriptor.TextType[] textTypes = (AbstractTextDescriptor.TextType[])AbstractTextDescriptor.TextType.class.getEnumConstants();
        this.textVisibility = new boolean[textTypes.length];
        for (int i = 0; i < textTypes.length; ++i) {
            this.textVisibility[i] = userPrefs.getBoolean(textTypes[i].getKey(KEY_TEXT_VISIBILITY), true);
        }
    }

    @Override
    public void putPrefs(Preferences prefRoot, boolean removeDefaults) {
        this.putPrefs(prefRoot, removeDefaults, null);
    }

    public void putPrefs(Preferences prefRoot, boolean removeDefaults, GraphicsPreferences oldGp) {
        Enum t;
        super.putPrefs(prefRoot, removeDefaults);
        if (oldGp != null && oldGp.techPool != this.techPool) {
            oldGp = null;
        }
        Preferences techPrefs = prefRoot.node("technology/technologies");
        Preferences userPrefs = prefRoot.node("tool/user");
        for (int techIndex = 0; techIndex < this.techData.length; ++techIndex) {
            TechData td = this.techData[techIndex];
            if (td == null) continue;
            TechData oldTd = oldGp != null ? oldGp.techData[techIndex] : null;
            td.putPrefs(techPrefs, removeDefaults, oldTd);
        }
        if (oldGp == null || this.defaultColors != oldGp.defaultColors) {
            User.ColorPrefType[] colorPrefTypes = (User.ColorPrefType[])User.ColorPrefType.class.getEnumConstants();
            for (int i = 0; i < colorPrefTypes.length; ++i) {
                t = colorPrefTypes[i];
                if (removeDefaults && this.defaultColors[i].equals(((User.ColorPrefType)t).getFactoryDefaultColor())) {
                    userPrefs.remove(((User.ColorPrefType)t).getPrefKey());
                    continue;
                }
                userPrefs.putInt(((User.ColorPrefType)t).getPrefKey(), this.defaultColors[i].getRGB());
            }
        }
        if (oldGp == null || this.textVisibility != oldGp.textVisibility) {
            AbstractTextDescriptor.TextType[] textTypes = (AbstractTextDescriptor.TextType[])AbstractTextDescriptor.TextType.class.getEnumConstants();
            for (int i = 0; i < textTypes.length; ++i) {
                t = textTypes[i];
                String key = ((AbstractTextDescriptor.TextType)t).getKey(KEY_TEXT_VISIBILITY);
                if (removeDefaults && this.textVisibility[i]) {
                    userPrefs.remove(key);
                    continue;
                }
                userPrefs.putBoolean(key, this.textVisibility[i]);
            }
        }
    }

    public GraphicsPreferences withTransparentLayerColors(Technology tech, Color[] tranparentColors) {
        TechData td = this.getTechData(tech);
        return this.withTechData(td.withTransparentColors(tranparentColors));
    }

    public GraphicsPreferences withTransparentLayerColor(Technology tech, int transparentLayer, Color tranparentColor) {
        TechData td = this.getTechData(tech);
        return this.withTechData(td.withTransparentColor(transparentLayer, tranparentColor));
    }

    public GraphicsPreferences withGraphics(Layer layer, EGraphics graphics) {
        TechData td = this.getTechData(layer.getTechnology());
        return this.withTechData(td.withGraphics(layer, graphics));
    }

    public GraphicsPreferences withColor(User.ColorPrefType t, Color color) {
        if (color.equals(this.defaultColors[t.ordinal()])) {
            return this;
        }
        Color[] newDefaultColors = (Color[])this.defaultColors.clone();
        newDefaultColors[t.ordinal()] = color;
        return (GraphicsPreferences)this.withField("defaultColors", newDefaultColors);
    }

    public GraphicsPreferences withFactoryColor(User.ColorPrefType t) {
        return this.withColor(t, t.getFactoryDefaultColor());
    }

    public GraphicsPreferences withTextVisibilityOn(AbstractTextDescriptor.TextType t, boolean b) {
        if (b == this.textVisibility[t.ordinal()]) {
            return this;
        }
        boolean[] newTextVisibility = (boolean[])this.textVisibility.clone();
        newTextVisibility[t.ordinal()] = b;
        return (GraphicsPreferences)this.withField("textVisibility", newTextVisibility);
    }

    public GraphicsPreferences withPortDisplayLevel(int portDisplayLevel) {
        if (portDisplayLevel == this.portDisplayLevel) {
            return this;
        }
        return (GraphicsPreferences)this.withField("portDisplayLevel", portDisplayLevel);
    }

    public GraphicsPreferences withExportDisplayLevel(int exportDisplayLevel) {
        if (exportDisplayLevel == this.exportDisplayLevel) {
            return this;
        }
        return (GraphicsPreferences)this.withField("exportDisplayLevel", exportDisplayLevel);
    }

    public GraphicsPreferences withDisplayLevelReset() {
        return this.withPortDisplayLevel(0).withExportDisplayLevel(0);
    }

    public GraphicsPreferences withDefaultFont(String defaultFont) {
        if (defaultFont.equals(this.defaultFont)) {
            return this;
        }
        return (GraphicsPreferences)this.withField("defaultFont", defaultFont);
    }

    public GraphicsPreferences withShowTempNames(boolean showTempNames) {
        if (showTempNames == this.isShowTempNames()) {
            return this;
        }
        return (GraphicsPreferences)this.withField("showTempNames", showTempNames);
    }

    public int getNumTransparentLayers(Technology tech) {
        return this.getTechData((Technology)tech).transparentColors.length;
    }

    public Color[] getTransparentLayerColors(Technology tech) {
        return (Color[])this.getTechData((Technology)tech).transparentColors.clone();
    }

    public Color[] getColorMap(Technology tech) {
        return this.getTechData(tech).getColorMap();
    }

    public EGraphics getGraphics(Layer layer) {
        return this.getTechData((Technology)layer.getTechnology()).layerGraphics[layer.getIndex()];
    }

    public Color getColor(User.ColorPrefType t) {
        return this.defaultColors[t.ordinal()];
    }

    public boolean isTextVisibilityOn(AbstractTextDescriptor.TextType t) {
        return this.textVisibility[t.ordinal()];
    }

    public boolean isShowTempNames() {
        return this.showTempNames;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GraphicsPreferences) {
            GraphicsPreferences that = (GraphicsPreferences)o;
            return this.techPool == that.techPool && Arrays.equals(this.techData, that.techData) && Arrays.equals(this.defaultColors, that.defaultColors) && Arrays.equals(this.textVisibility, that.textVisibility) && this.portDisplayLevel == that.portDisplayLevel && this.exportDisplayLevel == that.exportDisplayLevel && this.defaultFont.equals(that.defaultFont) && this.isShowTempNames() == that.isShowTempNames();
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    private GraphicsPreferences withTechData(TechData td) {
        int techIndex = td.tech.getId().techIndex;
        if (td == this.techData[techIndex]) {
            return this;
        }
        TechData[] newTechData = (TechData[])this.techData.clone();
        newTechData[techIndex] = td;
        return (GraphicsPreferences)this.withField("techData", newTechData);
    }

    private TechData getTechData(Technology tech) {
        TechData td = this.techData[tech.getId().techIndex];
        if (td.tech != tech) {
            System.out.println("ERROR: Technology " + tech.getTechName() + " HAS INDEX " + tech.getId().techIndex + " WHICH IS TECHNOLOGY " + td.tech.getTechName());
        }
        assert (td.tech == tech);
        return td;
    }

    protected String getKeyIn(String what, LayerId layerId) {
        int len = what.length() + layerId.fullName.length() + 1;
        StringBuilder sb = new StringBuilder(len);
        sb.append(what);
        sb.append(layerId.name);
        sb.append("In");
        sb.append(layerId.techId.techName);
        assert (sb.length() == len);
        return sb.toString();
    }

    private class TechData
    implements Serializable {
        private final Technology tech;
        private final Color[] transparentColors;
        private transient Color[] colorMap;
        private final EGraphics[] layerGraphics;

        private TechData(Technology tech, Preferences techPrefs) {
            this.tech = tech;
            assert (GraphicsPreferences.this.techPool.getTech(tech.getId()) == tech);
            this.transparentColors = tech.getFactoryTransparentLayerColors();
            for (int i = 0; i < this.transparentColors.length; ++i) {
                int factoryRgb;
                String key = GraphicsPreferences.this.getKey(GraphicsPreferences.KEY_TRANSPARENT_COLOR + (i + 1) + "For", tech.getId());
                int rgb = techPrefs.getInt(key, factoryRgb = this.transparentColors[i].getRGB());
                if (rgb == factoryRgb) continue;
                this.transparentColors[i] = new Color(rgb);
            }
            this.layerGraphics = new EGraphics[tech.getNumLayers()];
            for (int layerIndex = 0; layerIndex < this.layerGraphics.length; ++layerIndex) {
                EGraphics factoryGraphics;
                Layer layer = tech.getLayer(layerIndex);
                LayerId layerId = layer.getId();
                EGraphics graphics = factoryGraphics = layer.getFactoryGraphics();
                String keyPatternDisplay = GraphicsPreferences.this.getKeyIn(GraphicsPreferences.KEY_PATTERN_DISPLAY, layerId);
                boolean factoryPatternDisplay = factoryGraphics.isPatternedOnDisplay();
                boolean patternDisplay = techPrefs.getBoolean(keyPatternDisplay, factoryPatternDisplay);
                graphics = graphics.withPatternedOnDisplay(patternDisplay);
                String keyPatternPrinter = GraphicsPreferences.this.getKeyIn(GraphicsPreferences.KEY_PATTERN_PRINTER, layerId);
                boolean factoryPatternPrinter = factoryGraphics.isPatternedOnPrinter();
                boolean patternPrinter = techPrefs.getBoolean(keyPatternPrinter, factoryPatternPrinter);
                graphics = graphics.withPatternedOnPrinter(patternPrinter);
                String keyOutline = GraphicsPreferences.this.getKeyIn(GraphicsPreferences.KEY_OUTLINE, layerId);
                EGraphics.Outline factoryOutline = factoryGraphics.getOutlined();
                int outlineIndex = techPrefs.getInt(keyOutline, factoryOutline.getIndex());
                EGraphics.Outline outline = EGraphics.Outline.findOutline(outlineIndex);
                graphics = graphics.withOutlined(outline);
                String keyTransparent = GraphicsPreferences.this.getKeyIn(GraphicsPreferences.KEY_TRANSPARENT, layerId);
                int factoryTransparent = factoryGraphics.getTransparentLayer();
                int transparent = techPrefs.getInt(keyTransparent, factoryTransparent);
                graphics = graphics.withTransparentLayer(transparent);
                String keyColor = GraphicsPreferences.this.getKeyIn(GraphicsPreferences.KEY_COLOR, layerId);
                int factoryColorRgb = factoryGraphics.getRGB();
                int colorRgb = techPrefs.getInt(keyColor, factoryColorRgb);
                graphics = graphics.withColor(new Color(colorRgb));
                String keyOpacity = GraphicsPreferences.this.getKeyIn(GraphicsPreferences.KEY_OPACITY, layerId);
                double factoryOpacity = factoryGraphics.getOpacity();
                double opacity = techPrefs.getDouble(keyOpacity, factoryOpacity);
                graphics = graphics.withOpacity(opacity);
                String keyPattern = GraphicsPreferences.this.getKeyIn(GraphicsPreferences.KEY_PATTERN, layerId);
                String factoryPatternStr = factoryGraphics.getPatternString();
                String patternStr = techPrefs.get(keyPattern, factoryPatternStr);
                graphics = graphics.withPattern(patternStr);
                String keyTransparencyMode = GraphicsPreferences.this.getKey(GraphicsPreferences.KEY_TRANSPARENCY_MODE, layerId);
                String factoryTransparencyModeStr = factoryGraphics.getTransparencyMode().name();
                String transparencyModeStr = techPrefs.get(keyTransparencyMode, factoryTransparencyModeStr);
                EGraphics.J3DTransparencyOption transparencyMode = EGraphics.J3DTransparencyOption.valueOf(transparencyModeStr);
                graphics = graphics.withTransparencyMode(transparencyMode);
                String keyTransparencyFactor = GraphicsPreferences.this.getKey(GraphicsPreferences.KEY_TRANSPARENCY_FACTOR, layerId);
                double factoryTransparenceyFactor = factoryGraphics.getTransparencyFactor();
                double transparencyFactor = techPrefs.getDouble(keyTransparencyFactor, factoryTransparenceyFactor);
                this.layerGraphics[layerIndex] = graphics = graphics.withTransparencyFactor(transparencyFactor);
            }
        }

        private TechData(TechData that, Color[] transparentColors, EGraphics[] layerGraphics) {
            this.tech = that.tech;
            this.transparentColors = transparentColors;
            this.layerGraphics = layerGraphics;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof TechData) {
                TechData that = (TechData)o;
                return this.tech == that.tech && Arrays.equals(this.transparentColors, that.transparentColors) && Arrays.equals(this.layerGraphics, that.layerGraphics);
            }
            return false;
        }

        public int hashCode() {
            return 0;
        }

        private void putPrefs(Preferences techPrefs, boolean removeDefaults, TechData oldTd) {
            if (oldTd != null && oldTd.tech != this.tech) {
                oldTd = null;
            }
            if (oldTd == null || this.transparentColors != oldTd.transparentColors) {
                Color[] factoryColors = this.tech.getFactoryTransparentLayerColors();
                for (int i = 0; i < factoryColors.length; ++i) {
                    String key = GraphicsPreferences.this.getKey(GraphicsPreferences.KEY_TRANSPARENT_COLOR + (i + 1) + "For", this.tech.getId());
                    int factoryRgb = factoryColors[i].getRGB();
                    int rgb = this.transparentColors[i].getRGB();
                    if (removeDefaults && rgb == factoryRgb) {
                        techPrefs.remove(key);
                        continue;
                    }
                    techPrefs.putInt(key, rgb);
                }
            }
            assert (this.layerGraphics.length == this.tech.getNumLayers());
            for (int layerIndex = 0; layerIndex < this.layerGraphics.length; ++layerIndex) {
                Layer layer = this.tech.getLayer(layerIndex);
                LayerId layerId = layer.getId();
                EGraphics graphics = this.layerGraphics[layerIndex];
                if (oldTd != null && graphics == oldTd.layerGraphics[layerIndex]) continue;
                EGraphics factoryGraphics = layer.getFactoryGraphics();
                String keyPatternDisplay = GraphicsPreferences.this.getKeyIn(GraphicsPreferences.KEY_PATTERN_DISPLAY, layerId);
                if (removeDefaults && graphics.isPatternedOnDisplay() == factoryGraphics.isPatternedOnDisplay()) {
                    techPrefs.remove(keyPatternDisplay);
                } else {
                    techPrefs.putBoolean(keyPatternDisplay, graphics.isPatternedOnDisplay());
                }
                String keyPatternPrinter = GraphicsPreferences.this.getKeyIn(GraphicsPreferences.KEY_PATTERN_PRINTER, layerId);
                if (removeDefaults && graphics.isPatternedOnPrinter() == factoryGraphics.isPatternedOnPrinter()) {
                    techPrefs.remove(keyPatternPrinter);
                } else {
                    techPrefs.putBoolean(keyPatternPrinter, graphics.isPatternedOnPrinter());
                }
                String keyOutline = GraphicsPreferences.this.getKeyIn(GraphicsPreferences.KEY_OUTLINE, layerId);
                if (removeDefaults && graphics.getOutlined() == factoryGraphics.getOutlined()) {
                    techPrefs.remove(keyOutline);
                } else {
                    techPrefs.putInt(keyOutline, graphics.getOutlined().getIndex());
                }
                String keyTransparent = GraphicsPreferences.this.getKeyIn(GraphicsPreferences.KEY_TRANSPARENT, layerId);
                if (removeDefaults && graphics.getTransparentLayer() == factoryGraphics.getTransparentLayer()) {
                    techPrefs.remove(keyTransparent);
                } else {
                    techPrefs.putInt(keyTransparent, graphics.getTransparentLayer());
                }
                String keyColor = GraphicsPreferences.this.getKeyIn(GraphicsPreferences.KEY_COLOR, layerId);
                if (removeDefaults && graphics.getColor().equals(factoryGraphics.getColor())) {
                    techPrefs.remove(keyColor);
                } else {
                    techPrefs.putInt(keyColor, graphics.getRGB());
                }
                String keyOpacity = GraphicsPreferences.this.getKeyIn(GraphicsPreferences.KEY_OPACITY, layerId);
                if (removeDefaults && graphics.getOpacity() == factoryGraphics.getOpacity()) {
                    techPrefs.remove(keyOpacity);
                } else {
                    techPrefs.putDouble(keyOpacity, graphics.getOpacity());
                }
                String keyPattern = GraphicsPreferences.this.getKeyIn(GraphicsPreferences.KEY_PATTERN, layerId);
                if (removeDefaults && Arrays.equals(graphics.getPattern(), factoryGraphics.getPattern())) {
                    techPrefs.remove(keyPattern);
                } else {
                    techPrefs.put(keyPattern, graphics.getPatternString());
                }
                String keyTrancparencyMode = GraphicsPreferences.this.getKey(GraphicsPreferences.KEY_TRANSPARENCY_MODE, layerId);
                if (removeDefaults && graphics.getTransparencyMode() == factoryGraphics.getTransparencyMode()) {
                    techPrefs.remove(keyTrancparencyMode);
                } else {
                    techPrefs.put(keyTrancparencyMode, graphics.getTransparencyMode().name());
                }
                String keyTrancparencyFactor = GraphicsPreferences.this.getKey(GraphicsPreferences.KEY_TRANSPARENCY_FACTOR, layerId);
                if (removeDefaults && graphics.getTransparencyFactor() == factoryGraphics.getTransparencyFactor()) {
                    techPrefs.remove(keyTrancparencyFactor);
                    continue;
                }
                techPrefs.putDouble(keyTrancparencyFactor, graphics.getTransparencyFactor());
            }
        }

        private TechData withTransparentColor(int transparentLayer, Color transparentColor) {
            if (transparentLayer < 0 || transparentLayer >= this.transparentColors.length) {
                throw new IllegalArgumentException();
            }
            if (transparentColor.equals(this.transparentColors[transparentLayer])) {
                return this;
            }
            Color[] newTransparentColors = (Color[])this.transparentColors.clone();
            newTransparentColors[transparentLayer] = transparentColor;
            return new TechData(this, newTransparentColors, this.layerGraphics);
        }

        private TechData withTransparentColors(Color[] transparentColors) {
            if (Arrays.equals(this.transparentColors, transparentColors)) {
                return this;
            }
            Color[] factoryColors = this.tech.getFactoryTransparentLayerColors();
            if (transparentColors.length < factoryColors.length) {
                throw new IllegalArgumentException();
            }
            for (Color color : transparentColors = (Color[])transparentColors.clone()) {
                if (color.getAlpha() == 255) continue;
                throw new IllegalArgumentException();
            }
            return new TechData(this, transparentColors, this.layerGraphics);
        }

        private TechData withGraphics(Layer layer, EGraphics graphics) {
            assert (layer.getTechnology() == this.tech);
            int layerIndex = layer.getIndex();
            EGraphics currentGraphics = this.layerGraphics[layerIndex];
            if (currentGraphics.equals(graphics)) {
                return this;
            }
            EGraphics[] newLayerGraphics = (EGraphics[])this.layerGraphics.clone();
            newLayerGraphics[layerIndex] = graphics;
            return new TechData(this, this.transparentColors, newLayerGraphics);
        }

        private Color[] getColorMap() {
            if (this.colorMap == null) {
                this.colorMap = Technology.makeColorMap(this.transparentColors);
            }
            return (Color[])this.colorMap.clone();
        }
    }
}

