/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.lang;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.variable.CodeExpression;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EvalJavaBsh {
    private static Method evalMethod;
    private static Method sourceMethod;
    private static Method setMethod;
    private static Method getMethod;
    private static Method getTargetMethod;
    private static boolean beanShellChecked;
    private static Class<?> interpreterClass;
    private static Class<?> targetErrorClass;
    private static Class<?> evalErrorClass;
    private static final Pattern atPat;
    private static final Pattern pPat;
    private static HashMap<String, String> replaceHash;
    private Object envObject = null;
    private Stack<VarContext> contextStack = new Stack();
    private Stack<Object> infoStack = new Stack();
    public static final EvalJavaBsh evalJavaBsh;
    private static boolean DEBUG;
    private static boolean DEBUGSTACKTRACE;

    public EvalJavaBsh() {
        if (!EvalJavaBsh.hasBeanShell()) {
            return;
        }
        try {
            this.envObject = interpreterClass.newInstance();
        }
        catch (Exception e) {
            System.out.println("Can't create an instance of the Bean Shell: " + e.getMessage());
            this.envObject = null;
            return;
        }
        this.setVariable("evalJavaBsh", this);
        this.setVariable("launchingThread", Thread.currentThread());
        try {
            this.doEval("Object P(String par) { return evalJavaBsh.P(par); }");
            this.doEval("Object PAR(String par) { return evalJavaBsh.PAR(par); }");
            this.doEval("import com.sun.electric.tool.user.menus.MenuCommands;");
            this.doEval("import com.sun.electric.database.hierarchy.*;");
            this.doEval("import com.sun.electric.database.prototype.*;");
            this.doEval("import com.sun.electric.database.topology.*;");
            this.doEval("import com.sun.electric.database.variable.ElectricObject;");
            this.doEval("import com.sun.electric.database.variable.FlagSet;");
            this.doEval("import com.sun.electric.database.variable.TextDescriptor;");
            this.doEval("import com.sun.electric.database.variable.VarContext;");
            this.doEval("import com.sun.electric.database.variable.Variable;");
            this.doEval("import com.sun.electric.tool.io.*;");
        }
        catch (VarContext.EvalException e) {
            e.printStackTrace(System.out);
        }
    }

    public synchronized VarContext getCurrentContext() {
        return this.contextStack.peek();
    }

    public synchronized Object getCurrentInfo() {
        return this.infoStack.peek();
    }

    public static String replace(String expr) {
        String result2 = replaceHash.get(expr);
        if (result2 != null) {
            return result2;
        }
        StringBuffer sb = new StringBuffer();
        Matcher atMat = atPat.matcher(expr);
        while (atMat.find()) {
            atMat.appendReplacement(sb, "P(\"" + atMat.group(1) + "\")");
        }
        atMat.appendTail(sb);
        result2 = sb.toString();
        sb = new StringBuffer();
        Matcher pMat = pPat.matcher(result2);
        while (pMat.find()) {
            if (pMat.group(2).startsWith("ATTR_")) {
                pMat.appendReplacement(sb, pMat.group(0));
                continue;
            }
            pMat.appendReplacement(sb, pMat.group(1) + "(\"ATTR_" + pMat.group(2) + "\")");
        }
        pMat.appendTail(sb);
        result2 = sb.toString();
        if (result2.equals(expr)) {
            result2 = expr;
        }
        replaceHash.put(expr, result2);
        return result2;
    }

    public synchronized Object evalVarObject(CodeExpression ce, VarContext context, Object info) throws VarContext.EvalException {
        Object ret;
        assert (ce.isJava());
        String expr = EvalJavaBsh.replace(ce.getExpr());
        if (context == null) {
            context = VarContext.globalContext;
        }
        for (int i = 0; i < this.contextStack.size(); ++i) {
            VarContext vc = (VarContext)this.contextStack.get(i);
            Object inf = this.infoStack.get(i);
            if (vc != context || inf != info) continue;
            throw new VarContext.EvalException("JavaBeanShell Eval recursion error");
        }
        this.contextStack.push(context);
        this.infoStack.push(info);
        try {
            ret = this.doEval(expr);
        }
        catch (VarContext.EvalException e) {
            this.contextStack.pop();
            this.infoStack.pop();
            throw e;
        }
        this.contextStack.pop();
        this.infoStack.pop();
        if (DEBUG) {
            System.out.println("BSH: " + expr.toString() + " --> " + ret);
        }
        return ret;
    }

    public synchronized Object P(String name) throws VarContext.EvalException {
        VarContext context = this.contextStack.peek();
        Object val = context.lookupVarEval(name);
        if (DEBUG) {
            System.out.println(name + " ---> " + val + " (" + val.getClass() + ")");
        }
        return val;
    }

    public synchronized Object PAR(String name) throws VarContext.EvalException {
        throw new VarContext.EvalException("The PAR() function has been disabled because it confounds the techniques used in Topology.java for detecting when Cell instances have the same transistor sizes. RKao");
    }

    public static void runScript(String script) {
        runScriptJob job = new runScriptJob(script);
        job.startJob();
    }

    public static EditingPreferences getEditingPreferences() {
        return Job.getRunningJob().getEditingPreferences();
    }

    public static void displayCell(Cell cell) {
        Job curJob = Job.getRunningJob();
        if (curJob instanceof runScriptJob) {
            ((runScriptJob)curJob).displayCell(cell);
        }
    }

    public static List<Geometric> getHighlighted() {
        Job curJob = Job.getRunningJob();
        if (curJob instanceof runScriptJob) {
            return ((runScriptJob)curJob).highlightedEObjs;
        }
        return null;
    }

    public static Job runScriptJob(String script) {
        return new runScriptJob(script);
    }

    public static boolean hasBeanShell() {
        if (!beanShellChecked) {
            beanShellChecked = true;
            try {
                interpreterClass = Class.forName("bsh.Interpreter");
                targetErrorClass = Class.forName("bsh.TargetError");
                evalErrorClass = Class.forName("bsh.EvalError");
            }
            catch (ClassNotFoundException e) {
                TextUtils.recordMissingComponent("Bean Shell");
                interpreterClass = null;
                return false;
            }
            try {
                evalMethod = interpreterClass.getMethod("eval", String.class);
                sourceMethod = interpreterClass.getMethod("source", String.class);
                setMethod = interpreterClass.getMethod("set", String.class, Object.class);
                getMethod = interpreterClass.getMethod("get", String.class);
                getTargetMethod = targetErrorClass.getMethod("getTarget", null);
            }
            catch (NoSuchMethodException e) {
                System.out.println("Can't find methods in the Bean Shell: " + e.getMessage());
                interpreterClass = null;
                return false;
            }
        }
        return interpreterClass != null;
    }

    public void setVariable(String name, Object value) {
        try {
            if (this.envObject != null) {
                setMethod.invoke(this.envObject, name, value);
            }
        }
        catch (Exception e) {
            EvalJavaBsh.handleInvokeException(e, "Bean shell error setting " + name + " to " + value + ": ");
        }
    }

    public Object getVariable(String name) {
        try {
            if (this.envObject != null) {
                return getMethod.invoke(this.envObject, name);
            }
        }
        catch (Exception e) {
            EvalJavaBsh.handleInvokeException(e, "Bean shell error getting variable " + name);
        }
        return null;
    }

    private Object doEval(String line) throws VarContext.EvalException {
        Object returnVal;
        block4: {
            returnVal = null;
            try {
                if (this.envObject != null) {
                    returnVal = evalMethod.invoke(this.envObject, line);
                }
            }
            catch (Exception e) {
                VarContext.EvalException ee;
                if (e instanceof InvocationTargetException && (ee = this.getEvalException((InvocationTargetException)e)) != null) {
                    throw ee;
                }
                if (EvalJavaBsh.handleInvokeException(e, "Bean shell error evaluating " + line)) break block4;
                throw new VarContext.EvalException(e.getMessage(), e);
            }
        }
        return returnVal;
    }

    public Object doEvalLine(String line) {
        Object obj = null;
        try {
            obj = this.doEval(line);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }

    public boolean isValidJava(String line) {
        try {
            if (this.envObject != null) {
                evalMethod.invoke(this.envObject, line);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void doSource(String file) throws JobException {
        try {
            if (this.envObject != null) {
                sourceMethod.invoke(this.envObject, file);
            }
        }
        catch (Exception e) {
            String description = "Java Bean shell error sourcing '" + file + "'";
            if (e instanceof InvocationTargetException) {
                Throwable t = e.getCause();
                if (t != null) {
                    EvalJavaBsh.handleBshError((Exception)t, description);
                }
                if (evalErrorClass.isInstance(t)) {
                    t = EvalJavaBsh.doGetTarget(t);
                }
                throw new JobException(t);
            }
            if (e instanceof IllegalArgumentException) {
                System.out.println(description + ": " + e.getMessage());
                if (DEBUG) {
                    e.printStackTrace(System.out);
                }
                throw new JobException(e);
            }
            if (e instanceof IllegalAccessException) {
                System.out.println(description + ": " + e.getMessage());
                if (DEBUG) {
                    e.printStackTrace(System.out);
                }
                throw new JobException(e);
            }
            System.out.println("Unhandled Exception: ");
            System.out.println(description + ": " + e.getMessage());
            e.printStackTrace(System.out);
            throw new JobException(e);
        }
    }

    private static Throwable doGetTarget(Object ex) {
        Throwable returnVal = null;
        if (interpreterClass != null && targetErrorClass.isInstance(ex)) {
            try {
                returnVal = (Throwable)getTargetMethod.invoke(ex, (Object[])null);
            }
            catch (Exception e) {
                EvalJavaBsh.handleInvokeException(e, "Java Bean shell error getting exception target");
            }
        }
        return returnVal;
    }

    private VarContext.EvalException getEvalException(InvocationTargetException e) {
        Throwable t = e.getCause();
        if (t == null) {
            return null;
        }
        Throwable tt = EvalJavaBsh.doGetTarget(t);
        if (tt == null) {
            return null;
        }
        if (tt instanceof VarContext.EvalException) {
            return (VarContext.EvalException)tt;
        }
        return null;
    }

    private static boolean handleInvokeException(Exception e, String description) {
        boolean handled = false;
        if (e instanceof InvocationTargetException) {
            Throwable t = e.getCause();
            if (t != null) {
                handled = EvalJavaBsh.handleBshError((Exception)t, description);
            }
        } else if (e instanceof IllegalArgumentException) {
            System.out.println(description + ": " + e.getMessage());
            if (DEBUG) {
                e.printStackTrace(System.out);
            }
        } else if (e instanceof IllegalAccessException) {
            System.out.println(description + ": " + e.getMessage());
            if (DEBUG) {
                e.printStackTrace(System.out);
            }
        } else {
            System.out.println("Unhandled Exception: ");
            System.out.println(description + ": " + e.getMessage());
            e.printStackTrace(System.out);
            handled = false;
        }
        return handled;
    }

    private static boolean handleBshError(Exception e, String description) {
        if (targetErrorClass.isInstance(e)) {
            Throwable t = EvalJavaBsh.doGetTarget(e);
            if (t != null) {
                if (t instanceof VarContext.EvalException) {
                    if (DEBUG) {
                        System.out.println("Java EvalException: " + description + ": " + t.getMessage());
                        if (DEBUGSTACKTRACE) {
                            e.printStackTrace(System.out);
                        }
                    }
                } else {
                    if (t.getMessage() != null) {
                        System.out.println(description + ": " + t.getMessage());
                    } else if (t.getStackTrace() != null) {
                        System.out.println(description + ": ");
                        t.printStackTrace(System.out);
                    } else {
                        System.out.println(description + ": " + t);
                    }
                    if (DEBUGSTACKTRACE) {
                        e.printStackTrace(System.out);
                    }
                }
            }
        } else {
            System.out.println("Unhandled Java Bsh Exception: " + description + ":\n " + e.getMessage());
            if (DEBUGSTACKTRACE) {
                e.printStackTrace(System.out);
            }
            return false;
        }
        return true;
    }

    static {
        beanShellChecked = false;
        interpreterClass = null;
        atPat = Pattern.compile("@(\\w+)");
        pPat = Pattern.compile("(P|PAR)\\(\"(\\w+)\"\\)");
        replaceHash = new HashMap();
        evalJavaBsh = new EvalJavaBsh();
        DEBUG = false;
        DEBUGSTACKTRACE = false;
    }

    private static class runScriptJob
    extends Job {
        private String script;
        private Cell cell;
        private List<Geometric> highlightedEObjs;

        protected runScriptJob(String script) {
            super("JavaBsh script: " + script, User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            Highlighter highlighter;
            this.script = script;
            this.highlightedEObjs = null;
            WindowFrame wf = WindowFrame.getCurrentWindowFrame(false);
            if (wf != null && (highlighter = wf.getContent().getHighlighter()) != null) {
                this.highlightedEObjs = highlighter.getHighlightedEObjs(true, true);
            }
        }

        @Override
        public boolean doIt() throws JobException {
            EvalJavaBsh evaluator = new EvalJavaBsh();
            evaluator.doSource(this.script);
            return true;
        }

        private void displayCell(Cell cell) {
            if (this.cell != null) {
                return;
            }
            this.cell = cell;
            this.fieldVariableChanged("cell");
        }

        @Override
        public void terminateOK() {
            if (this.cell != null) {
                Job.getUserInterface().displayCell(this.cell);
            }
        }
    }
}

