/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class NewExport
extends EDialog {
    private static String latestCharacteristic;
    private JCheckBox alwaysDrawn;
    private JCheckBox bodyOnly;
    private JButton cancel;
    private JComboBox exportCharacteristics;
    private JTextField exportName;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JButton ok;
    private JTextField referenceExport;

    public NewExport(Frame parent) {
        super(parent, true);
        NodeInst ni;
        Highlight high;
        ElectricObject eObj;
        Highlighter h;
        List<Highlight> highs;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        String last2 = latestCharacteristic;
        for (PortCharacteristic ch : PortCharacteristic.getOrderedCharacteristics()) {
            this.exportCharacteristics.addItem(ch.getName());
        }
        boolean setDefaultChar = false;
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd != null && (highs = (h = wnd.getHighlighter()).getHighlights()).size() == 1 && (eObj = (high = highs.get(0)).getElectricObject()) instanceof PortInst && (ni = ((PortInst)eObj).getNodeInst()).isCellInstance()) {
            Export e = (Export)((PortInst)eObj).getPortProto();
            this.exportCharacteristics.setSelectedItem(e.getCharacteristic().getName());
            setDefaultChar = true;
        }
        if (!setDefaultChar && last2 != null) {
            this.exportCharacteristics.setSelectedItem(last2);
        }
        this.referenceExport.setEditable(false);
        this.exportName.grabFocus();
        this.finishInitialization();
        this.setVisible(true);
    }

    @Override
    protected void escapePressed() {
        this.cancelActionPerformed(null);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.exportName = new JTextField();
        this.exportCharacteristics = new JComboBox();
        this.alwaysDrawn = new JCheckBox();
        this.bodyOnly = new JCheckBox();
        this.cancel = new JButton();
        this.ok = new JButton();
        this.referenceExport = new JTextField();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Create New Export");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                NewExport.this.closeDialog(evt);
            }
        });
        this.jLabel1.setText("Export name:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("Export characteristics:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText("Reference export:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.exportName.setPreferredSize(new Dimension(250, 20));
        this.exportName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewExport.this.exportNameActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.exportName, gridBagConstraints);
        this.exportCharacteristics.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewExport.this.exportCharacteristicsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.exportCharacteristics, gridBagConstraints);
        this.alwaysDrawn.setText("Always drawn");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.alwaysDrawn, gridBagConstraints);
        this.bodyOnly.setText("Body only");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.bodyOnly, gridBagConstraints);
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewExport.this.cancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 40, 4, 4);
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewExport.this.okActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 40);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.referenceExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewExport.this.referenceExportActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.referenceExport, gridBagConstraints);
        this.pack();
    }

    private void referenceExportActionPerformed(ActionEvent evt) {
        this.okActionPerformed(evt);
    }

    private void exportNameActionPerformed(ActionEvent evt) {
        this.okActionPerformed(evt);
    }

    private void exportCharacteristicsActionPerformed(ActionEvent evt) {
        latestCharacteristic = (String)this.exportCharacteristics.getSelectedItem();
        PortCharacteristic characteristic = PortCharacteristic.findCharacteristic(latestCharacteristic);
        this.referenceExport.setEditable(characteristic.isReference());
    }

    private void okActionPerformed(ActionEvent evt) {
        String name = this.exportName.getText();
        String referenceName = this.referenceExport.getText();
        String characteristics = (String)this.exportCharacteristics.getSelectedItem();
        boolean drawn = this.alwaysDrawn.isSelected();
        boolean body = this.bodyOnly.isSelected();
        if (name.length() <= 0) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Must enter an export name");
            return;
        }
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        Highlight h = wnd.getHighlighter().getOneHighlight();
        if (h == null) {
            return;
        }
        if (!h.isHighlightEOBJ()) {
            System.out.println("Must select a node");
            return;
        }
        ElectricObject eobj = h.getElectricObject();
        PortProto pp = null;
        if (eobj instanceof PortInst) {
            pp = ((PortInst)eobj).getPortProto();
            eobj = ((PortInst)eobj).getNodeInst();
        }
        if (!(eobj instanceof NodeInst)) {
            System.out.println("Must select a node");
            return;
        }
        NodeInst ni = (NodeInst)eobj;
        Cell parent = ni.getParent();
        if (pp == null) {
            if (ni.getProto().getNumPorts() == 0) {
                System.out.println("There is no port to export");
                return;
            }
            pp = ni.getProto().getPort(0);
        }
        new MakeExport(parent, ni, pp, name, body, drawn, characteristics, referenceName);
        this.closeDialog(null);
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class MakeExport
    extends Job {
        private Cell cell;
        private NodeInst ni;
        private PortProto pp;
        private String name;
        private String referenceName;
        private boolean body;
        private boolean drawn;
        private String ch;

        protected MakeExport(Cell cell, NodeInst ni, PortProto pp, String name, boolean body, boolean drawn, String ch, String referenceName) {
            super("Make Export", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.ni = ni;
            this.pp = pp;
            this.name = name;
            this.body = body;
            this.drawn = drawn;
            this.ch = ch;
            this.referenceName = referenceName;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            PortCharacteristic characteristic;
            EditingPreferences ep = this.getEditingPreferences();
            Export e = this.cell.findExport(this.name);
            if (e != null && this.cell.isMultiPage()) {
                int exportPage = e.getOriginalPort().getNodeInst().whichMultiPage();
                int currentPage = this.ni.whichMultiPage();
                if (currentPage != exportPage) {
                    JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "That export name already exists on page " + (exportPage + 1), "Duplicate Export", 2);
                }
            }
            if (CircuitChangeJobs.cantEdit(this.cell, this.ni, true, true, true) != 0) {
                return false;
            }
            PortInst pi = this.ni.findPortInstFromEquivalentProto(this.pp);
            e = Export.newInstance(this.cell, pi, this.name, ep, characteristic = PortCharacteristic.findCharacteristic(this.ch));
            if (e == null) {
                System.out.println("Failed to create export");
                return false;
            }
            e.setAlwaysDrawn(this.drawn);
            e.setBodyOnly(this.body);
            if (characteristic.isReference()) {
                e.newVar(Export.EXPORT_REFERENCE_NAME, (Object)this.referenceName, ep);
            }
            return true;
        }
    }
}

