/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.fill;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.TechType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class FillRouter {
    private HashMap<String, List<PortInst>> portMap = new HashMap();
    private TechType tech;

    private String makeKey(PortInst pi) {
        EPoint center = pi.getCenter();
        String x = "" + center.getX();
        String y = "" + center.getY();
        return x + "x" + y;
    }

    private ArcProto findCommonArc(PortInst p1, PortInst p2) {
        ArcProto[] metals = new ArcProto[]{this.tech.m6(), this.tech.m5(), this.tech.m4(), this.tech.m3(), this.tech.m2(), this.tech.m1()};
        PortProto pp1 = p1.getPortProto();
        PortProto pp2 = p2.getPortProto();
        for (int i = 0; i < metals.length; ++i) {
            if (!pp1.connectsTo(metals[i]) || !pp2.connectsTo(metals[i])) continue;
            return metals[i];
        }
        return null;
    }

    private void connectPorts(List<PortInst> ports, EditingPreferences ep) {
        Iterator<PortInst> it = ports.iterator();
        while (it.hasNext()) {
            PortInst first = it.next();
            double width = LayoutLib.widestWireWidth(first);
            it.remove();
            for (PortInst pi : ports) {
                ArcProto a = this.findCommonArc(first, pi);
                if (a == null) continue;
                LayoutLib.newArcInst(a, ep, width, first, pi);
            }
        }
    }

    private FillRouter(TechType t, EditingPreferences ep, ArrayList<PortInst> ports) {
        this.tech = t;
        for (PortInst pi : ports) {
            String key = this.makeKey(pi);
            List<PortInst> l = this.portMap.get(key);
            if (l == null) {
                l = new LinkedList<PortInst>();
                this.portMap.put(key, l);
            }
            l.add(pi);
        }
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(this.portMap.keySet());
        Collections.sort(keys);
        for (String str : keys) {
            this.connectPorts(this.portMap.get(str), ep);
        }
    }

    public static void connectCoincident(TechType t, EditingPreferences ep, ArrayList<PortInst> ports) {
        new FillRouter(t, ep, ports);
    }
}

