/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.text;

import com.sun.electric.database.text.NameImpl;
import com.sun.electric.util.TextUtils;
import java.util.Comparator;

public abstract class Name
implements Comparable<Name> {
    private static volatile Name[] allNames = new Name[1];
    private static int allNamesCount = 0;
    public static final Comparator<Name> STRING_NUMBER_ORDER = new Comparator<Name>(){

        @Override
        public int compare(Name o1, Name o2) {
            return TextUtils.STRING_NUMBER_ORDER.compare(o1.toString(), o2.toString());
        }
    };
    protected static final int ERROR = 1;
    protected static final int LIST = 2;
    protected static final int BUS = 4;
    protected static final int SIMPLE = 8;
    protected static final int TEMP = 16;
    protected static final int DUPLICATES = 32;
    protected static final int HAS_EMPTIES = 64;

    public static Name findName(String ns) {
        String ts;
        if (ns == null) {
            return null;
        }
        return NameImpl.newTrimmedName(ts, (ts = Name.trim(ns)) == ns);
    }

    public static String checkName(String ns) {
        try {
            int flags = Name.checkNameThrow(ns);
            if ((flags & 0x40) != 0) {
                return "has empty subnames";
            }
            return null;
        }
        catch (NumberFormatException e) {
            return e.getMessage();
        }
    }

    public static void printStatistics() {
        int validNames = 0;
        int userNames = 0;
        int busCount = 0;
        int busWidth = 0;
        long length = 0L;
        for (Name n : allNames) {
            if (n == null) continue;
            length += (long)n.toString().length();
            if (n.isValid()) {
                ++validNames;
            }
            if (!n.isTempname()) {
                ++userNames;
            }
            if (!n.isBus()) continue;
            ++busCount;
            busWidth += n.busWidth();
        }
        System.out.println(allNamesCount + " Names " + length + " chars. " + validNames + " valid " + userNames + " usernames " + busCount + " buses with " + busWidth + " elements.");
    }

    @Override
    public abstract int compareTo(Name var1);

    public abstract boolean isValid();

    public abstract boolean isTempname();

    public abstract boolean hasDuplicates();

    public abstract boolean hasEmptySubnames();

    public abstract boolean isList();

    public abstract boolean isBus();

    public abstract Name subname(int var1);

    public abstract int busWidth();

    public abstract Name getBasename();

    public abstract int getNumSuffix();

    public abstract Name findSuffixed(int var1);

    private static String trim(String ns) {
        if (ns == null) {
            return null;
        }
        int len = ns.length();
        int newLen = 0;
        for (int i = 0; i < len; ++i) {
            if (ns.charAt(i) <= ' ') continue;
            ++newLen;
        }
        if (newLen == len) {
            return ns;
        }
        StringBuffer buf = new StringBuffer(newLen);
        for (int i = 0; i < len; ++i) {
            if (ns.charAt(i) <= ' ') continue;
            buf.append(ns.charAt(i));
        }
        return buf.toString();
    }

    protected static int checkNameThrow(String ns) throws NumberFormatException {
        int flags = 8;
        int bracket = -1;
        boolean wasBrackets = false;
        int colon2 = -1;
        if (ns.length() == 0 || ns.charAt(ns.length() - 1) == ',') {
            flags |= 0x40;
        }
        for (int i = 0; i < ns.length(); ++i) {
            int j;
            char c = ns.charAt(i);
            if (bracket < 0) {
                colon2 = -1;
                if (c == ']') {
                    throw new NumberFormatException("unmatched ']' in name");
                }
                if (c == ':') {
                    throw new NumberFormatException("':' out of brackets");
                }
                if (c == '[') {
                    bracket = i;
                    flags &= 0xFFFFFFF7;
                    if (i == 0 || ns.charAt(i - 1) == ',') {
                        flags |= 0x40;
                    }
                    wasBrackets = true;
                } else if (c == ',') {
                    flags |= 6;
                    flags &= 0xFFFFFFF7;
                    if (i == 0 || ns.charAt(i - 1) == ',') {
                        flags |= 0x40;
                    }
                    wasBrackets = false;
                } else if (wasBrackets) {
                    throw new NumberFormatException("Wrong character after brackets");
                }
                if (c != '@') continue;
                for (j = i + 1; j < ns.length(); ++j) {
                    char cj = ns.charAt(j);
                    if (cj >= '0' && cj <= '9') continue;
                    throw new NumberFormatException("Wrong number suffix in temporary name");
                }
                if (i == ns.length() - 1 || ns.charAt(i + 1) == '0' && i != ns.length() - 2) {
                    throw new NumberFormatException("Wrong temporary name");
                }
                if ((flags & 8) == 0) {
                    throw new NumberFormatException("list of temporary names");
                }
                Integer.parseInt(ns.substring(i + 1));
                assert (flags == 8);
                return 24;
            }
            if (c == '[') {
                throw new NumberFormatException("nested bracket '[' in name");
            }
            if (c == ':') {
                if (colon2 >= 0) {
                    throw new NumberFormatException("too many ':' inside brackets");
                }
                if (i == bracket + 1) {
                    throw new NumberFormatException("has missing start of index range");
                }
                if (ns.charAt(bracket + 1) == '-') {
                    throw new NumberFormatException("has negative start of index range");
                }
                for (j = bracket + 1; j < i; ++j) {
                    if (TextUtils.isDigit(ns.charAt(j))) continue;
                    throw new NumberFormatException("has nonnumeric start of index range");
                }
                colon2 = i;
                flags |= 4;
            }
            if (colon2 >= 0 && (c == ']' || c == ',')) {
                if (i == colon2 + 1) {
                    throw new NumberFormatException("has missing end of index range");
                }
                if (ns.charAt(colon2 + 1) == '-') {
                    throw new NumberFormatException("has negative end of index range");
                }
                for (j = colon2 + 1; j < i; ++j) {
                    if (TextUtils.isDigit(ns.charAt(j))) continue;
                    throw new NumberFormatException("has nonnumeric end of index range");
                }
                if (Integer.parseInt(ns.substring(bracket + 1, colon2)) == Integer.parseInt(ns.substring(colon2 + 1, i))) {
                    throw new NumberFormatException("has equal start and end indices");
                }
                colon2 = -1;
            }
            if (c == ']') {
                if (i == bracket + 1) {
                    flags |= 0x40;
                }
                bracket = -1;
            }
            if (c == ',') {
                if (i == bracket + 1) {
                    flags += 64;
                }
                bracket = i;
                flags |= 4;
            }
            if (c != '@') continue;
            throw new NumberFormatException("'@' in brackets");
        }
        if (bracket != -1) {
            throw new NumberFormatException("Unclosed bracket");
        }
        return flags;
    }
}

