/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar1;

import com.sun.electric.tool.routing.experimentalAStar1.QuadTree;

public class Map {
    private int[][][] map;
    private QuadTree[] quadTrees;
    static final int X = -3;
    static final int CLEAR = 0;
    private int dispX;
    private int dispY;
    private double scalingFactor;
    private int width;
    private int height;

    public Map(double minWidth, int widthUnscaled, int heightUnscaled, int layers, int dispX, int dispY) {
        this.scalingFactor = minWidth;
        assert (this.scalingFactor >= 1.0) : this.scalingFactor;
        this.width = (int)Math.ceil((double)widthUnscaled / this.scalingFactor);
        this.height = (int)Math.ceil((double)heightUnscaled / this.scalingFactor);
        this.map = new int[layers][this.width][this.height];
        this.quadTrees = new QuadTree[layers];
        for (int i = 0; i < layers; ++i) {
            this.quadTrees[i] = new QuadTree(this.width, this.height);
        }
        this.dispX = dispX;
        this.dispY = dispY;
    }

    public int getDispX() {
        return this.dispX;
    }

    public int getDispY() {
        return this.dispY;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public double getScalingFactor() {
        return this.scalingFactor;
    }

    public int getLayers() {
        return this.map.length;
    }

    public int getStatus(int x2, int y, int z) {
        return this.map[z][x2][y];
    }

    public int getSpaceAround(int x2, int y, int z) {
        return this.quadTrees[z].spaceAt(x2, y);
    }

    public void setStatus(int x2, int y, int z, int status) {
        this.map[z][x2][y] = status;
        assert (status != 0);
        this.quadTrees[z].add(x2, y);
    }

    public void setStatus(int[] x2, int[] y, int[] z, int status) {
        assert (status != 0);
        for (int i = 0; i < x2.length; ++i) {
            this.map[z[i]][x2[i]][y[i]] = status;
            this.quadTrees[z[i]].add(x2[i], y[i]);
        }
    }
}

