/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.menus;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.dialogs.About;
import com.sun.electric.tool.user.help.ManualViewer;
import com.sun.electric.tool.user.menus.EMenu;
import com.sun.electric.tool.user.menus.EMenuItem;
import com.sun.electric.tool.user.menus.FileMenu;
import com.sun.electric.tool.user.menus.MenuCommands;
import com.sun.electric.tool.user.ui.TopLevel;
import java.net.URL;

public class HelpMenu {
    static EMenu makeMenu() {
        return new EMenu("_Help", !Client.isOSMac() ? new EMenuItem("_About Electric..."){

            public void run() {
                HelpMenu.aboutCommand();
            }
        } : null, !Client.isOSMac() ? EMenuItem.SEPARATOR : null, new EMenuItem("_User's Manual..."){

            public void run() {
                ManualViewer.userManualCommand();
            }
        }, ManualViewer.hasRussianManual() ? new EMenuItem("User's Manual (_Russian)..."){

            public void run() {
                ManualViewer.userManualRussianCommand();
            }
        } : null, new EMenuItem("Show _Key Bindings"){

            public void run() {
                MenuCommands.menuBar().keyBindingManager.printKeyBindings();
            }
        }, ManualViewer.isJava3DAvailable() ? new EMenu("_3D Showcase", new EMenuItem("_Load Library"){

            public void run() {
                HelpMenu.loadSamplesLibrary("floatingGates", "topCell");
            }
        }, new EMenuItem("_3D View of Cage Cell"){

            public void run() {
                ManualViewer.open3DSample("floatingGates", "topCell", "3D ShowCase");
            }
        }, new EMenuItem("_Animate Cage Cell"){

            public void run() {
                ManualViewer.animate3DSample("demoCage.j3d");
            }
        }) : null, new EMenuItem("_Load Sample Cells Library"){

            public void run() {
                HelpMenu.loadSamplesLibrary("samples", "tech-MOSISCMOS");
            }
        });
    }

    public static void aboutCommand() {
        About dialog = new About(TopLevel.getCurrentJFrame());
        dialog.setVisible(true);
    }

    private static void loadSamplesLibrary(String fileName, String cellName) {
        Library lib = Library.findLibrary(fileName);
        if (lib != null) {
            System.out.println(lib + " already loaded");
            Cell cell = lib.findNodeProto(cellName);
            if (cell == null) {
                System.out.println("Cell '" + cellName + "' does not exist in " + lib);
            }
            return;
        }
        String libName = "helphtml/" + fileName + ".jelib";
        URL url = ManualViewer.class.getResource(libName);
        if (url != null) {
            new FileMenu.ReadLibrary(url, FileType.JELIB, cellName);
        } else {
            System.out.println("Library '" + libName + "' in Electric's jarfile");
        }
    }
}

