/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;

public class MessagesWindow
implements MouseListener,
ClipboardOwner {
    private JTextArea info;
    private Container contentFrame;
    private Container jf;

    public MessagesWindow() {
        Dimension scrnSize = TopLevel.getScreenSize();
        Dimension msgSize = new Dimension(scrnSize.width / 3 * 2, scrnSize.height / 100 * 15);
        Point msgPos = new Point(150, scrnSize.height / 100 * 85);
        if (TopLevel.isMDIMode()) {
            JInternalFrame jInternalFrame = new JInternalFrame("Electric Messages", true, false, true, true);
            this.jf = jInternalFrame;
            this.contentFrame = jInternalFrame.getContentPane();
            jInternalFrame.setFrameIcon(TopLevel.getFrameIcon());
            this.jf.setLocation(msgPos);
        } else {
            JFrame jFrame = new JFrame("Electric Messages");
            this.jf = jFrame;
            jFrame.setDefaultCloseOperation(0);
            this.contentFrame = jFrame.getContentPane();
            jFrame.setIconImage(TopLevel.getFrameIcon().getImage());
            Point pt = User.getDefaultMessagesPos();
            if (pt == null) {
                pt = msgPos;
            }
            this.jf.setLocation(pt);
            Dimension override = User.getDefaultMessagesSize();
            if (override != null) {
                this.jf.setPreferredSize(override);
            }
        }
        this.contentFrame.setLayout(new BorderLayout());
        this.info = new JTextArea(20, 110);
        this.info.setLineWrap(false);
        this.info.setFont(new Font("Monospaced", 0, 12));
        this.info.addMouseListener(this);
        JScrollPane scrollPane = new JScrollPane(this.info, 22, 30);
        scrollPane.setPreferredSize(msgSize);
        this.contentFrame.add((Component)scrollPane, "Center");
        if (TopLevel.isMDIMode()) {
            ((JInternalFrame)this.jf).pack();
            TopLevel.addToDesktop((JInternalFrame)this.jf);
        } else {
            ((JFrame)this.jf).pack();
            ((JFrame)this.jf).setVisible(true);
        }
    }

    public boolean isFocusOwner() {
        if (TopLevel.isMDIMode()) {
            return ((JInternalFrame)this.jf).isSelected();
        }
        return this.jf.isFocusOwner();
    }

    public void requestFocus() {
        if (!Job.isClientThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MessagesWindow.this.requestFocusUnsafe();
                }
            });
            return;
        }
        this.requestFocusUnsafe();
    }

    private void requestFocusUnsafe() {
        if (TopLevel.isMDIMode()) {
            ((JInternalFrame)this.jf).toFront();
            try {
                ((JInternalFrame)this.jf).setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {}
        } else {
            ((JFrame)this.jf).toFront();
            this.jf.requestFocus();
        }
    }

    public Rectangle getMessagesLocation() {
        return this.jf.getBounds();
    }

    public int getMessagesCharWidth() {
        return this.info.getColumns();
    }

    public void tileWithEdit() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        Rectangle eb = TopLevel.isMDIMode() ? wf.getInternalFrame().getBounds() : wf.getFrame().getBounds();
        Rectangle mb = this.getMessagesLocation();
        mb.x = eb.x;
        mb.width = eb.width;
        mb.y = eb.y + eb.height;
        this.jf.setBounds(mb);
    }

    public void appendString(String str) {
        this.info.append(str);
        try {
            Rectangle r = this.info.modelToView(this.info.getDocument().getLength());
            this.info.scrollRectToVisible(r);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.doContext(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.doContext(e);
        }
    }

    public void lostOwnership(Clipboard parClipboard, Transferable parTransferable) {
    }

    private void doContext(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu("Messages Window");
        JMenuItem menuItem = new JMenuItem("Cut");
        menu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MessagesWindow.this.copyText(false, true);
            }
        });
        menuItem = new JMenuItem("Copy");
        menu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MessagesWindow.this.copyText(false, false);
            }
        });
        menuItem = new JMenuItem("Paste");
        menu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MessagesWindow.this.pasteText();
            }
        });
        menu.addSeparator();
        menuItem = new JMenuItem("Cut All");
        menu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MessagesWindow.this.copyText(true, true);
            }
        });
        menuItem = new JMenuItem("Copy All");
        menu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MessagesWindow.this.copyText(true, false);
            }
        });
        menuItem = new JMenuItem("Clear");
        menu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MessagesWindow.this.clear(true);
            }
        });
        menu.show((Component)e.getSource(), e.getX(), e.getY());
    }

    public void pasteText() {
        this.info.paste();
    }

    public void copyText(boolean all, boolean cut) {
        if (all) {
            if (cut) {
                this.info.selectAll();
                this.info.cut();
            } else {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(this.info.getText()), this);
            }
        } else if (cut) {
            this.info.cut();
        } else {
            this.info.copy();
        }
    }

    public void clear(boolean all) {
        if (all) {
            this.info.setText("");
        } else {
            this.info.replaceSelection("");
        }
    }

    public void selectAll() {
        this.info.selectAll();
    }

    public void selectFont() {
        if (TopLevel.isMDIMode()) {
            TopLevel jf = TopLevel.getCurrentJFrame();
            new FontSelectDialog(jf);
        } else {
            new FontSelectDialog(null);
        }
    }

    private class FontSelectDialog
    extends EDialog {
        private Font initialFont;
        private String initialFontName;
        private int initialFontSize;
        private JLabel sampleText;
        private JList fontNameList;
        private JList fontSizeList;

        public FontSelectDialog(Frame parent) {
            super(parent, true);
            this.setTitle("Set Messages Window Font");
            this.getContentPane().setLayout(new GridBagLayout());
            this.initialFont = MessagesWindow.this.info.getFont();
            this.initialFontName = this.initialFont.getName();
            this.initialFontSize = this.initialFont.getSize();
            JLabel fontLabel = new JLabel("Font:");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)fontLabel, gbc);
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            String[] fontNames = ge.getAvailableFontFamilyNames();
            JScrollPane fontNamePane = new JScrollPane();
            DefaultListModel<String> fontNameListModel = new DefaultListModel<String>();
            this.fontNameList = new JList(fontNameListModel);
            this.fontNameList.setSelectionMode(0);
            fontNamePane.setViewportView(this.fontNameList);
            int initialIndex = 0;
            for (int i = 0; i < fontNames.length; ++i) {
                if (fontNames[i].equals(this.initialFontName)) {
                    initialIndex = i;
                }
                fontNameListModel.addElement(fontNames[i]);
            }
            this.fontNameList.setSelectedIndex(initialIndex);
            this.fontNameList.ensureIndexIsVisible(initialIndex);
            this.fontNameList.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent evt) {
                    FontSelectDialog.this.updateSampleText();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)fontNamePane, gbc);
            JLabel sizeLabel = new JLabel("Size:");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)sizeLabel, gbc);
            JScrollPane fontSizePane = new JScrollPane();
            DefaultListModel<String> fontSizeListModel = new DefaultListModel<String>();
            this.fontSizeList = new JList(fontSizeListModel);
            this.fontSizeList.setSelectionMode(0);
            fontSizePane.setViewportView(this.fontSizeList);
            fontSizeListModel.addElement("8");
            fontSizeListModel.addElement("9");
            fontSizeListModel.addElement("10");
            fontSizeListModel.addElement("11");
            fontSizeListModel.addElement("12");
            fontSizeListModel.addElement("14");
            fontSizeListModel.addElement("16");
            fontSizeListModel.addElement("18");
            fontSizeListModel.addElement("20");
            fontSizeListModel.addElement("22");
            fontSizeListModel.addElement("24");
            fontSizeListModel.addElement("28");
            fontSizeListModel.addElement("32");
            fontSizeListModel.addElement("36");
            fontSizeListModel.addElement("40");
            fontSizeListModel.addElement("48");
            fontSizeListModel.addElement("72");
            this.fontSizeList.setSelectedValue(Integer.toString(this.initialFontSize), true);
            this.fontSizeList.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent evt) {
                    FontSelectDialog.this.updateSampleText();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.fill = 1;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)fontSizePane, gbc);
            this.sampleText = new JLabel("The Electric VLSI Design System");
            this.sampleText.setBorder(BorderFactory.createTitledBorder("Sample text"));
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 2;
            gbc.fill = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.sampleText, gbc);
            this.sampleText.setFont(this.initialFont);
            JButton okButton = new JButton("OK");
            okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    FontSelectDialog.this.OK();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)okButton, gbc);
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    FontSelectDialog.this.cancel();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 3;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)cancelButton, gbc);
            this.pack();
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    FontSelectDialog.this.cancel();
                }
            });
            this.setVisible(true);
        }

        private void cancel() {
            this.dispose();
        }

        private void updateSampleText() {
            String currentFontName = this.initialFontName;
            if (this.fontNameList.getSelectedIndex() != -1) {
                currentFontName = (String)this.fontNameList.getSelectedValue();
            }
            int currentFontSize = this.initialFontSize;
            if (this.fontSizeList.getSelectedIndex() != -1) {
                currentFontSize = TextUtils.atoi((String)this.fontSizeList.getSelectedValue());
            }
            Font font = new Font(currentFontName, 0, currentFontSize);
            this.sampleText.setFont(font);
        }

        private void OK() {
            String currentFontName = this.initialFontName;
            if (this.fontNameList.getSelectedIndex() != -1) {
                currentFontName = (String)this.fontNameList.getSelectedValue();
            }
            int currentFontSize = this.initialFontSize;
            if (this.fontSizeList.getSelectedIndex() != -1) {
                currentFontSize = TextUtils.atoi((String)this.fontSizeList.getSelectedValue());
            }
            if (!currentFontName.equals(this.initialFontName) || currentFontSize != this.initialFontSize) {
                this.initialFont = new Font(currentFontName, 0, currentFontSize);
                MessagesWindow.this.info.setFont(this.initialFont);
                System.out.println("Messages window font is now " + currentFontName + ", size " + currentFontSize);
            }
            this.cancel();
        }
    }
}

