/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.extract;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.user.Highlighter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeometrySearch
extends HierarchyEnumerator.Visitor {
    private List<GeometrySearchResult> found;
    private ERectangle geomBBnd;
    private boolean visibleObjectsOnly;
    private HashMap<ArcProto, Boolean> cacheVisibilityArcs = new HashMap();
    private int cellsProcessed;

    public List<GeometrySearchResult> searchGeometries(Cell cell, EPoint point, boolean visibleObjectsOnly) {
        this.found = new ArrayList<GeometrySearchResult>();
        this.geomBBnd = ERectangle.fromLambda(point.getX(), point.getY(), 0.0, 0.0);
        this.visibleObjectsOnly = visibleObjectsOnly;
        this.cacheVisibilityArcs.clear();
        this.cellsProcessed = 0;
        HierarchyEnumerator.enumerateCell(cell, VarContext.globalContext, (HierarchyEnumerator.Visitor)this);
        return this.found;
    }

    public int getCellsProcessed() {
        return this.cellsProcessed;
    }

    @Override
    public boolean enterCell(HierarchyEnumerator.CellInfo info) {
        Cell cell = info.getCell();
        AffineTransform xformToRoot = null;
        try {
            xformToRoot = info.getTransformToRoot().createInverse();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        assert (xformToRoot != null);
        Rectangle2D.Double rect = new Rectangle2D.Double();
        ((Rectangle2D)rect).setRect(this.geomBBnd);
        DBMath.transformRect(rect, xformToRoot);
        ++this.cellsProcessed;
        boolean continueDown = false;
        Iterator<RTBounds> it = cell.searchIterator(rect, false);
        while (it.hasNext()) {
            double dist;
            Geometric geom = (Geometric)it.next();
            if (geom instanceof NodeInst) {
                NodeInst oNi = (NodeInst)geom;
                if (oNi.isCellInstance()) {
                    continueDown = true;
                    continue;
                }
                dist = Highlighter.distToNode(rect, oNi, null);
                if (dist > 0.0) continue;
                PrimitiveNode node = (PrimitiveNode)oNi.getProto();
                if (this.visibleObjectsOnly && !node.isVisible()) continue;
                this.found.add(new GeometrySearchResult(geom, info.getContext()));
                continue;
            }
            ArcInst ai = (ArcInst)geom;
            dist = Highlighter.distToArc(rect, ai, null);
            if (dist > 0.0) continue;
            ArcProto ap = ai.getProto();
            if (this.visibleObjectsOnly && !this.isArcVisible(ap)) continue;
            this.found.add(new GeometrySearchResult(geom, info.getContext()));
        }
        return continueDown;
    }

    @Override
    public void exitCell(HierarchyEnumerator.CellInfo info) {
    }

    @Override
    public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
        return !this.visibleObjectsOnly || no.getNodeInst().isExpanded();
    }

    private boolean isArcVisible(ArcProto arc) {
        Boolean b = this.cacheVisibilityArcs.get(arc);
        if (b == null) {
            boolean visible = false;
            Iterator<Layer> it2 = arc.getLayerIterator();
            while (it2.hasNext()) {
                Layer lay = it2.next();
                if (!lay.isVisible()) continue;
                visible = true;
                break;
            }
            b = new Boolean(visible);
            this.cacheVisibilityArcs.put(arc, b);
        }
        return b;
    }

    public static class GeometrySearchResult {
        private Geometric geom;
        private VarContext context;

        GeometrySearchResult(Geometric g, VarContext c) {
            this.geom = g;
            this.context = c;
        }

        public Geometric getGeometric() {
            return this.geom;
        }

        public VarContext getContext() {
            return this.context;
        }

        public String describe() {
            String contextstr = "current cell";
            if (this.context != VarContext.globalContext) {
                contextstr = this.getInstPath(this.context);
            }
            return this.geom + " in " + contextstr;
        }

        public String getInstPath(VarContext vc) {
            if (vc == VarContext.globalContext) {
                return "";
            }
            String prefix = vc.pop() == VarContext.globalContext ? "" : this.getInstPath(vc.pop());
            Nodable no = vc.getNodable();
            if (no == null) {
                System.out.println("VarContext.getInstPath: context with null NodeInst?");
            }
            String me = no.getName();
            if (no instanceof NodeInst) {
                Name name = no.getNameKey();
                me = name.subname(0).toString();
            }
            me = no.getProto().getName() + "[" + me + "]";
            if (prefix.equals("")) {
                return me;
            }
            return prefix + " / " + me;
        }
    }
}

