/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.project;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.project.Project;
import com.sun.electric.tool.project.ProjectCell;
import com.sun.electric.tool.project.ProjectDB;
import com.sun.electric.tool.project.ProjectLibrary;
import com.sun.electric.tool.project.Users;
import com.sun.electric.tool.user.ui.WindowFrame;

public class AddCellJob
extends Job {
    private ProjectDB pdb;
    private Cell cell;

    public static void addThisCell() {
        UserInterface ui = Job.getUserInterface();
        Cell cell = ui.needCurrentCell();
        if (cell == null) {
            return;
        }
        AddCellJob.addCell(cell);
    }

    public static void addCell(Cell cell) {
        if (Users.needUserName()) {
            return;
        }
        if (Project.ensureRepository()) {
            return;
        }
        if (cell.getNewestVersion() != cell) {
            Job.getUserInterface().showErrorMessage("Cannot add an old version of the cell", "Add Cell Error");
            return;
        }
        Library lib = cell.getLibrary();
        ProjectLibrary pl = Project.projectDB.findProjectLibrary(lib);
        ProjectCell foundPC = pl.findProjectCellByNameView(cell.getName(), cell.getView());
        if (foundPC != null) {
            Job.getUserInterface().showErrorMessage("This cell is already in the repository", "Error Adding to Repository");
            return;
        }
        new AddCellJob(cell);
    }

    private AddCellJob(Cell cell) {
        super("Add " + cell, Project.getProjectTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
        this.cell = cell;
        this.pdb = Project.projectDB;
        this.startJob();
    }

    @Override
    public boolean doIt() throws JobException {
        Library lib = this.cell.getLibrary();
        ProjectLibrary pl = this.pdb.findProjectLibrary(lib);
        pl.lockProjectFile();
        Project.setChangeStatus(true);
        ProjectCell pc = new ProjectCell(this.cell, pl);
        pc.setLastOwner(Project.getCurrentUserName());
        pc.setComment("Initial checkin");
        String error = null;
        if (Project.writeCell(this.cell, pc)) {
            error = "Error writing the cell to the repository";
        } else {
            pl.linkProjectCellToCell(pc, this.cell);
            Project.markLocked(this.cell, true);
            System.out.println("Cell " + this.cell.describe(true) + " added to the project");
        }
        Project.setChangeStatus(false);
        pl.releaseProjectFileLock(true);
        if (error != null) {
            throw new JobException(error);
        }
        this.fieldVariableChanged("pdb");
        return true;
    }

    @Override
    public void terminateOK() {
        Project.projectDB = this.pdb;
        WindowFrame.wantToRedoLibraryTree();
    }
}

