/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.ncc.result.NetObjReport;
import com.sun.electric.tool.ncc.result.PortReport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class ExportMismatch
implements Serializable {
    protected String[] desingNames = new String[2];
    protected Cell[] cells = new Cell[2];
    protected VarContext[] contexts = new VarContext[2];
    protected boolean topologyMatch;
    protected boolean nameMatch;
    protected boolean validOnlyWhenTopologyMismatch;

    public ExportMismatch() {
        this.init();
    }

    public ExportMismatch(String name1, String name2) {
        this.desingNames[0] = name1;
        this.desingNames[1] = name2;
        this.init();
    }

    private void init() {
        this.topologyMatch = true;
        this.nameMatch = true;
        this.validOnlyWhenTopologyMismatch = false;
    }

    public String getName(int index) {
        if (index != 0 && index != 1) {
            return null;
        }
        return this.desingNames[index];
    }

    public void setNames(String name1, String name2) {
        this.desingNames[0] = name1;
        this.desingNames[1] = name2;
    }

    public Cell getCell(int index) {
        if (index != 0 && index != 1) {
            return null;
        }
        return this.cells[index];
    }

    public void setCells(Cell cell1, Cell cell2) {
        this.cells[0] = cell1;
        this.cells[1] = cell2;
    }

    public VarContext getContext(int index) {
        if (index != 0 && index != 1) {
            return null;
        }
        return this.contexts[index];
    }

    public void setContexts(VarContext cnxt1, VarContext cnxt2) {
        this.contexts[0] = cnxt1;
        this.contexts[1] = cnxt2;
    }

    public boolean isTopologyMatch() {
        return this.topologyMatch;
    }

    public void setTopologyMatch(boolean topologyMatch) {
        this.topologyMatch = topologyMatch;
    }

    public boolean isNameMatch() {
        return this.nameMatch;
    }

    public void setNameMatch(boolean nameMatch) {
        this.nameMatch = nameMatch;
    }

    public boolean isValidOnlyWhenTopologyMismatch() {
        return this.validOnlyWhenTopologyMismatch;
    }

    public void setValidOnlyWhenTopologyMismatch(boolean valid) {
        this.validOnlyWhenTopologyMismatch = valid;
    }

    public static class TopologyMismatch
    extends ExportMismatch {
        static final long serialVersionUID = 0L;
        private PortReport exp1;
        private PortReport exp2;
        private NetObjReport sug = null;

        public TopologyMismatch() {
            this.nameMatch = true;
            this.topologyMatch = false;
        }

        public TopologyMismatch(String name1, String name2) {
            this.desingNames[0] = name1;
            this.desingNames[1] = name2;
            this.nameMatch = true;
            this.topologyMatch = false;
        }

        public PortReport getFirstExport() {
            return this.exp1;
        }

        public PortReport getSecondExport() {
            return this.exp2;
        }

        public NetObjReport getSuggestion() {
            return this.sug;
        }

        public void setFirstExport(PortReport.PortReportable exp1) {
            this.exp1 = new PortReport(exp1);
        }

        public void setSecondExport(PortReport.PortReportable exp2) {
            this.exp2 = new PortReport(exp2);
        }

        public void setSuggestion(NetObjReport.NetObjReportable sug) {
            this.sug = NetObjReport.newNetObjReport(sug);
        }
    }

    public static class NameMismatch
    extends ExportMismatch {
        static final long serialVersionUID = 0L;
        private PortReport exp1;
        private NetObjReport exp2;

        public NameMismatch() {
            this.nameMatch = false;
            this.topologyMatch = true;
        }

        public NameMismatch(String name1, String name2) {
            this.desingNames[0] = name1;
            this.desingNames[1] = name2;
            this.nameMatch = false;
            this.topologyMatch = true;
        }

        public PortReport getFirstExport() {
            return this.exp1;
        }

        public NetObjReport getSuggestion() {
            return this.exp2;
        }

        public void setFirstExport(PortReport.PortReportable exp1) {
            this.exp1 = new PortReport(exp1);
        }

        public void setSuggestion(NetObjReport.NetObjReportable exp2) {
            this.exp2 = NetObjReport.newNetObjReport(exp2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MultiMatch
    extends ExportMismatch {
        static final long serialVersionUID = 0L;
        private final List<PortReport>[] ports = new ArrayList[2];

        public MultiMatch() {
            this.ports[0] = new ArrayList<PortReport>();
            this.ports[1] = new ArrayList<PortReport>();
        }

        public void add(int listIndex, PortReport.PortReportable port) {
            this.ports[listIndex].add(new PortReport(port));
        }

        public void add(int listIndex, Set<PortReport.PortReportable> portSet) {
            for (PortReport.PortReportable p : portSet) {
                this.ports[listIndex].add(new PortReport(p));
            }
        }

        public List<PortReport> getAll(int index) {
            return this.ports[index];
        }
    }
}

