/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class EditWindowFocusBrowser {
    private EditWindow editWindow;
    private List savedFoci;
    private int currentFocus;
    private boolean firstUpdate;
    private static final int MAXSAVEDFOCI = 10;
    private static final boolean DEBUG = false;

    EditWindowFocusBrowser(EditWindow controller) {
        this.editWindow = controller;
        this.savedFoci = new ArrayList();
        this.clear();
    }

    public void goBack() {
        int previousFocus = this.currentFocus - 1;
        if (previousFocus < 0) {
            System.out.println("No more previous focus history");
            return;
        }
        if (previousFocus >= this.savedFoci.size()) {
            return;
        }
        this.updateCurrentFocus();
        Focus focus = (Focus)this.savedFoci.get(previousFocus);
        this.restoreFocus(focus);
        this.currentFocus = previousFocus;
    }

    public void goForward() {
        if (this.currentFocus < 0) {
            return;
        }
        int nextFocus = this.currentFocus + 1;
        if (nextFocus >= this.savedFoci.size()) {
            System.out.println("No more forward focus history");
            return;
        }
        this.updateCurrentFocus();
        Focus focus = (Focus)this.savedFoci.get(nextFocus);
        this.restoreFocus(focus);
        this.currentFocus = nextFocus;
    }

    private void restoreFocus(Focus focus) {
        this.editWindow.setOffset(focus.offset);
        this.editWindow.setScale(focus.scale);
        this.editWindow.repaintContents(null, false);
    }

    void saveCurrentFocus() {
        this.saveCurrentFocusNoUpdateClear();
        this.firstUpdate = true;
    }

    private void saveCurrentFocusNoUpdateClear() {
        Focus focus = new Focus(this.editWindow.getOffset(), this.editWindow.getScale());
        while (this.currentFocus < this.savedFoci.size() - 1 && this.savedFoci.size() != 0) {
            this.savedFoci.remove(this.savedFoci.size() - 1);
        }
        this.savedFoci.add(focus);
        ++this.currentFocus;
        if (this.currentFocus > 10) {
            this.savedFoci.remove(0);
            --this.currentFocus;
        }
    }

    void clear() {
        this.currentFocus = -1;
        this.savedFoci.clear();
        this.firstUpdate = true;
    }

    public void updateCurrentFocus() {
        if (this.currentFocus < 0) {
            return;
        }
        if (this.currentFocus >= this.savedFoci.size()) {
            return;
        }
        if (this.firstUpdate) {
            this.saveCurrentFocusNoUpdateClear();
            this.firstUpdate = false;
            return;
        }
        Focus focus = new Focus(this.editWindow.getOffset(), this.editWindow.getScale());
        this.savedFoci.set(this.currentFocus, focus);
    }

    private static class Focus {
        private final Point2D offset;
        private final double scale;

        private Focus(Point2D offset, double scale) {
            this.offset = offset;
            this.scale = scale;
        }

        public String toString() {
            return "offset=" + this.offset.getX() + "," + this.offset.getY() + " scale=" + this.scale;
        }
    }
}

