/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ncc;

import com.sun.electric.Main;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.ncc.netlist.NetObject;
import com.sun.electric.tool.ncc.netlist.Part;
import com.sun.electric.tool.ncc.netlist.Port;
import com.sun.electric.tool.ncc.netlist.Wire;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.beans.PropertyVetoException;
import java.util.Iterator;
import javax.swing.JInternalFrame;

public class HighlightTools {
    public static Highlighter getHighlighter(Cell cell, VarContext context) {
        Highlighter highlighter = null;
        if (cell != null) {
            if (!cell.isLinked()) {
                System.out.println("Cell is deleted");
            }
            boolean found = false;
            EditWindow wnd = null;
            Iterator it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = (WindowFrame)it.next();
                WindowContent content = wf.getContent();
                if (!(content instanceof EditWindow) || (wnd = (EditWindow)content).getCell() != cell || (context == null || !context.equals(wnd.getVarContext())) && context != null) continue;
                HighlightTools.showFrame(wf);
                found = true;
                break;
            }
            if (!found) {
                WindowFrame wf = WindowFrame.createEditWindow(cell);
                wnd = (EditWindow)wf.getContent();
                wnd.setCell(cell, context);
            }
            highlighter = wnd.getHighlighter();
            highlighter.clear();
        }
        return highlighter;
    }

    private static void showFrame(WindowFrame wf) {
        if (TopLevel.isMDIMode()) {
            JInternalFrame jif = wf.getInternalFrame();
            try {
                jif.setIcon(false);
                jif.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            if (!jif.isVisible()) {
                jif.toFront();
                TopLevel.addToDesktop(jif);
            } else {
                jif.toFront();
            }
        } else {
            TopLevel jf = wf.getFrame();
            jf.setState(0);
            if (!jf.isVisible()) {
                jf.toFront();
                if (!Main.BATCHMODE) {
                    jf.setVisible(true);
                }
            } else {
                jf.toFront();
            }
        }
    }

    public static void highlightPortExports(Highlighter highlighter, Cell cell, Port p) {
        String name = p.getWire().getName();
        Netlist netlist = cell.acquireUserNetlist();
        if (netlist == null) {
            System.out.println("Sorry, a deadlock aborted mimic-routing (network information unavailable).  Please try again");
            return;
        }
        Iterator it = netlist.getNetworks();
        while (it.hasNext()) {
            Network net = (Network)it.next();
            if (!net.hasName(name)) continue;
            Iterator it2 = net.getExports();
            while (it2.hasNext()) {
                Export exp = (Export)it2.next();
                highlighter.addText(exp, cell, null, null);
            }
        }
    }

    public static void highlightPart(Highlighter highlighter, Cell cell, Part part) {
        String name = part.getNameProxy().leafName();
        Netlist netlist = cell.acquireUserNetlist();
        if (netlist == null) {
            System.out.println("Sorry, a deadlock aborted mimic-routing (network information unavailable).  Please try again");
            return;
        }
        Iterator it = netlist.getNodables();
        while (it.hasNext()) {
            Nodable nod = (Nodable)it.next();
            if (!name.equals(nod.getName())) continue;
            highlighter.addElectricObject(nod.getNodeInst(), cell);
        }
    }

    public static void highlightWire(Highlighter highlighter, Cell cell, Wire wire) {
        String name = wire.getNameProxy().leafName();
        Netlist netlist = cell.acquireUserNetlist();
        if (netlist == null) {
            System.out.println("Sorry, a deadlock aborted mimic-routing (network information unavailable).  Please try again");
            return;
        }
        Iterator it = netlist.getNetworks();
        while (it.hasNext()) {
            Network net = (Network)it.next();
            if (!net.hasName(name)) continue;
            highlighter.addNetwork(net, cell);
            Iterator it2 = net.getExports();
            while (it2.hasNext()) {
                Export exp = (Export)it2.next();
                highlighter.addText(exp, cell, null, null);
            }
        }
    }

    public static void highlightPortOrWire(Highlighter highlighter, Cell cell, NetObject portOrWire) {
        if (portOrWire instanceof Wire) {
            HighlightTools.highlightWire(highlighter, cell, (Wire)portOrWire);
        } else if (portOrWire instanceof Port) {
            HighlightTools.highlightPortExports(highlighter, cell, (Port)portOrWire);
        }
    }
}

