/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.PortOriginal;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.io.GDSLayers;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.output.Geometry;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class GDS
extends Geometry {
    private static final int GDSVERSION = 3;
    private static final int BYTEMASK = 255;
    private static final int DSIZE = 512;
    private static final int MAXPOINTS = 510;
    private static final int EXPORTPRESENTATION = 0;
    private static final int STRANS_REFLX = 32768;
    private static final int STRANS_ABSA = 2;
    private static final int DTYP_NONE = 0;
    private static final short HDR_HEADER = 2;
    private static final short HDR_BGNLIB = 258;
    private static final short HDR_LIBNAME = 518;
    private static final short HDR_UNITS = 773;
    private static final short HDR_ENDLIB = 1024;
    private static final short HDR_BGNSTR = 1282;
    private static final short HDR_STRNAME = 1542;
    private static final short HDR_ENDSTR = 1792;
    private static final short HDR_BOUNDARY = 2048;
    private static final short HDR_PATH = 2304;
    private static final short HDR_SREF = 2560;
    private static final short HDR_AREF = 2816;
    private static final short HDR_TEXT = 3072;
    private static final short HDR_LAYER = 3330;
    private static final short HDR_DATATYPE = 3586;
    private static final short HDR_XY = 4099;
    private static final short HDR_ENDEL = 4352;
    private static final short HDR_SNAME = 4614;
    private static final short HDR_TEXTTYPE = 5634;
    private static final short HDR_PRESENTATION = 5889;
    private static final short HDR_STRING = 6406;
    private static final short HDR_STRANS = 6657;
    private static final short HDR_MAG = 6917;
    private static final short HDR_ANGLE = 7173;
    private static final short HDR_PROPATTR = 11010;
    private static final short HDR_PROPVALUE = 11270;
    private static final short HDR_N_BGNLIB = 28;
    private static final short HDR_N_UNITS = 20;
    private static final short HDR_N_ANGLE = 12;
    private static final short HDR_N_MAG = 12;
    private static final int HDR_M_SNAME = 32;
    private static final int HDR_M_ASCII = 256;
    private static final double BESTTHRESH = 0.001;
    private static final double WORSTTHRESH = 0.1;
    private static byte[] dataBufferGDS;
    private static byte[] emptyBuffer;
    private static GDSLayers currentLayerNumbers;
    private static int bufferPosition;
    private static int blockCount;
    private static double scaleFactor;
    private HashMap cellNames;
    private HashMap layerNumbers;
    public static final String concatStr = ".";
    private HashMap nameRemapping;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void writeGDSFile(Output.OutputCellInfo cellJob) {
        if (cellJob.cell.getView() != View.LAYOUT) {
            System.out.println("Can only write GDS for layout cells");
            return;
        }
        GDS out = new GDS();
        if (out.openBinaryOutputStream(cellJob.filePath)) {
            return;
        }
        BloatVisitor visitor = out.makeBloatVisitor(GDS.getMaxHierDepth(cellJob.cell));
        if (out.writeCell(cellJob.cell, cellJob.context, visitor)) {
            return;
        }
        if (out.closeBinaryOutputStream()) {
            return;
        }
        System.out.println(cellJob.filePath + " written");
        String topCellName = cellJob.cell.getName();
        String mangledTopCellName = GDS.makeGDSName(topCellName, 256);
        if (!topCellName.equals(mangledTopCellName)) {
            System.out.println("Warning: library name in this file is " + mangledTopCellName + " (special characters were changed)");
        }
    }

    GDS() {
    }

    protected void start() {
        this.initOutput();
        this.outputBeginLibrary(this.topCell);
    }

    protected void done() {
        this.outputHeader((short)1024, 0);
        this.doneWritingOutput();
    }

    protected void writeCellGeom(Geometry.CellGeom cellGeom) {
        boolean renamePins;
        Cell cell = cellGeom.cell;
        this.outputBeginStruct(cell);
        boolean bl = renamePins = cell == this.topCell && IOTool.getGDSConvertNCCExportsConnectedByParentPins();
        if (renamePins) {
            NccCellAnnotations annotations = NccCellAnnotations.getAnnotations(cell);
            if (annotations == null) {
                renamePins = false;
            } else {
                this.nameRemapping = this.createExportNameMap(annotations, cell);
            }
        }
        Set layers = cellGeom.polyMap.keySet();
        Iterator it = layers.iterator();
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            if (layer == null || layer.getTechnology() == null || layer.getTechnology() == Generic.tech) continue;
            if (!this.selectLayer(layer)) {
                System.out.println("Skipping " + layer + " in GDS:writeCellGeom");
                continue;
            }
            List polyList = (List)cellGeom.polyMap.get(layer);
            Iterator polyIt = polyList.iterator();
            while (polyIt.hasNext()) {
                PolyBase poly = (PolyBase)polyIt.next();
                Integer firstLayer = currentLayerNumbers.getFirstLayer();
                int layerNum = firstLayer & 0xFFFF;
                int layerType = firstLayer >> 16 & 0xFFFF;
                this.writePoly(poly, layerNum, layerType);
            }
        }
        Iterator noIt = cellGeom.nodables.iterator();
        while (noIt.hasNext()) {
            Nodable no = (Nodable)noIt.next();
            this.writeNodable(no);
        }
        if (IOTool.getGDSOutDefaultTextLayer() >= 0) {
            it = cell.getPorts();
            while (it.hasNext()) {
                Export pp = (Export)it.next();
                PortOriginal fp = new PortOriginal(pp.getOriginalPort());
                PortInst bottomPort = fp.getBottomPort();
                NodeInst bottomNi = bottomPort.getNodeInst();
                AffineTransform trans = fp.getTransformToTop();
                PrimitiveNode pNp = (PrimitiveNode)bottomNi.getProto();
                Technology.NodeLayer[] nLay = pNp.getLayers();
                Layer layer = nLay[0].getLayer().getNonPseudoLayer();
                this.selectLayer(layer);
                int textLayer = -1;
                int pinLayer = -1;
                int textType = 0;
                int pinType = 0;
                textLayer = pinLayer = IOTool.getGDSOutDefaultTextLayer();
                if (currentLayerNumbers.getTextLayer() != -1) {
                    textLayer = currentLayerNumbers.getTextLayer() & 0xFFFF;
                    textType = currentLayerNumbers.getTextLayer() >> 16 & 0xFFFF;
                }
                if (currentLayerNumbers.getPinLayer() != -1) {
                    pinLayer = currentLayerNumbers.getPinLayer() & 0xFFFF;
                    pinType = currentLayerNumbers.getPinLayer() >> 16 & 0xFFFF;
                }
                if (!IOTool.isGDSOutWritesExportPins()) continue;
                this.writeExportOnLayer(pp, pinLayer, pinType, renamePins);
            }
        }
        this.outputHeader((short)1792, 0);
    }

    private HashMap createExportNameMap(NccCellAnnotations ann, Cell cell) {
        HashMap nameMap = new HashMap();
        Iterator it2 = ann.getExportsConnected();
        while (it2.hasNext()) {
            List list = (List)it2.next();
            TreeSet<String> connectedExports = new TreeSet<String>(new Comparator(){

                public int compare(Object o1, Object o2) {
                    String s1 = (String)o1;
                    String s2 = (String)o2;
                    return s1.compareTo(s2);
                }

                public boolean equals(Object obj) {
                    return this == obj;
                }
            });
            Iterator it3 = list.iterator();
            while (it3.hasNext()) {
                NccCellAnnotations.NamePattern pat = (NccCellAnnotations.NamePattern)it3.next();
                Iterator it = cell.getPorts();
                while (it.hasNext()) {
                    Export e = (Export)it.next();
                    String name = e.getName();
                    if (!pat.matches(name)) continue;
                    connectedExports.add(name);
                    nameMap.put(name, connectedExports);
                }
            }
        }
        return nameMap;
    }

    private void writeExportOnLayer(Export pp, int layer, int type, boolean remapNames) {
        Set nameSet;
        this.outputHeader((short)3072, 0);
        this.outputHeader((short)3330, layer);
        this.outputHeader((short)5634, type);
        this.outputHeader((short)5889, 0);
        NodeInst ni = pp.getOriginalPort().getNodeInst();
        int transValue = 0;
        int angle = ni.getAngle();
        if (ni.isXMirrored() != ni.isYMirrored()) {
            transValue |= 0x8000;
        }
        if (ni.isYMirrored()) {
            angle = (3600 - angle) % 3600;
        }
        if (ni.isXMirrored()) {
            angle = (1800 - angle) % 3600;
        }
        this.outputHeader((short)6657, transValue);
        this.outputMag(0.5);
        this.outputAngle(angle);
        this.outputShort((short)12);
        this.outputShort((short)4099);
        Poly portPoly = pp.getOriginalPort().getPoly();
        this.outputInt(this.scaleDBUnit(portPoly.getCenterX()));
        this.outputInt(this.scaleDBUnit(portPoly.getCenterY()));
        String str = pp.getName();
        if (remapNames && (nameSet = (Set)this.nameRemapping.get(str)) != null) {
            str = (String)nameSet.iterator().next();
            str = str + ":" + str;
        }
        if (IOTool.getGDSOutputConvertsBracketsInExports()) {
            str = str.replaceAll("[\\[\\]]", "_");
        }
        this.outputString(str, (short)6406);
        this.outputHeader((short)4352, 0);
    }

    protected boolean mergeGeom(int hierLevelsFromBottom) {
        return IOTool.isGDSOutMergesBoxes();
    }

    protected boolean includeGeometric() {
        return false;
    }

    protected boolean selectLayer(Layer layer) {
        boolean validLayer = true;
        GDSLayers numbers = (GDSLayers)this.layerNumbers.get(layer);
        if (numbers == null) {
            String layerName = layer.getGDSLayer();
            numbers = layerName == null ? new GDSLayers() : GDSLayers.parseLayerString(layerName);
            this.layerNumbers.put(layer, numbers);
        }
        validLayer = numbers.getNumLayers() > 0;
        currentLayerNumbers = numbers;
        return validLayer;
    }

    protected void writePoly(PolyBase poly, int layerNumber, int layerType) {
        if (layerNumber < 0) {
            return;
        }
        Point2D[] points = poly.getPoints();
        if (poly.getStyle() == Poly.Type.DISC) {
            double r = points[0].distance(points[1]);
            if (r <= 0.0) {
                return;
            }
            Poly newPoly = new Poly(points[0].getX(), points[0].getY(), r * 2.0, r * 2.0);
            this.outputBoundary(newPoly, layerNumber, layerType);
            return;
        }
        Rectangle2D polyBounds = poly.getBox();
        if (polyBounds != null) {
            if (polyBounds.getWidth() == 0.0 || polyBounds.getHeight() == 0.0) {
                return;
            }
            this.outputBoundary(poly, layerNumber, layerType);
            return;
        }
        if (points.length == 1) {
            System.out.println("WARNING: Single point cannot be written in GDS-II");
            return;
        }
        if (points.length > 200) {
            System.out.println("WARNING: GDS-II Polygons may not have more than 200 points (this has " + points.length + ")");
            return;
        }
        if (points.length == 2) {
            this.outputPath(poly, layerNumber, layerType);
        } else {
            this.outputBoundary(poly, layerNumber, layerType);
        }
    }

    protected void writeNodable(Nodable no) {
        NodeInst ni = (NodeInst)no;
        Cell subCell = (Cell)ni.getProto();
        int transValue = 0;
        int angle = ni.getAngle();
        if (ni.isXMirrored() != ni.isYMirrored()) {
            transValue |= 0x8000;
        }
        if (ni.isYMirrored()) {
            angle = (3600 - angle) % 3600;
        }
        if (ni.isXMirrored()) {
            angle = (1800 - angle) % 3600;
        }
        this.outputHeader((short)2560, 0);
        String name = (String)this.cellNames.get(subCell);
        this.outputName((short)4614, name, 32);
        this.outputHeader((short)6657, transValue);
        this.outputAngle(angle);
        this.outputShort((short)12);
        this.outputShort((short)4099);
        this.outputInt(this.scaleDBUnit(ni.getAnchorCenterX()));
        this.outputInt(this.scaleDBUnit(ni.getAnchorCenterY()));
        this.outputHeader((short)4352, 0);
    }

    private BloatVisitor makeBloatVisitor(int maxDepth) {
        BloatVisitor visitor = new BloatVisitor((Geometry)this, maxDepth);
        return visitor;
    }

    private void initOutput() {
        blockCount = 0;
        bufferPosition = 0;
        for (int i = 0; i < 512; ++i) {
            GDS.emptyBuffer[i] = 0;
        }
        Technology tech = this.topCell.getTechnology();
        scaleFactor = tech.getScale();
        this.layerNumbers = new HashMap();
        this.nameRemapping = new HashMap();
        boolean foundValid = false;
        Iterator it = tech.getLayers();
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            if (!this.selectLayer(layer)) continue;
            foundValid = true;
        }
        if (!foundValid) {
            System.out.println("Warning: there are no GDS II layers defined for the " + tech.getTechName() + " technology");
        }
        this.cellNames = new HashMap();
        GDS.buildUniqueNames(this.topCell, this.cellNames);
    }

    public static void buildUniqueNames(Cell cell, HashMap cellNames) {
        if (!cellNames.containsKey(cell)) {
            cellNames.put(cell, GDS.makeUniqueName(cell, cellNames));
        }
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            if (!(ni.getProto() instanceof Cell)) continue;
            Cell c = (Cell)ni.getProto();
            Cell cproto = c.contentsView();
            if (cproto == null) {
                cproto = c;
            }
            if (!cellNames.containsKey(cproto)) {
                cellNames.put(cproto, GDS.makeUniqueName(cproto, cellNames));
            }
            GDS.buildUniqueNames(cproto, cellNames);
        }
    }

    public static String makeUniqueName(Cell cell, HashMap cellNames) {
        int liblen;
        String name = GDS.makeGDSName(cell.getName(), IOTool.getGDSCellNameLenMax());
        if (cell.getNewestVersion() != cell) {
            name = name + "_" + cell.getVersion();
        }
        String baseName = name;
        Collection existing = cellNames.values();
        if (existing.contains(name) && (liblen = IOTool.getGDSCellNameLenMax() - (name.length() + concatStr.length())) > 0) {
            String lib;
            String libname = lib.substring(0, liblen = liblen > (lib = cell.getLibrary().getName()).length() ? lib.length() : liblen) + concatStr + name;
            if (!existing.contains(libname)) {
                System.out.println("Warning: GDSII out renaming cell " + cell.describe(false) + " to " + libname);
                return libname;
            }
            baseName = libname;
        }
        int index = 1;
        while (existing.contains(name)) {
            name = baseName + "_" + index;
            int extra = name.length() - IOTool.getGDSCellNameLenMax();
            if (extra > 0) {
                name = baseName.substring(0, baseName.length() - extra);
                name = name + "_" + index;
            }
            ++index;
        }
        if (!name.equals(cell.getName())) {
            System.out.println("Warning: GDSII out renaming cell " + cell.describe(false) + " to " + name);
        }
        return name;
    }

    private static String makeGDSName(String str, int maxLen) {
        StringBuffer ret = new StringBuffer();
        int max = str.length();
        if (max > maxLen - 3) {
            max = maxLen - 3;
        }
        for (int k = 0; k < max; ++k) {
            int ch = str.charAt(k);
            if (IOTool.isGDSOutUpperCase()) {
                ch = Character.toUpperCase((char)ch);
            }
            if (ch != 36 && !TextUtils.isDigit((char)ch) && ch != 63 && !Character.isLetter((char)ch)) {
                ch = 95;
            }
            ret.append((char)ch);
        }
        return ret.toString();
    }

    private void doneWritingOutput() {
        try {
            if (bufferPosition > 0) {
                for (int i = bufferPosition; i < 512; ++i) {
                    GDS.dataBufferGDS[i] = 0;
                }
                this.dataOutputStream.write(dataBufferGDS, 0, 512);
                ++blockCount;
            }
            while (blockCount % 4 != 0) {
                this.dataOutputStream.write(emptyBuffer, 0, 512);
                ++blockCount;
            }
        }
        catch (IOException e) {
            System.out.println("End of file reached while finishing GDS");
        }
    }

    private void outputBeginLibrary(Cell cell) {
        this.outputHeader((short)2, 3);
        this.outputHeader((short)258, 0);
        this.outputDate(cell.getCreationDate());
        this.outputDate(cell.getRevisionDate());
        this.outputName((short)518, GDS.makeGDSName(cell.getName(), 256), 256);
        this.outputShort((short)20);
        this.outputShort((short)773);
        this.outputDouble(0.001);
        this.outputDouble(1.0E-9);
    }

    void outputBeginStruct(Cell cell) {
        this.outputHeader((short)1282, 0);
        this.outputDate(cell.getCreationDate());
        this.outputDate(cell.getRevisionDate());
        String name = (String)this.cellNames.get(cell);
        if (name == null) {
            System.out.println("Warning, sub" + cell + " in hierarchy is not the same view" + " as top level cell");
            name = GDS.makeUniqueName(cell, this.cellNames);
            this.cellNames.put(cell, name);
        }
        this.outputName((short)1542, name, IOTool.getGDSCellNameLenMax());
    }

    private void outputDate(Date val) {
        short[] date = new short[6];
        Calendar cal = Calendar.getInstance();
        cal.setTime(val);
        int year = cal.get(1) - 1900;
        date[0] = (short)year;
        date[1] = (short)cal.get(2);
        date[2] = (short)cal.get(5);
        date[3] = (short)cal.get(10);
        date[4] = (short)cal.get(12);
        date[5] = (short)cal.get(13);
        this.outputShortArray(date, 6);
    }

    private void outputHeader(short header, int p1) {
        int type = header & 0xFF;
        int count = 4;
        if (type != 0) {
            switch (header) {
                case 2: 
                case 3330: 
                case 3586: 
                case 5634: 
                case 5889: 
                case 6657: {
                    count = 6;
                    break;
                }
                case 258: 
                case 1282: {
                    count = 28;
                    break;
                }
                case 773: {
                    count = 20;
                    break;
                }
                default: {
                    System.out.println("No entry for header " + header);
                    return;
                }
            }
        }
        this.outputShort((short)count);
        this.outputShort(header);
        if (type == 0) {
            return;
        }
        if (count == 6) {
            this.outputShort((short)p1);
        }
        if (count == 8) {
            this.outputInt(p1);
        }
    }

    private void outputName(short header, String p1, int max) {
        this.outputString(p1, header, max);
    }

    private void outputAngle(int ang) {
        double gdfloat = (double)ang / 10.0;
        this.outputShort((short)12);
        this.outputShort((short)7173);
        this.outputDouble(gdfloat);
    }

    private void outputMag(double scale) {
        this.outputShort((short)12);
        this.outputShort((short)6917);
        this.outputDouble(scale);
    }

    private void outputBoundary(PolyBase poly, int layerNumber, int layerType) {
        Point2D[] points = poly.getPoints();
        Point2D[] newPoints = new Point2D[points.length];
        int count = 0;
        newPoints[count++] = points[0];
        for (int i = 1; i < points.length; ++i) {
            if (points[i].equals(points[i - 1])) continue;
            newPoints[count++] = points[i];
        }
        points = newPoints;
        if (count > 510) {
            return;
        }
        int start = 0;
        while (true) {
            int sofar;
            for (sofar = start + 1; sofar < count && (points[sofar].getX() != points[start].getX() || points[sofar].getY() != points[start].getY()); ++sofar) {
            }
            if (sofar < count) {
                ++sofar;
            }
            this.outputHeader((short)2048, 0);
            this.outputHeader((short)3330, layerNumber);
            this.outputHeader((short)3586, layerType);
            this.outputShort((short)(8 * (sofar + 1) + 4));
            this.outputShort((short)4099);
            for (int i = start; i <= sofar; ++i) {
                int j = i;
                if (i == sofar) {
                    j = 0;
                }
                this.outputInt(this.scaleDBUnit(points[j].getX()));
                this.outputInt(this.scaleDBUnit(points[j].getY()));
            }
            this.outputHeader((short)4352, 0);
            if (sofar >= count) break;
            count -= sofar;
            start = sofar;
        }
    }

    private void outputPath(PolyBase poly, int layerNumber, int layerType) {
        this.outputHeader((short)2304, 0);
        this.outputHeader((short)3330, layerNumber);
        this.outputHeader((short)3586, layerType);
        Point2D[] points = poly.getPoints();
        int count = 8 * points.length + 4;
        this.outputShort((short)count);
        this.outputShort((short)4099);
        for (int i = 0; i < points.length; ++i) {
            this.outputInt(this.scaleDBUnit(points[i].getX()));
            this.outputInt(this.scaleDBUnit(points[i].getY()));
        }
        this.outputHeader((short)4352, 0);
    }

    private void outputByte(byte val) {
        GDS.dataBufferGDS[GDS.bufferPosition++] = val;
        if (bufferPosition >= 512) {
            try {
                this.dataOutputStream.write(dataBufferGDS, 0, 512);
            }
            catch (IOException e) {
                System.out.println("End of file reached while writing GDS");
            }
            ++blockCount;
            bufferPosition = 0;
        }
    }

    private int scaleDBUnit(double dbunit) {
        double scaled = scaleFactor * dbunit;
        int unit = (int)Math.round(scaled);
        return unit;
    }

    private void outputShort(short val) {
        this.outputByte((byte)(val >> 8 & 0xFF));
        this.outputByte((byte)(val & 0xFF));
    }

    private void outputInt(int val) {
        this.outputShort((short)(val >> 16));
        this.outputShort((short)val);
    }

    private void outputShortArray(short[] ptr, int n) {
        for (int i = 0; i < n; ++i) {
            this.outputShort(ptr[i]);
        }
    }

    private void outputIntArray(int[] ptr, int n) {
        for (int i = 0; i < n; ++i) {
            this.outputInt(ptr[i]);
        }
    }

    private void outputString(String str, short header) {
        this.outputString(str, header, 512);
    }

    private void outputString(String str, short header, int max) {
        int i;
        int j = str.length();
        if (j > max) {
            j = max;
        }
        if (j % 2 != 0) {
            j = j / 2 * 2 + 2;
        }
        this.outputShort((short)(4 + j));
        this.outputShort(header);
        if (!$assertionsDisabled && j % 2 != 0) {
            throw new AssertionError();
        }
        if (IOTool.isGDSOutUpperCase()) {
            for (i = 0; i < str.length(); ++i) {
                this.outputByte((byte)Character.toUpperCase(str.charAt(i)));
            }
        } else {
            while (i < str.length()) {
                this.outputByte((byte)str.charAt(i));
                ++i;
            }
        }
        while (i < j) {
            this.outputByte((byte)0);
            ++i;
        }
    }

    public void outputDouble(double data) {
        int exponent;
        if (data == 0.0) {
            for (int i = 0; i < 8; ++i) {
                this.outputByte((byte)0);
            }
            return;
        }
        BigDecimal reg = new BigDecimal(data).setScale(64, 6);
        boolean negSign = false;
        if (reg.doubleValue() < 0.0) {
            negSign = true;
            reg = reg.negate();
        }
        for (exponent = 64; reg.doubleValue() < 0.0625 && exponent > 0; --exponent) {
            reg = reg.multiply(new BigDecimal(16.0));
        }
        if (exponent == 0) {
            System.out.println("Exponent underflow");
        }
        while (reg.doubleValue() >= 1.0 && exponent < 128) {
            reg = reg.divide(new BigDecimal(16.0), 6);
            ++exponent;
        }
        if (exponent > 127) {
            System.out.println("Exponent overflow");
        }
        if (negSign) {
            exponent |= 0x80;
        }
        BigDecimal f_mantissa = reg.subtract(new BigDecimal(reg.intValue()));
        for (int i = 0; i < 56; ++i) {
            f_mantissa = f_mantissa.multiply(new BigDecimal(2.0));
        }
        long mantissa = f_mantissa.longValue();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(exponent);
        for (int i = 6; i >= 0; --i) {
            baos.write((int)(mantissa >> i * 8 & 0xFFL));
        }
        byte[] result = baos.toByteArray();
        for (int i = 0; i < 8; ++i) {
            this.outputByte(result[i]);
        }
    }

    static {
        $assertionsDisabled = !GDS.class.desiredAssertionStatus();
        dataBufferGDS = new byte[512];
        emptyBuffer = new byte[512];
    }

    private class BloatVisitor
    extends Geometry.Visitor {
        BloatVisitor(Geometry outGeom, int maxHierDepth) {
            super(GDS.this, outGeom, maxHierDepth);
        }

        public void addNodeInst(NodeInst ni, AffineTransform trans) {
            PrimitiveNode prim = (PrimitiveNode)ni.getProto();
            Technology tech = prim.getTechnology();
            Poly[] polys = tech.getShapeOfNode(ni);
            Layer firstLayer = null;
            for (int i = 0; i < polys.length; ++i) {
                Poly poly = polys[i];
                Layer thisLayer = poly.getLayer();
                if (thisLayer != null && firstLayer == null) {
                    firstLayer = thisLayer;
                }
                if (poly.getStyle().isText()) {
                    GDS.this.outputHeader((short)3072, 0);
                    if (firstLayer != null) {
                        GDS.this.selectLayer(firstLayer);
                    }
                    Integer firstLayerVal = currentLayerNumbers.getFirstLayer();
                    int layerNum = firstLayerVal & 0xFFFF;
                    int layerType = firstLayerVal >> 16 & 0xFFFF;
                    GDS.this.outputHeader((short)3330, layerNum);
                    GDS.this.outputHeader((short)5634, layerType);
                    GDS.this.outputHeader((short)5889, 0);
                    int transValue = 0;
                    int angle = ni.getAngle();
                    if (ni.isXMirrored() != ni.isYMirrored()) {
                        transValue |= 0x8000;
                    }
                    if (ni.isYMirrored()) {
                        angle = (3600 - angle) % 3600;
                    }
                    if (ni.isXMirrored()) {
                        angle = (1800 - angle) % 3600;
                    }
                    GDS.this.outputHeader((short)6657, transValue);
                    GDS.this.outputAngle(angle);
                    GDS.this.outputShort((short)12);
                    GDS.this.outputShort((short)4099);
                    Point2D[] points = poly.getPoints();
                    GDS.this.outputInt(GDS.this.scaleDBUnit(points[0].getX()));
                    GDS.this.outputInt(GDS.this.scaleDBUnit(points[0].getY()));
                    String str = poly.getString();
                    GDS.this.outputString(str, (short)6406);
                    GDS.this.outputHeader((short)4352, 0);
                }
                poly.transform(trans);
            }
            this.cellGeom.addPolys(polys, ni);
        }

        public void addArcInst(ArcInst ai) {
            ArcProto ap = ai.getProto();
            Technology tech = ap.getTechnology();
            Poly[] polys = tech.getShapeOfArc(ai);
            this.cellGeom.addPolys(polys, ai);
        }
    }
}

