/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.MutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.io.GDSLayers;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.input.Input;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class GDS
extends Input {
    private static final int MAXPOINTS = 4096;
    private static final int MINFONTWIDTH = 130;
    private static final int MINFONTHEIGHT = 190;
    private static final ShapeType SHAPEPOLY = new ShapeType();
    private static final ShapeType SHAPERECTANGLE = new ShapeType();
    private static final ShapeType SHAPEOBLIQUE = new ShapeType();
    private static final ShapeType SHAPELINE = new ShapeType();
    private static final ShapeType SHAPECLOSED = new ShapeType();
    private static final DatatypeSymbol TYPEERR = new DatatypeSymbol();
    private static final DatatypeSymbol TYPENONE = new DatatypeSymbol();
    private static final DatatypeSymbol TYPEFLAGS = new DatatypeSymbol();
    private static final DatatypeSymbol TYPESHORT = new DatatypeSymbol();
    private static final DatatypeSymbol TYPELONG = new DatatypeSymbol();
    private static final DatatypeSymbol TYPEFLOAT = new DatatypeSymbol();
    private static final DatatypeSymbol TYPEDOUBLE = new DatatypeSymbol();
    private static final DatatypeSymbol TYPESTRING = new DatatypeSymbol();
    private static final double twoTo32 = GDS.makePower(2, 32);
    private static final double twoToNeg56 = 1.0 / GDS.makePower(2, 56);
    private Library theLibrary;
    private Cell theCell;
    private NodeProto theNodeProto;
    private NodeProto layerNodeProto;
    private NodeProto pinNodeProto;
    private boolean layerUsed;
    private boolean layerIsPin;
    private Technology curTech;
    private int recordCount;
    private GSymbol theToken;
    private DatatypeSymbol valuetype;
    private int tokenFlags;
    private int tokenValue16;
    private int tokenValue32;
    private double tokenValueDouble;
    private String tokenString;
    private Point2D[] theVertices;
    private double theScale;
    private HashMap layerNames;
    private HashSet pinLayers;
    private static final GSymbol GDS_HEADER = new GSymbol(0);
    private static final GSymbol GDS_BGNLIB = new GSymbol(1);
    private static final GSymbol GDS_LIBNAME = new GSymbol(2);
    private static final GSymbol GDS_UNITS = new GSymbol(3);
    private static final GSymbol GDS_ENDLIB = new GSymbol(4);
    private static final GSymbol GDS_BGNSTR = new GSymbol(5);
    private static final GSymbol GDS_STRNAME = new GSymbol(6);
    private static final GSymbol GDS_ENDSTR = new GSymbol(7);
    private static final GSymbol GDS_BOUNDARY = new GSymbol(8);
    private static final GSymbol GDS_PATH = new GSymbol(9);
    private static final GSymbol GDS_SREF = new GSymbol(10);
    private static final GSymbol GDS_AREF = new GSymbol(11);
    private static final GSymbol GDS_TEXTSYM = new GSymbol(12);
    private static final GSymbol GDS_LAYER = new GSymbol(13);
    private static final GSymbol GDS_DATATYPSYM = new GSymbol(14);
    private static final GSymbol GDS_WIDTH = new GSymbol(15);
    private static final GSymbol GDS_XY = new GSymbol(16);
    private static final GSymbol GDS_ENDEL = new GSymbol(17);
    private static final GSymbol GDS_SNAME = new GSymbol(18);
    private static final GSymbol GDS_COLROW = new GSymbol(19);
    private static final GSymbol GDS_TEXTNODE = new GSymbol(20);
    private static final GSymbol GDS_NODE = new GSymbol(21);
    private static final GSymbol GDS_TEXTTYPE = new GSymbol(22);
    private static final GSymbol GDS_PRESENTATION = new GSymbol(23);
    private static final GSymbol GDS_SPACING = new GSymbol(24);
    private static final GSymbol GDS_STRING = new GSymbol(25);
    private static final GSymbol GDS_STRANS = new GSymbol(26);
    private static final GSymbol GDS_MAG = new GSymbol(27);
    private static final GSymbol GDS_ANGLE = new GSymbol(28);
    private static final GSymbol GDS_UINTEGER = new GSymbol(29);
    private static final GSymbol GDS_USTRING = new GSymbol(30);
    private static final GSymbol GDS_REFLIBS = new GSymbol(31);
    private static final GSymbol GDS_FONTS = new GSymbol(32);
    private static final GSymbol GDS_PATHTYPE = new GSymbol(33);
    private static final GSymbol GDS_GENERATIONS = new GSymbol(34);
    private static final GSymbol GDS_ATTRTABLE = new GSymbol(35);
    private static final GSymbol GDS_STYPTABLE = new GSymbol(36);
    private static final GSymbol GDS_STRTYPE = new GSymbol(37);
    private static final GSymbol GDS_ELFLAGS = new GSymbol(38);
    private static final GSymbol GDS_ELKEY = new GSymbol(39);
    private static final GSymbol GDS_LINKTYPE = new GSymbol(40);
    private static final GSymbol GDS_LINKKEYS = new GSymbol(41);
    private static final GSymbol GDS_NODETYPE = new GSymbol(42);
    private static final GSymbol GDS_PROPATTR = new GSymbol(43);
    private static final GSymbol GDS_PROPVALUE = new GSymbol(44);
    private static final GSymbol GDS_BOX = new GSymbol(45);
    private static final GSymbol GDS_BOXTYPE = new GSymbol(46);
    private static final GSymbol GDS_PLEX = new GSymbol(47);
    private static final GSymbol GDS_BGNEXTN = new GSymbol(48);
    private static final GSymbol GDS_ENDEXTN = new GSymbol(49);
    private static final GSymbol GDS_TAPENUM = new GSymbol(50);
    private static final GSymbol GDS_TAPECODE = new GSymbol(51);
    private static final GSymbol GDS_STRCLASS = new GSymbol(52);
    private static final GSymbol GDS_NUMTYPES = new GSymbol(53);
    private static final GSymbol GDS_IDENT = new GSymbol(54);
    private static final GSymbol GDS_REALNUM = new GSymbol(55);
    private static final GSymbol GDS_SHORT_NUMBER = new GSymbol(56);
    private static final GSymbol GDS_NUMBER = new GSymbol(57);
    private static final GSymbol GDS_FLAGSYM = new GSymbol(58);
    private static final GSymbol GDS_FORMAT = new GSymbol(59);
    private static final GSymbol GDS_MASK = new GSymbol(60);
    private static final GSymbol GDS_ENDMASKS = new GSymbol(61);
    private static GSymbol[] optionSet = new GSymbol[]{GDS_ATTRTABLE, GDS_REFLIBS, GDS_FONTS, GDS_GENERATIONS};
    private static GSymbol[] shapeSet = new GSymbol[]{GDS_AREF, GDS_SREF, GDS_BOUNDARY, GDS_PATH, GDS_NODE, GDS_TEXTSYM, GDS_BOX};
    private static GSymbol[] goodOpSet = new GSymbol[]{GDS_HEADER, GDS_BGNLIB, GDS_LIBNAME, GDS_UNITS, GDS_ENDLIB, GDS_BGNSTR, GDS_STRNAME, GDS_ENDSTR, GDS_BOUNDARY, GDS_PATH, GDS_SREF, GDS_AREF, GDS_TEXTSYM, GDS_LAYER, GDS_DATATYPSYM, GDS_WIDTH, GDS_XY, GDS_ENDEL, GDS_SNAME, GDS_COLROW, GDS_TEXTNODE, GDS_NODE, GDS_TEXTTYPE, GDS_PRESENTATION, GDS_STRING, GDS_STRANS, GDS_MAG, GDS_ANGLE, GDS_REFLIBS, GDS_FONTS, GDS_PATHTYPE, GDS_GENERATIONS, GDS_ATTRTABLE, GDS_NODETYPE, GDS_PROPATTR, GDS_PROPVALUE, GDS_BOX, GDS_BOXTYPE, GDS_FORMAT, GDS_MASK, GDS_ENDMASKS};
    private static GSymbol[] maskSet = new GSymbol[]{GDS_DATATYPSYM, GDS_TEXTTYPE, GDS_BOXTYPE, GDS_NODETYPE};
    private static GSymbol[] unsupportedSet = new GSymbol[]{GDS_ELFLAGS, GDS_PLEX};

    protected boolean importALibrary(Library lib) {
        MakeInstance.init();
        this.theLibrary = lib;
        try {
            this.loadFile();
        }
        catch (IOException e) {
            System.out.println("ERROR reading GDS file");
        }
        MakeInstance.buildInstances();
        MakeInstance.term();
        return false;
    }

    private void initialize() {
        this.layerNodeProto = Generic.tech.drcNode;
        this.theVertices = new Point2D[4096];
        for (int i = 0; i < 4096; ++i) {
            this.theVertices[i] = new Point2D.Double();
        }
        this.recordCount = 0;
        this.layerNames = new HashMap();
        this.pinLayers = new HashSet();
        boolean valid = false;
        this.curTech = Technology.getCurrent();
        Iterator it = this.curTech.getLayers();
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            String gdsName = layer.getGDSLayer();
            if (gdsName == null || gdsName.length() <= 0) continue;
            GDSLayers gdsl = GDSLayers.parseLayerString(gdsName);
            Iterator lIt = gdsl.getLayers();
            while (lIt.hasNext()) {
                Integer lVal = (Integer)lIt.next();
                Integer lay = new Integer(lVal);
                if (this.layerNames.get(lay) != null) continue;
                this.layerNames.put(lay, layer);
            }
            if (gdsl.getPinLayer() != -1) {
                this.pinLayers.add(new Integer(gdsl.getPinLayer()));
            }
            valid = true;
        }
        if (!valid) {
            System.out.println("There are no GDS layer names assigned in the " + this.curTech.getTechName() + " technology");
        }
    }

    private List parseLayerNumbers(String layerNumbers) {
        String[] numberStrings = layerNumbers.split(",");
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        for (int i = 0; i < numberStrings.length; ++i) {
            String numberString = numberStrings[i].trim();
            if (!TextUtils.isANumber(numberString)) continue;
            numbers.add(new Integer(TextUtils.atoi(numberString)));
        }
        return numbers;
    }

    private void loadFile() throws IOException {
        this.initialize();
        this.getToken();
        this.readHeader();
        this.getToken();
        this.readLibrary();
        this.getToken();
        while (this.isMember(this.theToken, optionSet)) {
            if (this.theToken == GDS_REFLIBS) {
                this.readRefLibs();
                continue;
            }
            if (this.theToken == GDS_FONTS) {
                this.readFonts();
                continue;
            }
            if (this.theToken == GDS_ATTRTABLE) {
                this.readAttrTable();
                continue;
            }
            if (this.theToken != GDS_GENERATIONS) continue;
            this.readGenerations();
        }
        while (this.theToken != GDS_UNITS) {
            this.getToken();
        }
        this.readUnits();
        this.getToken();
        while (this.theToken != GDS_ENDLIB) {
            this.readStructure();
            this.getToken();
        }
    }

    private void readHeader() throws IOException {
        if (this.theToken != GDS_HEADER) {
            this.handleError("GDS II header statement is missing");
        }
        this.getToken();
        if (this.theToken != GDS_SHORT_NUMBER) {
            this.handleError("GDS II version number is not decipherable");
        }
    }

    private void readLibrary() throws IOException {
        if (this.theToken != GDS_BGNLIB) {
            this.handleError("Begin library statement is missing");
        }
        this.getToken();
        String createTime = this.determineTime();
        String modTime = this.determineTime();
        if (this.theToken == GDS_LIBNAME) {
            this.getToken();
            if (this.theToken != GDS_IDENT) {
                this.handleError("Library name is missing");
            }
            String string = this.tokenString;
        }
    }

    private void readRefLibs() throws IOException {
        this.getToken();
        this.getToken();
    }

    private void readFonts() throws IOException {
        this.getToken();
        this.getToken();
    }

    private void readAttrTable() throws IOException {
        this.getToken();
        if (this.theToken == GDS_IDENT) {
            this.getToken();
        }
    }

    private void readUnits() throws IOException {
        if (this.theToken != GDS_UNITS) {
            this.handleError("Units statement is missing");
        }
        this.getToken();
        if (this.theToken != GDS_REALNUM) {
            this.handleError("Units statement has invalid number format");
        }
        double dbUnit = this.tokenValueDouble;
        this.getToken();
        double meterUnit = this.tokenValueDouble;
        this.theScale = meterUnit * 1000000.0 * TextUtils.convertFromDistance(1.0, this.curTech, TextUtils.UnitScale.MICRO);
    }

    private void readStructure() throws IOException {
        this.beginStructure();
        this.getToken();
        while (this.theToken != GDS_ENDSTR) {
            this.getElement();
            this.getToken();
        }
    }

    private void beginStructure() throws IOException {
        if (this.theToken != GDS_BGNSTR) {
            this.handleError("Begin structure statement is missing");
        }
        this.getToken();
        String createTime = this.determineTime();
        String modTime = this.determineTime();
        if (this.theToken != GDS_STRNAME) {
            this.handleError("Strname statement is missing");
        }
        this.getToken();
        if (this.theToken != GDS_IDENT) {
            this.handleError("Structure name is missing");
        }
        this.theCell = this.findCell(this.tokenString);
        if (this.theCell == null) {
            this.theCell = Cell.newInstance(this.theLibrary, this.tokenString + "{" + View.LAYOUT.getAbbreviation() + "}");
            if (this.theCell == null) {
                this.handleError("Failed to create structure");
            }
            System.out.println("Reading " + this.tokenString);
            if (this.theLibrary.getCurCell() == null) {
                this.theLibrary.setCurCell(this.theCell);
            }
        }
    }

    private Cell findCell(String name) {
        return this.theLibrary.findNodeProto(name);
    }

    private void getElement() throws IOException {
        while (this.isMember(this.theToken, shapeSet)) {
            if (this.theToken == GDS_AREF) {
                this.determineARef();
                continue;
            }
            if (this.theToken == GDS_SREF) {
                this.determineSRef();
                continue;
            }
            if (this.theToken == GDS_BOUNDARY) {
                this.determineShape();
                continue;
            }
            if (this.theToken == GDS_PATH) {
                this.determinePath();
                continue;
            }
            if (this.theToken == GDS_NODE) {
                this.determineNode();
                continue;
            }
            if (this.theToken == GDS_TEXTSYM) {
                this.determineText();
                continue;
            }
            if (this.theToken != GDS_BOX) continue;
            this.determineBox();
        }
        while (this.theToken == GDS_PROPATTR) {
            this.determineProperty();
        }
        if (this.theToken != GDS_ENDEL) {
            this.handleError("Element end statement is missing");
        }
    }

    private void determineARef() throws IOException {
        this.getToken();
        this.readUnsupported(unsupportedSet);
        if (this.theToken != GDS_SNAME) {
            this.handleError("Array reference name is missing");
        }
        this.getToken();
        this.getPrototype(this.tokenString);
        this.getToken();
        int angle = 0;
        boolean trans = false;
        if (this.theToken == GDS_STRANS) {
            ReadOrientation ro = new ReadOrientation();
            ro.doIt();
            angle = ro.angle;
            trans = ro.trans;
        }
        int nCols = 0;
        int nRows = 0;
        if (this.theToken == GDS_COLROW) {
            this.getToken();
            nCols = this.tokenValue16;
            this.getToken();
            nRows = this.tokenValue16;
            this.getToken();
        }
        if (this.theToken != GDS_XY) {
            this.handleError("Array reference has no parameters");
        }
        this.getToken();
        int n = this.determinePoints(3, 3);
        Point2D.Double colInterval = new Point2D.Double(0.0, 0.0);
        if (nCols != 1) {
            ((Point2D)colInterval).setLocation((this.theVertices[1].getX() - this.theVertices[0].getX()) / (double)nCols, (this.theVertices[1].getY() - this.theVertices[0].getY()) / (double)nCols);
            this.makeTransform(colInterval, angle, trans);
        }
        Point2D.Double rowInterval = new Point2D.Double(0.0, 0.0);
        if (nRows != 1) {
            ((Point2D)rowInterval).setLocation((this.theVertices[2].getX() - this.theVertices[0].getX()) / (double)nRows, (this.theVertices[2].getY() - this.theVertices[0].getY()) / (double)nRows);
            this.makeTransform(rowInterval, angle, trans);
        }
        boolean mY = false;
        boolean mX = false;
        if (trans) {
            mY = true;
            angle = (angle + 900) % 3600;
        }
        double ptcX = this.theVertices[0].getX();
        double ptcY = this.theVertices[0].getY();
        for (int ic = 0; ic < nCols; ++ic) {
            double ptX = ptcX;
            double ptY = ptcY;
            for (int ir = 0; ir < nRows; ++ir) {
                if (IOTool.isGDSInInstantiatesArrays() || ir == 0 && ic == 0 || ir == nRows - 1 && ic == nCols - 1) {
                    Point2D.Double loc = new Point2D.Double(ptX, ptY);
                    new MakeInstance(this.theCell, (Cell)this.theNodeProto, loc, mX, mY, angle);
                }
                ptX += ((Point2D)rowInterval).getX();
                ptY += ((Point2D)rowInterval).getY();
            }
            ptcX += ((Point2D)colInterval).getX();
            ptcY += ((Point2D)colInterval).getY();
        }
    }

    private void makeTransform(Point2D delta, int angle, boolean trans) {
        Orientation orient = Orientation.fromC(angle, trans);
        AffineTransform xform = orient.pureRotate();
        xform.transform(delta, delta);
    }

    private void determineSRef() throws IOException {
        this.getToken();
        this.readUnsupported(unsupportedSet);
        if (this.theToken != GDS_SNAME) {
            this.handleError("Structure reference name is missing");
        }
        this.getToken();
        this.getPrototype(this.tokenString);
        this.getToken();
        int angle = 0;
        boolean trans = false;
        if (this.theToken == GDS_STRANS) {
            ReadOrientation ro = new ReadOrientation();
            ro.doIt();
            angle = ro.angle;
            trans = ro.trans;
        }
        if (this.theToken != GDS_XY) {
            this.handleError("Structure reference has no translation value");
        }
        this.getToken();
        int n = this.determinePoints(1, 1);
        Point2D.Double loc = new Point2D.Double(this.theVertices[0].getX(), this.theVertices[0].getY());
        boolean mY = false;
        if (trans) {
            mY = true;
            angle = (angle + 900) % 3600;
        }
        new MakeInstance(this.theCell, (Cell)this.theNodeProto, loc, false, mY, angle);
    }

    private void determineShape() throws IOException {
        this.getToken();
        this.readUnsupported(unsupportedSet);
        this.determineLayer();
        this.getToken();
        if (this.theToken != GDS_XY) {
            this.handleError("Boundary has no points");
        }
        this.getToken();
        int n = this.determinePoints(3, 4096);
        this.determineBoundary(n);
    }

    private void determineBoundary(int npts) throws IOException {
        boolean is90 = true;
        boolean is45 = true;
        for (int i = 0; i < npts - 1 && i < 4095; ++i) {
            double dx = this.theVertices[i + 1].getX() - this.theVertices[i].getX();
            double dy = this.theVertices[i + 1].getY() - this.theVertices[i].getY();
            if (dx == 0.0 || dy == 0.0) continue;
            is90 = false;
            if (Math.abs(dx) == Math.abs(dy)) continue;
            is45 = false;
        }
        ShapeType perimeter = SHAPELINE;
        if (this.theVertices[0].getX() == this.theVertices[npts - 1].getX() && this.theVertices[0].getY() == this.theVertices[npts - 1].getY()) {
            perimeter = SHAPECLOSED;
        }
        ShapeType oclass = SHAPEOBLIQUE;
        if (perimeter == SHAPECLOSED && (is90 || is45)) {
            oclass = SHAPEPOLY;
        }
        if (npts == 5 && is90 && perimeter == SHAPECLOSED) {
            oclass = SHAPERECTANGLE;
        }
        if (oclass == SHAPERECTANGLE) {
            double sY;
            double sX;
            Point2D.Double ctr;
            NodeInst ni;
            this.readBox();
            if (this.layerUsed && (ni = NodeInst.makeInstance(this.layerNodeProto, ctr = new Point2D.Double((this.theVertices[0].getX() + this.theVertices[1].getX()) / 2.0, (this.theVertices[0].getY() + this.theVertices[1].getY()) / 2.0), sX = Math.abs(this.theVertices[1].getX() - this.theVertices[0].getX()), sY = Math.abs(this.theVertices[1].getY() - this.theVertices[0].getY()), this.theCell)) == null) {
                this.handleError("Failed to create RECTANGLE");
            }
            return;
        }
        if (oclass == SHAPEOBLIQUE || oclass == SHAPEPOLY) {
            if (!this.layerUsed) {
                return;
            }
            double lx = this.theVertices[0].getX();
            double hx = this.theVertices[0].getX();
            double ly = this.theVertices[0].getY();
            double hy = this.theVertices[0].getY();
            for (int i = 1; i < npts; ++i) {
                if (lx > this.theVertices[i].getX()) {
                    lx = this.theVertices[i].getX();
                }
                if (hx < this.theVertices[i].getX()) {
                    hx = this.theVertices[i].getX();
                }
                if (ly > this.theVertices[i].getY()) {
                    ly = this.theVertices[i].getY();
                }
                if (!(hy < this.theVertices[i].getY())) continue;
                hy = this.theVertices[i].getY();
            }
            NodeInst ni = NodeInst.makeInstance(this.layerNodeProto, new Point2D.Double((lx + hx) / 2.0, (ly + hy) / 2.0), hx - lx, hy - ly, this.theCell);
            if (ni == null) {
                this.handleError("Failed to create POLYGON");
            }
            double cx = (hx + lx) / 2.0;
            double cy = (hy + ly) / 2.0;
            Point2D[] points = new Point2D[npts];
            for (int i = 0; i < npts; ++i) {
                points[i] = new Point2D.Double(this.theVertices[i].getX() - cx, this.theVertices[i].getY() - cy);
            }
            ni.newVar(NodeInst.TRACE, (Object)points);
            return;
        }
    }

    private void readBox() {
        double pxm = this.theVertices[4].getX();
        double pxs = this.theVertices[4].getX();
        double pym = this.theVertices[4].getY();
        double pys = this.theVertices[4].getY();
        for (int i = 0; i < 4; ++i) {
            if (this.theVertices[i].getX() > pxm) {
                pxm = this.theVertices[i].getX();
            }
            if (this.theVertices[i].getX() < pxs) {
                pxs = this.theVertices[i].getX();
            }
            if (this.theVertices[i].getY() > pym) {
                pym = this.theVertices[i].getY();
            }
            if (!(this.theVertices[i].getY() < pys)) continue;
            pys = this.theVertices[i].getY();
        }
        this.theVertices[0].setLocation(pxs, pys);
        this.theVertices[1].setLocation(pxm, pym);
    }

    private void determinePath() throws IOException {
        double bgnextend;
        int endcode = 0;
        this.getToken();
        this.readUnsupported(unsupportedSet);
        this.determineLayer();
        this.getToken();
        if (this.theToken == GDS_PATHTYPE) {
            this.getToken();
            endcode = this.tokenValue16;
            this.getToken();
        }
        double width = 0.0;
        if (this.theToken == GDS_WIDTH) {
            this.getToken();
            width = (double)this.tokenValue32 * this.theScale;
            this.getToken();
        }
        double endextend = bgnextend = endcode == 0 || endcode == 4 ? 0.0 : width / 2.0;
        if (this.theToken == GDS_BGNEXTN) {
            this.getToken();
            if (endcode == 4) {
                bgnextend = (double)this.tokenValue32 * this.theScale;
            }
            this.getToken();
        }
        if (this.theToken == GDS_ENDEXTN) {
            this.getToken();
            if (endcode == 4) {
                endextend = (double)this.tokenValue32 * this.theScale;
            }
            this.getToken();
        }
        if (this.theToken == GDS_XY) {
            this.getToken();
            int n = this.determinePoints(2, 4096);
            for (int i = 0; i < n - 1; ++i) {
                double cy;
                int ang;
                double fextend;
                Point2D fromPt = this.theVertices[i];
                Point2D toPt = this.theVertices[i + 1];
                double textend = fextend = width / 2.0;
                int thisAngle = GenMath.figureAngle(fromPt, toPt);
                if (i > 0) {
                    Point2D prevPoint = this.theVertices[i - 1];
                    int lastAngle = GenMath.figureAngle(prevPoint, fromPt);
                    if (Math.abs(thisAngle - lastAngle) % 900 != 0) {
                        ang = Math.abs(thisAngle - lastAngle) / 10;
                        if (ang > 180) {
                            ang = 360 - ang;
                        }
                        if (ang > 90) {
                            ang = 180 - ang;
                        }
                        fextend = ArcInst.getExtendFactor(width, ang);
                    }
                } else {
                    fextend = bgnextend;
                }
                if (i + 1 < n - 1) {
                    Point2D nextPoint = this.theVertices[i + 2];
                    int nextAngle = GenMath.figureAngle(toPt, nextPoint);
                    if (Math.abs(thisAngle - nextAngle) % 900 != 0) {
                        ang = Math.abs(thisAngle - nextAngle) / 10;
                        if (ang > 180) {
                            ang = 360 - ang;
                        }
                        if (ang > 90) {
                            ang = 180 - ang;
                        }
                        textend = ArcInst.getExtendFactor(width, ang);
                    }
                } else {
                    textend = endextend;
                }
                if (!this.layerUsed) continue;
                double length = fromPt.distance(toPt);
                Poly poly = Poly.makeEndPointPoly(length, width, GenMath.figureAngle(fromPt, toPt), fromPt, fextend, toPt, textend);
                Rectangle2D polyBox = poly.getBox();
                if (polyBox != null) {
                    NodeInst ni = NodeInst.makeInstance(this.layerNodeProto, new Point2D.Double(polyBox.getCenterX(), polyBox.getCenterY()), polyBox.getWidth(), polyBox.getHeight(), this.theCell);
                    if (ni != null) continue;
                    this.handleError("Failed to create outline");
                    continue;
                }
                polyBox = poly.getBounds2D();
                double cx = polyBox.getCenterX();
                NodeInst ni = NodeInst.makeInstance(this.layerNodeProto, new Point2D.Double(cx, cy = polyBox.getCenterY()), polyBox.getWidth(), polyBox.getHeight(), this.theCell);
                if (ni == null) {
                    this.handleError("Failed to create outline");
                }
                Point2D[] polyPoints = poly.getPoints();
                Point2D[] points = new Point2D[polyPoints.length];
                for (int j = 0; j < polyPoints.length; ++j) {
                    points[j] = new Point2D.Double(polyPoints[j].getX() - cx, polyPoints[j].getY() - cy);
                }
                ni.newVar(NodeInst.TRACE, (Object)points);
            }
        } else {
            this.handleError("Path element has no points");
        }
    }

    private void determineNode() throws IOException {
        this.getToken();
        this.readUnsupported(unsupportedSet);
        if (this.theToken != GDS_LAYER) {
            this.handleError("Boundary has no points");
        }
        this.getToken();
        int layerNum = this.tokenValue16;
        if (this.theToken == GDS_SHORT_NUMBER) {
            this.getToken();
        }
        int layerType = this.tokenValue16;
        if (this.theToken == GDS_NODETYPE) {
            this.getToken();
            this.getToken();
        }
        this.setLayer(layerNum, layerType);
        if (this.theToken != GDS_XY) {
            this.handleError("Boundary has no points");
        }
        this.getToken();
        this.determinePoints(1, 1);
        NodeInst ni = NodeInst.makeInstance(this.layerNodeProto, this.theVertices[0], 0.0, 0.0, this.theCell);
        if (ni == null) {
            this.handleError("Failed to create NODE");
        }
    }

    private void determineText() throws IOException {
        String textString;
        double scale;
        boolean trans;
        int angle;
        int horiz_just;
        int vert_just;
        block9: {
            this.getToken();
            this.readUnsupported(unsupportedSet);
            this.determineLayer();
            this.getToken();
            vert_just = -1;
            horiz_just = -1;
            if (this.theToken == GDS_PRESENTATION) {
                Point just = this.determineJustification();
                vert_just = just.x;
                horiz_just = just.y;
            }
            if (this.theToken == GDS_PATHTYPE) {
                this.getToken();
                this.getToken();
            }
            if (this.theToken == GDS_WIDTH) {
                this.getToken();
                this.getToken();
            }
            angle = 0;
            trans = false;
            scale = 1.0;
            textString = "";
            while (true) {
                if (this.theToken == GDS_STRANS) {
                    ReadOrientation ro = new ReadOrientation();
                    ro.doIt();
                    angle = ro.angle;
                    trans = ro.trans;
                    scale = ro.scale;
                    continue;
                }
                if (this.theToken == GDS_XY) {
                    this.getToken();
                    int n = this.determinePoints(1, 1);
                    continue;
                }
                if (this.theToken == GDS_ANGLE) {
                    this.getToken();
                    angle = (int)(this.tokenValueDouble * 10.0);
                    this.getToken();
                    continue;
                }
                if (this.theToken == GDS_STRING) {
                    if (this.recordCount != 0) {
                        this.getToken();
                        textString = this.tokenString;
                    }
                    this.getToken();
                    break block9;
                }
                if (this.theToken != GDS_MAG) break;
                this.getToken();
                this.getToken();
            }
            this.handleError("Text element has no reference point");
        }
        this.readText(textString, vert_just, horiz_just, angle, trans, scale);
    }

    private void readText(String charstring, int vjust, int hjust, int angle, boolean trans, double scale) throws IOException {
        if (!this.layerUsed) {
            return;
        }
        if (this.layerIsPin) {
            NodeProto np = this.pinNodeProto;
            NodeInst ni = NodeInst.makeInstance(np, this.theVertices[0], np.getDefWidth(), np.getDefHeight(), this.theCell);
            if (ni == null) {
                this.handleError("Could not create pin marker");
            }
            if (ni.getNumPortInsts() > 0) {
                PortInst pi = ni.getPortInst(0);
                Export.newInstance(this.theCell, pi, charstring);
            }
            return;
        }
        if (!IOTool.isGDSInIncludesText()) {
            return;
        }
        double x = this.theVertices[0].getX() + (double)(130 * charstring.length());
        double y = this.theVertices[0].getY() + 190.0;
        this.theVertices[1].setLocation(x, y);
        Orientation orient = Orientation.fromAngle(angle);
        NodeInst ni = NodeInst.makeInstance(this.layerNodeProto, this.theVertices[0], 0.0, 0.0, this.theCell, orient, charstring, 0);
        if (ni == null) {
            this.handleError("Could not create text marker");
        }
        MutableTextDescriptor td = ni.getMutableTextDescriptor(NodeInst.NODE_NAME_TD);
        int size = (int)scale;
        if (size <= 0) {
            size = 8;
        }
        if (size > 63) {
            size = 63;
        }
        td.setAbsSize(size);
        td.setPos(TextDescriptor.Position.CENT);
        block0 : switch (vjust) {
            case 1: {
                switch (hjust) {
                    case 1: {
                        td.setPos(TextDescriptor.Position.UPRIGHT);
                        break block0;
                    }
                    case 2: {
                        td.setPos(TextDescriptor.Position.UPLEFT);
                        break block0;
                    }
                }
                td.setPos(TextDescriptor.Position.UP);
                break;
            }
            case 2: {
                switch (hjust) {
                    case 1: {
                        td.setPos(TextDescriptor.Position.DOWNRIGHT);
                        break block0;
                    }
                    case 2: {
                        td.setPos(TextDescriptor.Position.DOWNLEFT);
                        break block0;
                    }
                }
                td.setPos(TextDescriptor.Position.DOWN);
                break;
            }
            default: {
                switch (hjust) {
                    case 1: {
                        td.setPos(TextDescriptor.Position.RIGHT);
                        break block0;
                    }
                    case 2: {
                        td.setPos(TextDescriptor.Position.LEFT);
                        break block0;
                    }
                }
                td.setPos(TextDescriptor.Position.CENT);
            }
        }
        ni.setTextDescriptor(NodeInst.NODE_NAME_TD, td);
    }

    private void determineBox() throws IOException {
        NodeInst ni;
        this.getToken();
        this.readUnsupported(unsupportedSet);
        this.determineLayer();
        if (this.theToken != GDS_XY) {
            this.handleError("Boundary has no points");
        }
        this.getToken();
        this.determinePoints(2, 4096);
        if (this.layerUsed && (ni = NodeInst.makeInstance(this.layerNodeProto, this.theVertices[0], 0.0, 0.0, this.theCell)) == null) {
            this.handleError("Failed to create box");
        }
    }

    private void setLayer(int layerNum, int layerType) {
        this.layerUsed = true;
        this.layerIsPin = false;
        Integer layerInt = new Integer(layerNum + (layerType << 16));
        Layer layer = (Layer)this.layerNames.get(layerInt);
        if (layer == null) {
            if (IOTool.isGDSInIgnoresUnknownLayers()) {
                System.out.println("GDS layer " + layerNum + ", type " + layerType + " unknown, ignoring it");
            } else {
                System.out.println("GDS layer " + layerNum + ", type " + layerType + " unknown, using Generic:DRC");
            }
            this.layerNames.put(layerInt, Generic.tech.drc_lay);
            this.layerUsed = false;
            this.layerNodeProto = null;
        } else {
            this.layerNodeProto = layer.getNonPseudoLayer().getPureLayerNode();
            if (layer == Generic.tech.drc_lay && IOTool.isGDSInIgnoresUnknownLayers()) {
                this.layerUsed = false;
            }
            this.pinNodeProto = Generic.tech.universalPinNode;
            if (this.pinLayers.contains(layerInt)) {
                this.layerIsPin = true;
                Iterator it = layer.getTechnology().getArcs();
                while (it.hasNext()) {
                    ArcProto arc = (ArcProto)it.next();
                    PortProto pp = this.layerNodeProto.getPort(0);
                    if (pp == null || !pp.connectsTo(arc)) continue;
                    this.pinNodeProto = arc.findOverridablePinProto();
                    break;
                }
            }
            if (this.layerNodeProto == null) {
                System.out.println("Error: no pure layer node for layer " + layer.getName());
                this.layerNames.put(layerInt, Generic.tech.drc_lay);
                this.layerUsed = false;
            }
        }
    }

    private void determineLayer() throws IOException {
        if (this.theToken != GDS_LAYER) {
            this.handleError("Layer statement is missing");
        }
        this.getToken();
        if (this.theToken != GDS_SHORT_NUMBER) {
            this.handleError("Invalid layer number");
        }
        int layerNum = this.tokenValue16;
        this.getToken();
        if (!this.isMember(this.theToken, maskSet)) {
            this.handleError("No datatype field");
        }
        this.getToken();
        this.setLayer(layerNum, this.tokenValue16);
    }

    private Point determineJustification() throws IOException {
        Point just = new Point();
        this.getToken();
        if (this.theToken != GDS_FLAGSYM) {
            this.handleError("Array reference has no parameters");
        }
        int font_libno = this.tokenFlags & 0x30;
        font_libno >>= 4;
        just.x = this.tokenFlags & 0xC;
        just.x >>= 2;
        just.y = this.tokenFlags & 3;
        this.getToken();
        return just;
    }

    private void determineProperty() throws IOException {
        this.getToken();
        this.getToken();
        if (this.theToken != GDS_PROPVALUE) {
            this.handleError("Property has no value");
        }
        this.getToken();
        String propvalue = this.tokenString;
        this.getToken();
    }

    private void getPrototype(String name) throws IOException {
        Cell np = this.findCell(name);
        if (np == null) {
            np = Cell.newInstance(this.theLibrary, this.tokenString);
            if (np == null) {
                this.handleError("Failed to create SREF proto");
            }
            progress.setNote("Reading " + this.tokenString);
        }
        this.theNodeProto = np;
    }

    private void readGenerations() throws IOException {
        this.getToken();
        if (this.theToken != GDS_SHORT_NUMBER) {
            this.handleError("Generations value is invalid");
        }
        this.getToken();
    }

    private boolean isMember(GSymbol tok, GSymbol[] set) {
        for (int i = 0; i < set.length; ++i) {
            if (set[i] != tok) continue;
            return true;
        }
        return false;
    }

    private void getToken() throws IOException {
        if (this.recordCount == 0) {
            this.valuetype = this.readRecord();
        } else {
            if (this.valuetype == TYPEFLAGS) {
                this.tokenFlags = this.getWord();
                this.theToken = GDS_FLAGSYM;
                return;
            }
            if (this.valuetype == TYPESHORT) {
                this.tokenValue16 = this.getWord();
                this.theToken = GDS_SHORT_NUMBER;
                return;
            }
            if (this.valuetype == TYPELONG) {
                this.tokenValue32 = this.getInteger();
                this.theToken = GDS_NUMBER;
                return;
            }
            if (this.valuetype == TYPEFLOAT) {
                this.tokenValueDouble = this.getFloat();
                this.theToken = GDS_REALNUM;
                return;
            }
            if (this.valuetype == TYPEDOUBLE) {
                this.tokenValueDouble = this.getDouble();
                this.theToken = GDS_REALNUM;
                return;
            }
            if (this.valuetype == TYPESTRING) {
                this.tokenString = this.getString();
                this.theToken = GDS_IDENT;
                return;
            }
            if (this.valuetype == TYPEERR) {
                this.handleError("Invalid GDS II datatype");
            }
        }
    }

    private DatatypeSymbol readRecord() throws IOException {
        int dataword = this.getWord();
        this.recordCount = dataword - 2;
        int recordtype = this.getByte() & 0xFF;
        this.theToken = GSymbol.findSymbol(recordtype);
        DatatypeSymbol datatypeSymbol = TYPEERR;
        switch (this.getByte()) {
            case 0: {
                datatypeSymbol = TYPENONE;
                break;
            }
            case 1: {
                datatypeSymbol = TYPEFLAGS;
                break;
            }
            case 2: {
                datatypeSymbol = TYPESHORT;
                break;
            }
            case 3: {
                datatypeSymbol = TYPELONG;
                break;
            }
            case 4: {
                datatypeSymbol = TYPEFLOAT;
                break;
            }
            case 5: {
                datatypeSymbol = TYPEDOUBLE;
                break;
            }
            case 6: {
                datatypeSymbol = TYPESTRING;
            }
        }
        return datatypeSymbol;
    }

    private void handleError(String msg) throws IOException {
        System.out.println("Error: " + msg + " at byte " + this.byteCount);
        throw new IOException();
    }

    private void readUnsupported(GSymbol[] bad_op_set) throws IOException {
        if (this.isMember(this.theToken, bad_op_set)) {
            do {
                this.getToken();
            } while (!this.isMember(this.theToken, goodOpSet));
        }
    }

    private int determinePoints(int min_points, int max_points) throws IOException {
        int point_counter = 0;
        while (this.theToken == GDS_NUMBER) {
            double x = (double)this.tokenValue32 * this.theScale;
            this.getToken();
            double y = (double)this.tokenValue32 * this.theScale;
            this.theVertices[point_counter].setLocation(x, y);
            if (++point_counter > max_points) {
                System.out.println("Found " + point_counter + " points (too many)");
                this.handleError("Too many points in the shape");
            }
            this.getToken();
        }
        if (point_counter < min_points) {
            System.out.println("Found " + point_counter + " points (too few)");
            this.handleError("Not enough points in the shape");
        }
        return point_counter;
    }

    private String determineTime() throws IOException {
        String[] time_array = new String[7];
        for (int i = 0; i < 6; ++i) {
            if (this.theToken != GDS_SHORT_NUMBER) {
                this.handleError("Date value is not a valid number");
            }
            if (i == 0 && this.tokenValue16 < 1900) {
                this.tokenValue16 = this.tokenValue16 > 60 ? (this.tokenValue16 += 1900) : (this.tokenValue16 += 2000);
            }
            time_array[i] = Integer.toString(this.tokenValue16);
            this.getToken();
        }
        return time_array[1] + "-" + time_array[2] + "-" + time_array[0] + " at " + time_array[3] + ":" + time_array[4] + ":" + time_array[5];
    }

    private float getFloat() throws IOException {
        int reg = this.getByte() & 0xFF;
        int sign = 1;
        if ((reg & 0x80) != 0) {
            sign = -1;
        }
        int binary_exponent = (reg &= 0x7F) - 64 << 2;
        reg = (this.getByte() & 0xFF) << 16;
        int dataword = this.getWord();
        reg += dataword;
        int shift_count = 0;
        while ((reg & 0x800000) == 0) {
            reg <<= 1;
            ++shift_count;
        }
        if ((binary_exponent = binary_exponent - shift_count - 24) > 0) {
            return (float)((double)(sign * reg) * GDS.makePower(2, binary_exponent));
        }
        if (binary_exponent < 0) {
            return (float)((double)(sign * reg) / GDS.makePower(2, -binary_exponent));
        }
        return sign * reg;
    }

    private static double makePower(int val, int power) {
        double result = 1.0;
        for (int count = 0; count < power; ++count) {
            result *= (double)val;
        }
        return result;
    }

    private double getDouble() throws IOException {
        int long_integer;
        int register1 = this.getByte() & 0xFF;
        double realValue = 1.0;
        if ((register1 & 0x80) != 0) {
            realValue = -1.0;
        }
        int exponent = (register1 &= 0x7F) - 64;
        register1 = (this.getByte() & 0xFF) << 16;
        int dataword = this.getWord();
        int register2 = long_integer = this.getInteger();
        if ((register1 += dataword) != 0 || register2 != 0) {
            while ((register1 & 0xF00000) == 0) {
                register1 = (register1 << 4) + (register2 >> 28);
                register2 <<= 4;
                --exponent;
            }
        } else {
            return 0.0;
        }
        realValue *= ((double)register1 * twoTo32 + (double)register2) * twoToNeg56;
        if (exponent > 0) {
            realValue *= GDS.makePower(16, exponent);
        } else if (exponent < 0) {
            realValue /= GDS.makePower(16, -exponent);
        }
        return realValue;
    }

    private String getString() throws IOException {
        StringBuffer sb = new StringBuffer();
        while (this.recordCount != 0) {
            char letter = (char)this.getByte();
            if (letter == '\u0000') continue;
            sb.append(letter);
        }
        return sb.toString();
    }

    private int getInteger() throws IOException {
        int highWord = this.getWord();
        int lowWord = this.getWord();
        return highWord << 16 | lowWord;
    }

    private int getWord() throws IOException {
        int highByte = this.getByte() & 0xFF;
        int lowByte = this.getByte() & 0xFF;
        return highByte << 8 | lowByte;
    }

    private byte getByte() throws IOException {
        byte b = this.dataInputStream.readByte();
        this.updateProgressDialog(1);
        --this.recordCount;
        return b;
    }

    private class ReadOrientation {
        private int angle;
        private boolean trans;
        private double scale;

        private ReadOrientation() {
        }

        private void doIt() throws IOException {
            double anglevalue = 0.0;
            this.scale = 1.0;
            boolean mirror_x = false;
            GDS.this.getToken();
            if (GDS.this.theToken != GDS_FLAGSYM) {
                GDS.this.handleError("Structure reference is missing its flags field");
            }
            if ((GDS.this.tokenFlags & 0x8000) != 0) {
                mirror_x = true;
            }
            GDS.this.getToken();
            if (GDS.this.theToken == GDS_MAG) {
                GDS.this.getToken();
                this.scale = GDS.this.tokenValueDouble;
                GDS.this.getToken();
            }
            if (GDS.this.theToken == GDS_ANGLE) {
                GDS.this.getToken();
                anglevalue = GDS.this.tokenValueDouble * 10.0;
                GDS.this.getToken();
            }
            this.angle = (int)anglevalue % 3600;
            this.trans = mirror_x;
            if (this.trans) {
                this.angle = (2700 - this.angle) % 3600;
            }
            if (this.angle < 0) {
                this.angle += 3600;
            }
        }
    }

    private static class MakeInstance {
        private static HashMap allInstances;
        private Cell parent;
        private Cell subCell;
        private Point2D loc;
        private boolean mX;
        private boolean mY;
        private int angle;
        private boolean instantiated;

        private MakeInstance(Cell parent, Cell subCell, Point2D loc, boolean mX, boolean mY, int angle) {
            this.parent = parent;
            this.subCell = subCell;
            this.loc = loc;
            this.mX = mX;
            this.mY = mY;
            this.angle = angle;
            this.instantiated = false;
            ArrayList<MakeInstance> instancesInCell = (ArrayList<MakeInstance>)allInstances.get(parent);
            if (instancesInCell == null) {
                instancesInCell = new ArrayList<MakeInstance>();
                allInstances.put(parent, instancesInCell);
            }
            instancesInCell.add(this);
        }

        private static void init() {
            allInstances = new HashMap();
        }

        private static void term() {
            allInstances = null;
        }

        private static void makeCellInstances(Cell cell) {
            List instancesInCell = (List)allInstances.get(cell);
            if (instancesInCell == null) {
                return;
            }
            Iterator iIt = instancesInCell.iterator();
            while (iIt.hasNext()) {
                MakeInstance mi = (MakeInstance)iIt.next();
                if (mi.instantiated) continue;
                Cell subCell = mi.subCell;
                MakeInstance.makeCellInstances(subCell);
                Rectangle2D bounds = mi.subCell.getBounds();
                double wid = bounds.getWidth();
                double hei = bounds.getHeight();
                Orientation orient = Orientation.fromJava(mi.angle, mi.mX, mi.mY);
                AffineTransform xform = orient.pureRotate();
                double cX = bounds.getCenterX();
                double cY = bounds.getCenterY();
                Point2D.Double ctr = new Point2D.Double(0.0, 0.0);
                xform.transform(ctr, ctr);
                double oX = ((Point2D)ctr).getX() - cX;
                double oY = ((Point2D)ctr).getY() - cY;
                mi.loc.setLocation(mi.loc.getX() + cX + oX, mi.loc.getY() + cY + oY);
                NodeInst ni = NodeInst.makeInstance(mi.subCell, mi.loc, wid, hei, mi.parent, orient, null, 0);
                if (ni == null) {
                    return;
                }
                if (IOTool.isGDSInExpandsCells()) {
                    ni.setExpanded();
                }
                mi.instantiated = true;
            }
        }

        private static void buildInstances() {
            Iterator it = allInstances.keySet().iterator();
            while (it.hasNext()) {
                Cell cell = (Cell)it.next();
                MakeInstance.makeCellInstances(cell);
            }
        }
    }

    private static class GSymbol {
        private int value;
        private static List symbols = new ArrayList();

        private GSymbol(int value) {
            this.value = value;
            symbols.add(this);
        }

        private static GSymbol findSymbol(int value) {
            Iterator it = symbols.iterator();
            while (it.hasNext()) {
                GSymbol gs = (GSymbol)it.next();
                if (gs.value != value) continue;
                return gs;
            }
            return null;
        }
    }

    private static class DatatypeSymbol {
        private DatatypeSymbol() {
        }
    }

    private static class ShapeType {
        private ShapeType() {
        }
    }
}

