/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.user.User;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class Maxwell
extends Output {
    HashMap maxNetMap;
    HashMap boxNames;
    int boxNumber;

    public static void writeMaxwellFile(Output.OutputCellInfo cellJob) {
        Maxwell out = new Maxwell();
        if (out.openTextOutputStream(cellJob.filePath)) {
            return;
        }
        out.initialize(cellJob.cell);
        Visitor wcVisitor = new Visitor(out);
        HierarchyEnumerator.enumerateCell(cellJob.cell, cellJob.context, null, wcVisitor);
        out.terminate();
        if (out.closeTextOutputStream()) {
            return;
        }
        System.out.println(cellJob.filePath + " written");
    }

    Maxwell() {
    }

    private void initialize(Cell cell) {
        this.maxNetMap = new HashMap();
        this.boxNames = new HashMap();
        this.boxNumber = 1;
        this.printWriter.print("# Maxwell netlist for cell " + cell.noLibDescribe() + " from library " + cell.getLibrary().getName() + "\n");
        if (User.isIncludeDateAndVersionInOutput()) {
            this.printWriter.print("# CELL CREATED ON " + TextUtils.formatDate(cell.getCreationDate()) + "\n");
            this.printWriter.print("# LAST REVISED ON " + TextUtils.formatDate(cell.getRevisionDate()) + "\n");
            this.printWriter.print("# Generated automatically by the Electric VLSI Design System, version " + Version.getVersion() + "\n");
            this.printWriter.print("# WRITTEN ON " + TextUtils.formatDate(new Date()) + "\n");
        } else {
            this.printWriter.print("# Generated automatically by the Electric VLSI Design System\n");
        }
        this.printWriter.print("\n");
        this.emitCopyright("# ", "");
    }

    private void terminate() {
        Iterator it = this.maxNetMap.keySet().iterator();
        while (it.hasNext()) {
            Integer index = (Integer)it.next();
            List boxList = (List)this.maxNetMap.get(index);
            if (boxList.size() <= 1) continue;
            this.printWriter.print("Unite {");
            boolean first = true;
            Iterator lIt = boxList.iterator();
            while (lIt.hasNext()) {
                Integer boxNum = (Integer)lIt.next();
                if (first) {
                    first = false;
                } else {
                    this.printWriter.print(" ");
                }
                String boxName = (String)this.boxNames.get(boxNum);
                this.printWriter.print("\"" + boxName + "\"");
            }
            this.printWriter.print("}\n");
        }
    }

    private void writePolygon(Poly poly, int globalNetNum, Network net) {
        Layer layer = poly.getLayer();
        if (layer.getTechnology() != Technology.getCurrent()) {
            return;
        }
        if ((layer.getFunctionExtras() & 0x1000) != 0) {
            return;
        }
        Rectangle2D box = poly.getBox();
        if (box == null) {
            return;
        }
        Color color = layer.getGraphics().getColor();
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        this.printWriter.print("NewObjColor " + red + " " + green + " " + blue + "\n");
        Integer index = new Integer(globalNetNum);
        ArrayList<Integer> boxList = (ArrayList<Integer>)this.maxNetMap.get(index);
        if (boxList == null) {
            boxList = new ArrayList<Integer>();
            this.maxNetMap.put(index, boxList);
        }
        double scale = layer.getTechnology().getScale();
        double lX = box.getMinX() * scale / 1000.0;
        double lY = box.getMinY() * scale / 1000.0;
        double wid = box.getWidth() * scale / 1000.0;
        double hei = box.getHeight() * scale / 1000.0;
        String netName = net.describe(false) + "-" + this.boxNumber;
        this.printWriter.print("Box pos3 " + lX + " " + lY + " " + layer.getName() + "-Bot   " + wid + " " + hei + " " + layer.getName() + "-Hei \"" + netName + "\"\n");
        Integer boxNum = new Integer(this.boxNumber);
        boxList.add(boxNum);
        this.boxNames.put(boxNum, netName);
        ++this.boxNumber;
    }

    private static class Visitor
    extends HierarchyEnumerator.Visitor {
        Maxwell generator;

        public Visitor(Maxwell generator) {
            this.generator = generator;
        }

        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            Netlist netList = info.getNetlist();
            Iterator it = info.getCell().getNodes();
            while (it.hasNext()) {
                NodeInst ni = (NodeInst)it.next();
                NodeProto np = ni.getProto();
                if (!(np instanceof PrimitiveNode)) continue;
                AffineTransform transRot = ni.rotateOut();
                Technology tech = np.getTechnology();
                Poly[] polyList = tech.getShapeOfNode(ni, null, null, true, false, null);
                int tot = polyList.length;
                for (int i = 0; i < tot; ++i) {
                    Poly poly = polyList[i];
                    if (poly.getPort() == null) continue;
                    poly.transform(transRot);
                    poly.transform(info.getTransformToRoot());
                    PortInst pi = ni.findPortInstFromProto(poly.getPort());
                    Network net = netList.getNetwork(pi);
                    if (net == null) continue;
                    int globalNetNum = info.getNetID(net);
                    this.generator.writePolygon(poly, globalNetNum, net);
                }
            }
            it = info.getCell().getArcs();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                Technology tech = ai.getProto().getTechnology();
                Poly[] polyList = tech.getShapeOfArc(ai);
                int tot = polyList.length;
                for (int i = 0; i < tot; ++i) {
                    Poly poly = polyList[i];
                    poly.transform(info.getTransformToRoot());
                    Network net = netList.getNetwork(ai, 0);
                    int globalNetNum = info.getNetID(net);
                    this.generator.writePolygon(poly, globalNetNum, net);
                }
            }
            return true;
        }

        public void exitCell(HierarchyEnumerator.CellInfo info) {
        }

        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            return true;
        }
    }
}

