/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.TransistorSize;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.extract.ExtractedPBucket;
import com.sun.electric.tool.extract.ParasiticGenerator;
import com.sun.electric.tool.extract.ParasiticTool;
import com.sun.electric.tool.extract.RCPBucket;
import com.sun.electric.tool.extract.TransistorPBucket;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.user.User;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class IRSIM
extends Output
implements ParasiticGenerator {
    private VarContext context = null;
    private List components;
    private Technology technology;

    public static void writeIRSIMFile(Output.OutputCellInfo cellJob) {
        IRSIM out = new IRSIM(cellJob.cell);
        out.writeNetlist(cellJob.cell, cellJob.context, cellJob.filePath);
    }

    public static List getIRSIMComponents(Cell cell, VarContext context) {
        IRSIM out = new IRSIM(cell);
        return out.getNetlist(cell, context);
    }

    private List getNetlist(Cell cell, VarContext context) {
        this.context = context;
        if (context == null) {
            this.context = VarContext.globalContext;
        }
        this.components = ParasiticTool.calculateParasistic(this, cell, context);
        return this.components;
    }

    private void writeNetlist(Cell cell, VarContext context, String filePath) {
        List parasitics = this.getNetlist(cell, context);
        if (this.openTextOutputStream(filePath)) {
            return;
        }
        double scale = this.technology.getScale() / 10.0;
        Technology layoutTech = Schematics.getDefaultSchematicTechnology();
        this.printWriter.println("| units: " + scale + " tech: " + this.technology.getTechName() + " format: SU");
        this.printWriter.println("| IRSIM file for cell " + cell.noLibDescribe() + " from library " + cell.getLibrary().getName());
        this.emitCopyright("| ", "");
        if (User.isIncludeDateAndVersionInOutput()) {
            this.printWriter.println("| Created on " + TextUtils.formatDate(cell.getCreationDate()));
            this.printWriter.println("| Last revised on " + TextUtils.formatDate(cell.getRevisionDate()));
            this.printWriter.println("| Written on " + TextUtils.formatDate(new Date()) + " by Electric VLSI Design System, version " + Version.getVersion());
        } else {
            this.printWriter.println("| Written by Electric VLSI Design System");
        }
        Iterator it = parasitics.iterator();
        while (it.hasNext()) {
            ExtractedPBucket ci = (ExtractedPBucket)it.next();
            String info = ci.getInfo(layoutTech);
            if (info == null || info.equals("")) continue;
            this.printWriter.println(info);
        }
        if (this.closeTextOutputStream()) {
            return;
        }
        System.out.println(filePath + " written");
        ParasiticTool.getParasiticErrorLogger().sortLogs();
        ParasiticTool.getParasiticErrorLogger().termLogging(true);
    }

    private IRSIM(Cell cell) {
        this.technology = cell.getTechnology();
        if (this.technology == Schematics.tech) {
            this.technology = User.getSchematicTechnology();
        }
    }

    public ExtractedPBucket createBucket(NodeInst ni, ParasiticTool.ParasiticCellInfo info) {
        ExtractedPBucket bucket = null;
        Netlist netlist = info.getNetlist();
        int numRemoveParents = this.context.getNumLevels();
        if (ni.isPrimitiveTransistor()) {
            PortInst g = ni.getTransistorGatePort();
            PortInst d = ni.getTransistorDrainPort();
            PortInst s = ni.getTransistorSourcePort();
            if (g == null || d == null || s == null) {
                System.out.println("PortInst for " + ni + " null!");
                return null;
            }
            Network gnet = netlist.getNetwork(g);
            Network dnet = netlist.getNetwork(d);
            Network snet = netlist.getNetwork(s);
            if (gnet == null || dnet == null || snet == null) {
                System.out.println("Warning, ignoring unconnected transistor " + ni + " in cell " + info.getCell());
                return null;
            }
            TransistorSize dim = ni.getTransistorSize(info.getContext());
            if (dim == null || dim.getDoubleLength() == 0.0 || dim.getDoubleWidth() == 0.0) {
                System.out.println("Warning, ignoring non fet transistor " + ni + " in cell " + info.getCell());
                return null;
            }
            String gName = info.getUniqueNetNameProxy(gnet, "/").toString(numRemoveParents);
            String sName = info.getUniqueNetNameProxy(snet, "/").toString(numRemoveParents);
            String dName = info.getUniqueNetNameProxy(dnet, "/").toString(numRemoveParents);
            bucket = new TransistorPBucket(ni, dim, gName, sName, dName, info.getMFactor());
        } else {
            PrimitiveNode.Function fun = ni.getFunction();
            double rcValue = 0.0;
            int type = 0;
            Network net1 = null;
            Network net2 = null;
            String net1Name = null;
            String net2Name = null;
            Technology tech = info.getCell().getTechnology();
            if (fun == PrimitiveNode.Function.CONTACT) {
                Iterator it = ni.getConnections();
                while (it.hasNext()) {
                    Connection c = (Connection)it.next();
                    Network net = netlist.getNetwork(c.getArc(), 0);
                    if (net1 == null) {
                        net1 = net;
                        net1Name = info.getUniqueNetNameProxy(net1, "/").toString(numRemoveParents) + "_" + c.getArc().getName();
                        continue;
                    }
                    if (net2 == null) {
                        net2 = net;
                        net2Name = info.getUniqueNetNameProxy(net2, "/").toString(numRemoveParents) + "_" + c.getArc().getName();
                        continue;
                    }
                    System.out.println("Warning: contact " + ni.describe(true) + " has more than 2 connections, RC estimation may be wrong");
                }
                PrimitiveNode pn = (PrimitiveNode)ni.getProto();
                Technology.MultiCutData mcd = new Technology.MultiCutData(ni, pn.getSpecialValues());
                int cuts = mcd.numCuts();
                Technology.NodeLayer[] layers = pn.getLayers();
                Layer thisLayer = null;
                for (int i = 0; i < layers.length; ++i) {
                    if (!layers[i].getLayer().getFunction().isContact()) continue;
                    thisLayer = layers[i].getLayer();
                    break;
                }
                if (thisLayer != null) {
                    rcValue = thisLayer.getResistance() / (double)cuts;
                }
                type = 114;
                if (rcValue < tech.getMinResistance()) {
                    return null;
                }
            } else if (fun == PrimitiveNode.Function.RESIST || fun == PrimitiveNode.Function.CAPAC || fun == PrimitiveNode.Function.ECAPAC) {
                PortInst end1 = ni.getPortInst(0);
                PortInst end2 = ni.getPortInst(1);
                if (end1 == null || end2 == null) {
                    System.out.println("PortInst for " + ni + " null!");
                    return null;
                }
                net1 = netlist.getNetwork(end1);
                net2 = netlist.getNetwork(end2);
                if (net1 == null || net2 == null) {
                    System.out.println("Warning, ignoring unconnected component " + ni + " in cell " + info.getCell());
                    return null;
                }
                net1Name = info.getUniqueNetNameProxy(net1, "/").toString(numRemoveParents);
                net2Name = info.getUniqueNetNameProxy(net2, "/").toString(numRemoveParents);
                Variable.Key varKey = Schematics.SCHEM_CAPACITANCE;
                TextDescriptor.Unit unit = TextDescriptor.Unit.CAPACITANCE;
                if (fun == PrimitiveNode.Function.RESIST) {
                    varKey = Schematics.SCHEM_RESISTANCE;
                    unit = TextDescriptor.Unit.RESISTANCE;
                }
                Variable valueVar = ni.getVar(varKey);
                String extra = "";
                if (valueVar != null && TextUtils.isANumber(extra = valueVar.describe(info.getContext(), ni))) {
                    double pureValue = TextUtils.atof(extra);
                    extra = TextUtils.formatDoublePostFix(pureValue);
                }
                rcValue = TextUtils.parsePostFixNumber(extra).doubleValue();
                if (fun == PrimitiveNode.Function.RESIST) {
                    type = 114;
                } else {
                    type = 67;
                    rcValue = Math.rint(rcValue / 1.0E-15 * 1000.0) / 1000.0;
                }
            }
            if (type == 0) {
                return null;
            }
            if (type == 67 && rcValue < tech.getMinCapacitance()) {
                return null;
            }
            bucket = new RCPBucket((char)type, net1Name, net2Name, rcValue);
        }
        return bucket;
    }
}

