/*
 * Electric(tm) VLSI Design System
 *
 * File: sc1err.c
 * Contains error messages for the Silicon Compiler aid
 * Written by: Andrew R. Kostiuk, Queen's University
 *
 * Copyright (c) 2000 Static Free Software.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Static Free Software
 * 4119 Alpine Road
 * Portola Valley, California 94028
 * info@staticfreesoft.com
 */

#include "config.h"
#include "global.h"
#if SCAID

char *sc_errmsg;

char *sc_standard_errmsg[] =
{
	"",
	N_("Unknown command '%s'"),
	N_("No keyword for CREATE command"),
	N_("No name for CREATE CELL command"),
	N_("Cell '%s' already exists in current library"),
	N_("Cannot create cell '%s'"),
	N_("Unknown CREATE command '%s'"),
	N_("No keyword for LIBRARY command"),
	N_("Unknown LIBRARY command '%s'"),
	N_("No name for LIBRARY USE command"),
	N_("Library '%s' not selected"),
	N_("No name for LIBRARY READ command"),
	N_("Cannot create library '%s'"),
	N_("No memory"),
	N_("Cannot set library style"),
	N_("Cannot read library '%s'"),
	N_("No instance name for CREATE INSTANCE command"),
	N_("No type name for CREATE INSTANCE command"),
	N_("Library '%s' not found"),
	N_("There is no '%s' in the standard cell library"),
	N_("No cell selected"),
	N_("Cannot create instance '%s'"),
	N_("Cannot set instance name '%s'"),
	N_("Instance '%s' already exists"),
	N_("No SHOW option selected"),
	N_("Invalid option '%s' for SHOW command"),
	N_("No cell name for SHOW PORTS command"),
	N_("Cannot find cell '%s'"),
	N_("Not enough parameters for CONNECT command"),
	N_("Cannot find port '%s' on instance '%s'"),
	N_("Cannot find universal arc"),
	N_("Cannot make arc"),
	N_("No file name for COMPILE command"),
	N_("Cannot open file '%s' for COMPILE command"),
	N_("Error creating connection list for '%s' to '%s'"),
	N_("Error moving instance"),
	N_("Error with edge routines"),
	N_("No option for SIMULATION command"),
	N_("Incorrect option '%s' for SIMULATION command"),
	N_("No cell name specified for SIMULATION SET command"),
	N_("Error setting simulation variable"),
	N_("No cell name specified for SIMULATION SHOW command"),
	N_("No simulation variable for cell '%s'"),
	N_("Cannot create sc_nitree variable"),
	N_("Not enough parameters for SIMULATION WRITE command"),
	N_("Error opening output simulation file '%s'"),
	N_("Cannot find sc_sim variable for cell '%s'"),
	N_("No option for SET command"),
	N_("Unknown option '%s' for SET command"),
	N_("Cannot find cell '%s'"),
	N_("Cannot find port '%s' on cell '%s'"),
	N_("Unknown port direction specifier '%s'"),
	N_("No instance specified for EXPORT command"),
	N_("Cannot find instance '%s' for EXPORT command"),
	N_("No port specified for EXPORT command"),
	N_("Cannot find port '%s' on instance '%s' for EXPORT command"),
	N_("Unknown port type '%s' for EXPORT command"),
	N_("No export name specified for EXPORT command"),
	N_("Export name '%s' is not unique"),
	N_("File error with SIM SET temp file"),
	N_("Error status from VHDL Compiler for file '%s'"),
	N_("Cannot find instance '%s'"),
	N_("No leaf cell specified for ORDER command"),
	N_("No options specified for the SELECT command"),
	N_("No cell name specified for the SELECT CELL command"),
	N_("Invalid SELECT option '%s'"),
	N_("Error opening file '%s' for SET OUTPUT-DEVICE command"),
	N_("No connections found to allow PLACEing"),
	N_("Unknown command option '%s' for PLACE command"),
	N_("No command for PLACE SET-CONTROL command"),
	N_("Unknown command option '%s' for PLACE SET-CONTROL command"),
	N_("No PLACEMENT structure for cell '%s'"),
	N_("Unknown command option '%s' for ROUTE command"),
	N_("Unknown command option '%s' for ROUTE SET-CONTROL command"),
	N_("No command specified for ROUTE SET-CONTROL command"),
	N_("No ROUTE structure for cell '%s'"),
	N_("Unknown command option '%s' for MAKE command"),
	N_("No command for MAKE SET-CONTROL command"),
	N_("Unknown command option '%s' for MAKE SET-CONTROL command"),
	N_("Cannot create leaf cell '%s' in MAKER"),
	N_("Cannot create leaf instance '%s' in MAKER"),
	N_("Cannot create leaf feed in MAKER"),
	N_("Cannot create via in MAKER"),
	N_("Cannot create layer2 track in MAKER"),
	N_("Cannot create layer1 track in MAKER"),
	N_("Cannot create export port '%s' in MAKER"),
	N_("Cannot set cell numbers structure"),
	N_("Unknown option '%s' for SET LEAF-CELL-NUMBERS command"),
	N_("Unable to get LAYER1-NODE for MAKER"),
	N_("Unable to get LAYER2-NODE for MAKER"),
	N_("Unable to get VIA for MAKER"),
	N_("Unable to get LAYER1-ARC for MAKER"),
	N_("Unable to get LAYER2-ARC for MAKER"),
	N_("Unable to get LAYER P-WELL for MAKER"),
	N_("Unable to create P-WELL in MAKER"),
	N_("No ALS program specified for system"),
	N_("No VHDL Compiler program specified for system"),
	N_("Error openning file '%s' in ORDER command"),
	N_("No cells to check in VERIFY command"),
	N_("Insufficent parameters for SET NODE-NAME command"),
	N_("Cannot find instance '%s' in SET NODE-NAME command"),
	N_("Cannot find port '%s' on instance '%s' in SET NODE-NAME command"),
	N_("Cannot find extracted node to set name in SET NODE-NAME command"),
	0
};

#endif  /* SCAID - at top */
