;; Hashtable for Diatonic Shift. Only the "white keys" are needed.
(define DiatonicDownwardHashtable (make-hash-table 65))

(let createDiatonicDownwardHashtable ()
	(hashq-set! DiatonicDownwardHashtable 'c''''' "b''''")
	
	(hashq-set! DiatonicDownwardHashtable 'c'''' "b'''")
	(hashq-set! DiatonicDownwardHashtable 'd'''' "c''''")
	(hashq-set! DiatonicDownwardHashtable 'e'''' "d''''")
	(hashq-set! DiatonicDownwardHashtable 'f'''' "e''''")
	(hashq-set! DiatonicDownwardHashtable 'g'''' "f''''")	
	(hashq-set! DiatonicDownwardHashtable 'a'''' "g''''")
	(hashq-set! DiatonicDownwardHashtable 'b'''' "a''''")
	
	(hashq-set! DiatonicDownwardHashtable 'c''' "b''")
	(hashq-set! DiatonicDownwardHashtable 'd''' "c'''")
	(hashq-set! DiatonicDownwardHashtable 'e''' "d'''")
	(hashq-set! DiatonicDownwardHashtable 'f''' "e'''")
	(hashq-set! DiatonicDownwardHashtable 'g''' "f'''")	
	(hashq-set! DiatonicDownwardHashtable 'a''' "g'''")
	(hashq-set! DiatonicDownwardHashtable 'b''' "a'''")

	(hashq-set! DiatonicDownwardHashtable 'c'' "b'")
	(hashq-set! DiatonicDownwardHashtable 'd'' "c''")
	(hashq-set! DiatonicDownwardHashtable 'e'' "d''")
	(hashq-set! DiatonicDownwardHashtable 'f'' "e''")
	(hashq-set! DiatonicDownwardHashtable 'g'' "f''")	
	(hashq-set! DiatonicDownwardHashtable 'a'' "g''")
	(hashq-set! DiatonicDownwardHashtable 'b'' "a''")

	(hashq-set! DiatonicDownwardHashtable 'c' "b")
	(hashq-set! DiatonicDownwardHashtable 'd' "c'")
	(hashq-set! DiatonicDownwardHashtable 'e' "d'")
	(hashq-set! DiatonicDownwardHashtable 'f' "e'")
	(hashq-set! DiatonicDownwardHashtable 'g' "f'")	
	(hashq-set! DiatonicDownwardHashtable 'a' "g'")
	(hashq-set! DiatonicDownwardHashtable 'b' "a'")

	(hashq-set! DiatonicDownwardHashtable 'c "b,")
	(hashq-set! DiatonicDownwardHashtable 'd "c")
	(hashq-set! DiatonicDownwardHashtable 'e "d")
	(hashq-set! DiatonicDownwardHashtable 'f "e")
	(hashq-set! DiatonicDownwardHashtable 'g "f")	
	(hashq-set! DiatonicDownwardHashtable 'a "g")
	(hashq-set! DiatonicDownwardHashtable 'b "a")
	
	(hashq-set! DiatonicDownwardHashtable 'c, "b,,")
	(hashq-set! DiatonicDownwardHashtable 'd, "c,")
	(hashq-set! DiatonicDownwardHashtable 'e, "d,")
	(hashq-set! DiatonicDownwardHashtable 'f, "e,")
	(hashq-set! DiatonicDownwardHashtable 'g, "f,")	
	(hashq-set! DiatonicDownwardHashtable 'a, "g,")
	(hashq-set! DiatonicDownwardHashtable 'b, "a,")
	
	(hashq-set! DiatonicDownwardHashtable 'c,, "b,,,")
	(hashq-set! DiatonicDownwardHashtable 'd,, "c,,")
	(hashq-set! DiatonicDownwardHashtable 'e,, "d,,")
	(hashq-set! DiatonicDownwardHashtable 'f,, "e,,")
	(hashq-set! DiatonicDownwardHashtable 'g,, "f,,")	
	(hashq-set! DiatonicDownwardHashtable 'a,, "g,,")
	(hashq-set! DiatonicDownwardHashtable 'b,, "a,,")
	
	(hashq-set! DiatonicDownwardHashtable 'c,,, "b,,,,")
	(hashq-set! DiatonicDownwardHashtable 'd,,, "c,,,")
	(hashq-set! DiatonicDownwardHashtable 'e,,, "d,,,")
	(hashq-set! DiatonicDownwardHashtable 'f,,, "e,,,")
	(hashq-set! DiatonicDownwardHashtable 'g,,, "f,,,")	
	(hashq-set! DiatonicDownwardHashtable 'a,,, "g,,,")
	(hashq-set! DiatonicDownwardHashtable 'b,,, "a,,,")
	
	(hashq-set! DiatonicDownwardHashtable 'c,,,, "b,,,,,")
	(hashq-set! DiatonicDownwardHashtable 'd,,,, "c,,,,")
	(hashq-set! DiatonicDownwardHashtable 'e,,,, "d,,,,")
	(hashq-set! DiatonicDownwardHashtable 'f,,,, "e,,,,")
	(hashq-set! DiatonicDownwardHashtable 'g,,,, "f,,,,")	
	(hashq-set! DiatonicDownwardHashtable 'a,,,, "g,,,,")
	(hashq-set! DiatonicDownwardHashtable 'b,,,, "a,,,,")

)

(define DiatonicUpwardHashtable (make-hash-table 65))

(let createDiatonicUpnwardHashtable ()
	(hashq-set! DiatonicUpwardHashtable 'b,,,,, "c,,,,")

	(hashq-set! DiatonicUpwardHashtable 'c,,,, "d,,,,")
	(hashq-set! DiatonicUpwardHashtable 'd,,,, "e,,,,")
	(hashq-set! DiatonicUpwardHashtable 'e,,,, "f,,,,")
	(hashq-set! DiatonicUpwardHashtable 'f,,,, "g,,,,")
	(hashq-set! DiatonicUpwardHashtable 'g,,,, "a,,,,")
	(hashq-set! DiatonicUpwardHashtable 'a,,,, "b,,,,")
	(hashq-set! DiatonicUpwardHashtable 'b,,,, "c,,,")

	(hashq-set! DiatonicUpwardHashtable 'c,,, "d,,,")
	(hashq-set! DiatonicUpwardHashtable 'd,,, "e,,,")
	(hashq-set! DiatonicUpwardHashtable 'e,,, "f,,,")
	(hashq-set! DiatonicUpwardHashtable 'f,,, "g,,,")
	(hashq-set! DiatonicUpwardHashtable 'g,,, "a,,,")
	(hashq-set! DiatonicUpwardHashtable 'a,,, "b,,,")
	(hashq-set! DiatonicUpwardHashtable 'b,,, "c,,")

	(hashq-set! DiatonicUpwardHashtable 'c,, "d,,")
	(hashq-set! DiatonicUpwardHashtable 'd,, "e,,")
	(hashq-set! DiatonicUpwardHashtable 'e,, "f,,")
	(hashq-set! DiatonicUpwardHashtable 'f,, "g,,")
	(hashq-set! DiatonicUpwardHashtable 'g,, "a,,")
	(hashq-set! DiatonicUpwardHashtable 'a,, "b,,")
	(hashq-set! DiatonicUpwardHashtable 'b,, "c,")

	(hashq-set! DiatonicUpwardHashtable 'c, "d,")
	(hashq-set! DiatonicUpwardHashtable 'd, "e,")
	(hashq-set! DiatonicUpwardHashtable 'e, "f,")
	(hashq-set! DiatonicUpwardHashtable 'f, "g,")
	(hashq-set! DiatonicUpwardHashtable 'g, "a,")
	(hashq-set! DiatonicUpwardHashtable 'a, "b,")
	(hashq-set! DiatonicUpwardHashtable 'b, "c")

	(hashq-set! DiatonicUpwardHashtable 'c "d")
	(hashq-set! DiatonicUpwardHashtable 'd "e")
	(hashq-set! DiatonicUpwardHashtable 'e "f")
	(hashq-set! DiatonicUpwardHashtable 'f "g")
	(hashq-set! DiatonicUpwardHashtable 'g "a")
	(hashq-set! DiatonicUpwardHashtable 'a "b")
	(hashq-set! DiatonicUpwardHashtable 'b "c'")
	
	(hashq-set! DiatonicUpwardHashtable 'c' "d'")
	(hashq-set! DiatonicUpwardHashtable 'd' "e'")
	(hashq-set! DiatonicUpwardHashtable 'e' "f'")
	(hashq-set! DiatonicUpwardHashtable 'f' "g'")
	(hashq-set! DiatonicUpwardHashtable 'g' "a'")
	(hashq-set! DiatonicUpwardHashtable 'a' "b'")
	(hashq-set! DiatonicUpwardHashtable 'b' "c''")
	
	(hashq-set! DiatonicUpwardHashtable 'c'' "d''")
	(hashq-set! DiatonicUpwardHashtable 'd'' "e''")
	(hashq-set! DiatonicUpwardHashtable 'e'' "f''")
	(hashq-set! DiatonicUpwardHashtable 'f'' "g''")
	(hashq-set! DiatonicUpwardHashtable 'g'' "a''")
	(hashq-set! DiatonicUpwardHashtable 'a'' "b''")
	(hashq-set! DiatonicUpwardHashtable 'b'' "c'''")
	
	(hashq-set! DiatonicUpwardHashtable 'c''' "d'''")
	(hashq-set! DiatonicUpwardHashtable 'd''' "e'''")
	(hashq-set! DiatonicUpwardHashtable 'e''' "f'''")
	(hashq-set! DiatonicUpwardHashtable 'f''' "g'''")
	(hashq-set! DiatonicUpwardHashtable 'g''' "a'''")
	(hashq-set! DiatonicUpwardHashtable 'a''' "b'''")
	(hashq-set! DiatonicUpwardHashtable 'b''' "c''''")

	(hashq-set! DiatonicUpwardHashtable 'c'''' "d''''")
	(hashq-set! DiatonicUpwardHashtable 'd'''' "e''''")
	(hashq-set! DiatonicUpwardHashtable 'e'''' "f''''")
	(hashq-set! DiatonicUpwardHashtable 'f'''' "g''''")
	(hashq-set! DiatonicUpwardHashtable 'g'''' "a''''")
	(hashq-set! DiatonicUpwardHashtable 'a'''' "b''''")
	(hashq-set! DiatonicUpwardHashtable 'b'''' "c'''''")
)
