
; "clio"

; "ol-defs"

; "utility"
(in-package "CLIO-OPEN")

(export '(
	  contact-current-background
	  contact-current-background-pixel

	  inch-pixels
	  millimeter-pixels
	  pixel-inches
	  pixel-millimeters
	  pixel-points
	  point-pixels
	  ))

; "core-mixins"

(export '(
	  switch
	  
	  *default-contact-border*
	  *default-contact-foreground*
	  
	  core
	  core-shell
	  contact-foreground
	  contact-border
	  contact-scale
	  rescale

	  *default-display-horizontal-space*
	  *default-display-vertical-space* 
	  display-horizontal-space
	  display-vertical-space
	  )
	'clio-open)

; "gravity"

(export '(
	  gravity
	  *default-display-bottom-margin*
	  *default-display-left-margin*
	  *default-display-right-margin*
	  *default-display-top-margin*	  
	  
	  display-bottom-margin
	  display-gravity
	  display-left-margin
	  display-right-margin
	  display-top-margin
	  )
	'clio-open)

; "buffer"
(export '(
	  buffer
	  buffer-insert
	  buffer-delete
	  buffer-subseq
	  buffer-length
	  buffer-number-lines

	  mark
	  move-mark
	  )
	'clio-open)

; "text-command"

(export '(
	  text-command-table
	  text-command
	  make-text-command-table
	  )
	'clio-open)

; "display-text"

(export '(
	  *default-display-text-font*
	  display-text
	  display-text-alignment
	  display-text-copy
	  display-text-field
	  display-text-font
	  display-text-selection 
	  display-text-source
	  edit-text-mark
	  edit-text-point
	  make-display-text
	  make-display-text-field
	  )
	'clio-open)

; "ol-images"

; "buttons"

(EXPORT '(
	  action-button
	  button-font
	  button-label
	  button-label-alignment
	  button-switch
	  choice-item-highlight-default-p
	  choice-item-font
	  choice-item-highlight-selected-p
	  choice-item-label
	  choice-item-selected-p
	  make-action-button
	  make-action-item
	  make-toggle-button
	  action-item
	  toggle-button
	  )
	'clio-open)

; "confirm"

(export '(
	  confirm
	  confirm-accept-label
	  confirm-accept-only
	  confirm-cancel-label
	  confirm-message
	  confirm-near
	  confirm-p
	  make-confirm
	  ))

; "scroller"

(export '(
	  make-scroller
	  scale-increment
	  scale-indicator-size
	  scale-maximum
	  scale-minimum
	  scale-orientation
	  scale-update
	  scale-update-delay
	  scale-value
	  scroller
	  )
	'clio-open)

; "table"

(export '(
	  table
	  make-table
	  table-column-alignment
	  table-column-width
	  table-columns
	  table-delete-policy
	  table-layout-size-policy
	  table-member
	  table-row-alignment
	  table-row-height
	  table-same-height-in-row
	  table-same-width-in-column
	  table-separator
	  table-row
	  table-column
	  )
	'clio-open)

; "choices"

(EXPORT '(
	  choices
	  choice-default
	  choice-font
	  choice-policy
	  choice-selection
	  make-choices
	  ))

; "form"

(export '(
	  form
	  make-form
	  make-horizontal-link
	  make-vertical-link
	  form-max-height
	  form-max-width
	  form-min-height
	  form-min-width
	  link-from
	  link-to
	  link-orientation
	  link-attach-from
	  link-attach-to
	  link-length
	  link-maximum
	  link-minimum
	  link-update
	  find-link
	  )
	'clio-open)

; "menu"

(export '(
	  make-menu
	  menu
	  menu-choice
	  menu-title
	  )
	'clio-open)

; "psheet"

(export '(make-property-sheet
	  property-sheet
	  property-sheet-area
 
	  dialog-accept
	  dialog-cancel
	  ))

; "command"

(export '(make-command
	  command
	  command-area
	  command-control-area
	  command-default-accept
	  command-default-cancel
	  dialog-default-control 
	  ))

; "edit-text"

(export '(
	  edit-text
	  edit-text-clear
	  edit-text-cut
	  edit-text-field
	  edit-text-grow
	  edit-text-field-length
	  edit-text-paste

	  make-edit-text
	  make-edit-text-field
	  )
	'clio-open)

; "slider"

(export '(
	  make-slider
	  slider
	  )
	'clio-open)

; "scroll-frame"

(export '(scroll-frame
	  make-scroll-frame
	  scroll-frame-area
	  scroll-frame-content
	  scroll-frame-horizontal
	  scroll-frame-left
	  scroll-frame-position
	  scroll-frame-reposition
	  scroll-frame-top
	  scroll-frame-vertical
	  ))

; "mchoices"

(EXPORT '(
	  choice-default
	  choice-font
	  choice-selection
	  make-multiple-choices
	  multiple-choices
	  ))

; "dlog-button"

(export '(
	  dialog-button
	  dialog-item
	  make-dialog-item
	  make-dialog-button
	  button-dialog
	  present-dialog			; As good a place as any.
	  )
	'clio-open)

; "display-imag"

(export '(
	  make-display-image
	  display-image
	  display-image-source
	  )
	'clio-open)
