/* LocaleInformation_th.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_th extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "THB";

  private static final String currenciesDisplayNameValues = "\u0e1a\u0e32\u0e17";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "THB";

  private static final String currenciesSymbolValues = "\u0e3f";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "\u0e21.\u0e04.",
    "\u0e01.\u0e1e.",
    "\u0e21\u0e35.\u0e04.",
    "\u0e40\u0e21.\u0e22.",
    "\u0e1e.\u0e04.",
    "\u0e21\u0e34.\u0e22.",
    "\u0e01.\u0e04.",
    "\u0e2a.\u0e04.",
    "\u0e01.\u0e22.",
    "\u0e15.\u0e04.",
    "\u0e1e.\u0e22.",
    "\u0e18.\u0e04.",
    null,
  };

  private static final String[] months = {
    "\u0e21\u0e01\u0e23\u0e32\u0e04\u0e21",
    "\u0e01\u0e38\u0e21\u0e20\u0e32\u0e1e\u0e31\u0e19\u0e18\u0e4c",
    "\u0e21\u0e35\u0e19\u0e32\u0e04\u0e21",
    "\u0e40\u0e21\u0e29\u0e32\u0e22\u0e19",
    "\u0e1e\u0e24\u0e29\u0e20\u0e32\u0e04\u0e21",
    "\u0e21\u0e34\u0e16\u0e38\u0e19\u0e32\u0e22\u0e19",
    "\u0e01\u0e23\u0e01\u0e0e\u0e32\u0e04\u0e21",
    "\u0e2a\u0e34\u0e07\u0e2b\u0e32\u0e04\u0e21",
    "\u0e01\u0e31\u0e19\u0e22\u0e32\u0e22\u0e19",
    "\u0e15\u0e38\u0e25\u0e32\u0e04\u0e21",
    "\u0e1e\u0e24\u0e28\u0e08\u0e34\u0e01\u0e32\u0e22\u0e19",
    "\u0e18\u0e31\u0e19\u0e27\u0e32\u0e04\u0e21",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "\u0e2d\u0e32.",
    "\u0e08.",
    "\u0e2d.",
    "\u0e1e.",
    "\u0e1e\u0e24.",
    "\u0e28.",
    "\u0e2a.",
  };

  private static final String[] weekdays = {
    null,
    "\u0e27\u0e31\u0e19\u0e2d\u0e32\u0e17\u0e34\u0e15\u0e22\u0e4c",
    "\u0e27\u0e31\u0e19\u0e08\u0e31\u0e19\u0e17\u0e23\u0e4c",
    "\u0e27\u0e31\u0e19\u0e2d\u0e31\u0e07\u0e04\u0e32\u0e23",
    "\u0e27\u0e31\u0e19\u0e1e\u0e38\u0e18",
    "\u0e27\u0e31\u0e19\u0e1e\u0e24\u0e2b\u0e31\u0e2a\u0e1a\u0e14\u0e35",
    "\u0e27\u0e31\u0e19\u0e28\u0e38\u0e01\u0e23\u0e4c",
    "\u0e27\u0e31\u0e19\u0e40\u0e2a\u0e32\u0e23\u0e4c",
  };

  private static final String[] eras = {
    "\u0e1b\u0e35\u0e01\u0e48\u0e2d\u0e19\u0e04\u0e23\u0e34\u0e2a\u0e15\u0e4c\u0e01\u0e32\u0e25\u0e17\u0e35\u0e48",
    "\u0e04.\u0e28.",
  };

  private static final String[] ampms = {
    "\u0e01\u0e48\u0e2d\u0e19\u0e40\u0e17\u0e35\u0e48\u0e22\u0e07",
    "\u0e2b\u0e25\u0e31\u0e07\u0e40\u0e17\u0e35\u0e48\u0e22\u0e07",
  };

  private static final String territoriesKeys = "TL|TK|TJ|TH|TG|TF|GY|TD|GW|GT|GR|GQ|GP|SZ|SY|GN|GM|GL|SV|GH|SR|GF|SP|GE|SO|GD|SN|SM|SL|GA|SK|SI|SG|SE|SD|SC|SB|FR|FM|RW|FK|RU|FJ|FI|RO|ET|ES|ER|EH|EG|EE|EC|DZ|QA|DO|PY|DM|DK|DJ|PT|PR|DE|PL|PK|PH|PG|PF|CZ|PE|CY|CV|PA|CU|CR|CO|CN|CM|CL|CI|CH|CG|CF|OM|CA|BZ|BY|BW|BT|BS|BR|NZ|BO|BN|BM|NU|BJ|BI|BH|BG|BF|NP|BE|NO|BD|BB|ZW|NL|BA|NI|NG|AZ|NE|NC|AW|ZM|AU|NA|AT|AR|AQ|MZ|AO|MY|AN|MX|AM|MW|AL|ZA|MU|MT|AI|MS|MR|AG|MQ|AF|AE|MO|AD|MN|MM|ML|MK|YU|YT|MG|MD|MC|MA|YE|LY|LV|LU|LT|LS|LR|LK|LI|LB|LA|KZ|KY|KW|KR|KP|KM|KI|WS|KH|KG|KE|JP|JO|JM|VU|VN|VI|VG|VE|VC|IT|IS|IR|IQ|UZ|UY|IN|IL|US|IE|ID|UG|UA|HU|HT|HR|TZ|HN|TW|HK|TT|TR|TO|TN|TM";

  private static final String territoriesValues = "\u0e15\u0e34\u0e21\u0e2d\u0e23\u0e4c\u0e15\u0e30\u0e27\u0e31\u0e19\u0e2d\u0e2d\u0e01|\u0e42\u0e17\u0e01\u0e34\u0e42\u0e25|\u0e17\u0e32\u0e08\u0e34\u0e01\u0e34\u0e2a\u0e16\u0e32\u0e19|\u0e1b\u0e23\u0e30\u0e40\u0e17\u0e28\u0e44\u0e17\u0e22|\u0e42\u0e15\u0e42\u0e01|\u0e2d\u0e32\u0e13\u0e32\u0e40\u0e02\u0e15\u0e17\u0e32\u0e07\u0e43\u0e15\u0e49\u0e02\u0e2d\u0e07\u0e1d\u0e23\u0e31\u0e48\u0e07\u0e40\u0e28\u0e2a|\u0e01\u0e32\u0e22\u0e32\u0e19\u0e32|\u0e0a\u0e32\u0e14|\u0e01\u0e34\u0e19\u0e35-\u0e1a\u0e34\u0e2a\u0e40\u0e0b\u0e32|\u0e01\u0e31\u0e27\u0e40\u0e15\u0e21\u0e32\u0e25\u0e32|\u0e01\u0e23\u0e35\u0e0b|\u0e2d\u0e34\u0e40\u0e04\u0e27\u0e17\u0e2d\u0e40\u0e23\u0e35\u0e22\u0e25\u0e01\u0e34\u0e19\u0e35|\u0e01\u0e31\u0e27\u0e40\u0e14\u0e2d\u0e25\u0e39\u0e1b|\u0e2a\u0e27\u0e32\u0e0b\u0e34\u0e41\u0e25\u0e19\u0e14\u0e4c|\u0e0b\u0e35\u0e40\u0e23\u0e35\u0e22|\u0e01\u0e34\u0e19\u0e35|\u0e41\u0e01\u0e21\u0e40\u0e1a\u0e35\u0e22|\u0e01\u0e23\u0e35\u0e19\u0e41\u0e25\u0e19\u0e14\u0e4c|\u0e40\u0e2d\u0e25\u0e0b\u0e31\u0e25\u0e27\u0e32\u0e14\u0e2d\u0e23\u0e4c|\u0e01\u0e32\u0e19\u0e48\u0e32|\u0e2a\u0e38\u0e23\u0e34\u0e19\u0e31\u0e21|\u0e40\u0e1f\u0e23\u0e19\u0e0a\u0e4c\u0e01\u0e35\u0e2d\u0e32\u0e19\u0e32|\u0e40\u0e0b\u0e2d\u0e23\u0e4c\u0e40\u0e1a\u0e35\u0e22|\u0e08\u0e2d\u0e23\u0e4c\u0e40\u0e08\u0e35\u0e22|\u0e42\u0e0b\u0e21\u0e32\u0e40\u0e25\u0e35\u0e22|\u0e40\u0e01\u0e23\u0e19\u0e32\u0e14\u0e32|\u0e40\u0e0b\u0e40\u0e19\u0e01\u0e31\u0e25|\u0e0b\u0e32\u0e19\u0e21\u0e32\u0e23\u0e35\u0e42\u0e19|\u0e40\u0e0b\u0e35\u0e22\u0e23\u0e4c\u0e23\u0e32\u0e25\u0e35\u0e42\u0e2d\u0e19|\u0e01\u0e32\u0e1a\u0e2d\u0e07|\u0e2a\u0e42\u0e25\u0e27\u0e32\u0e40\u0e01\u0e35\u0e22|\u0e2a\u0e42\u0e25\u0e27\u0e35\u0e40\u0e19\u0e35\u0e22|\u0e2a\u0e34\u0e07\u0e04\u0e42\u0e1b\u0e23\u0e4c|\u0e2a\u0e27\u0e35\u0e40\u0e14\u0e19|\u0e0b\u0e39\u0e14\u0e32\u0e19|\u0e40\u0e0b\u0e40\u0e0a\u0e25\u0e2a\u0e4c|\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e42\u0e0b\u0e42\u0e25\u0e21\u0e2d\u0e19|\u0e1d\u0e23\u0e31\u0e48\u0e07\u0e40\u0e28\u0e2a|\u0e44\u0e21\u0e42\u0e04\u0e23\u0e19\u0e35\u0e40\u0e0b\u0e35\u0e22|\u0e23\u0e27\u0e31\u0e19\u0e14\u0e32|\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e1f\u0e2d\u0e25\u0e4c\u0e04\u0e41\u0e25\u0e19\u0e14\u0e4c|\u0e23\u0e31\u0e2a\u0e40\u0e0b\u0e35\u0e22|\u0e1f\u0e34\u0e08\u0e34|\u0e1f\u0e34\u0e19\u0e41\u0e25\u0e19\u0e14\u0e4c|\u0e42\u0e23\u0e21\u0e32\u0e40\u0e19\u0e35\u0e22|\u0e40\u0e2d\u0e18\u0e34\u0e42\u0e2d\u0e40\u0e1b\u0e35\u0e22|\u0e2a\u0e40\u0e1b\u0e19|\u0e40\u0e2d\u0e23\u0e34\u0e40\u0e17\u0e23\u0e35\u0e22|\u0e0b\u0e32\u0e2e\u0e32\u0e23\u0e32\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01|\u0e2d\u0e35\u0e22\u0e34\u0e1b\u0e15\u0e4c|\u0e40\u0e2d\u0e2a\u0e42\u0e15\u0e40\u0e19\u0e35\u0e22|\u0e40\u0e2d\u0e01\u0e27\u0e32\u0e14\u0e2d\u0e23\u0e4c|\u0e41\u0e2d\u0e25\u0e08\u0e35\u0e40\u0e23\u0e35\u0e22|\u0e01\u0e32\u0e15\u0e32\u0e23\u0e4c|\u0e2a\u0e32\u0e18\u0e32\u0e23\u0e13\u0e23\u0e31\u0e10\u0e42\u0e14\u0e21\u0e34\u0e19\u0e34\u0e01\u0e31\u0e19|\u0e1b\u0e32\u0e23\u0e32\u0e01\u0e27\u0e31\u0e22|\u0e42\u0e14\u0e21\u0e34\u0e19\u0e34\u0e01\u0e32|\u0e40\u0e14\u0e19\u0e21\u0e32\u0e23\u0e4c\u0e01|\u0e08\u0e34\u0e1a\u0e39\u0e15\u0e35|\u0e42\u0e1b\u0e23\u0e15\u0e38\u0e40\u0e01\u0e2a|\u0e40\u0e1b\u0e2d\u0e23\u0e4c\u0e42\u0e15\u0e23\u0e34\u0e42\u0e01|\u0e40\u0e22\u0e2d\u0e23\u0e21\u0e19\u0e35|\u0e42\u0e1b\u0e41\u0e25\u0e19\u0e14\u0e4c|\u0e1b\u0e32\u0e01\u0e35\u0e2a\u0e16\u0e32\u0e19|\u0e1f\u0e34\u0e25\u0e34\u0e1b\u0e1b\u0e34\u0e19\u0e2a\u0e4c|\u0e1b\u0e32\u0e1b\u0e31\u0e27\u0e19\u0e34\u0e27\u0e01\u0e34\u0e19\u0e35|\u0e40\u0e1f\u0e23\u0e19\u0e0a\u0e4c\u0e42\u0e1e\u0e25\u0e35\u0e19\u0e35\u0e40\u0e0b\u0e35\u0e22|\u0e2a\u0e32\u0e18\u0e32\u0e23\u0e13\u0e23\u0e31\u0e10\u0e40\u0e0a\u0e47\u0e01|\u0e40\u0e1b\u0e23\u0e39|\u0e44\u0e0b\u0e1b\u0e23\u0e31\u0e2a|\u0e40\u0e04\u0e1b\u0e40\u0e27\u0e34\u0e23\u0e4c\u0e14|\u0e1b\u0e32\u0e19\u0e32\u0e21\u0e32|\u0e04\u0e34\u0e27\u0e1a\u0e32|\u0e04\u0e2d\u0e2a\u0e15\u0e32\u0e23\u0e34\u0e01\u0e32|\u0e42\u0e04\u0e25\u0e31\u0e21\u0e40\u0e1a\u0e35\u0e22|\u0e08\u0e35\u0e19|\u0e41\u0e04\u0e40\u0e21\u0e2d\u0e23\u0e39\u0e19|\u0e0a\u0e34\u0e25\u0e35|\u0e42\u0e01\u0e15\u0e14\u0e34\u0e27\u0e31\u0e27\u0e23\u0e4c|\u0e2a\u0e27\u0e34\u0e15\u0e40\u0e0b\u0e2d\u0e23\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c|\u0e04\u0e2d\u0e07\u0e42\u0e01|\u0e2a\u0e32\u0e18\u0e32\u0e23\u0e13\u0e23\u0e31\u0e10\u0e41\u0e2d\u0e1f\u0e23\u0e34\u0e01\u0e32\u0e01\u0e25\u0e32\u0e07|\u0e42\u0e2d\u0e21\u0e32\u0e19|\u0e41\u0e04\u0e19\u0e32\u0e14\u0e32|\u0e40\u0e1a\u0e25\u0e35\u0e0a|\u0e40\u0e1a\u0e25\u0e32\u0e23\u0e38\u0e2a|\u0e1a\u0e2d\u0e15\u0e2a\u0e27\u0e32\u0e19\u0e32|\u0e20\u0e39\u0e10\u0e32\u0e19|\u0e1a\u0e32\u0e2e\u0e32\u0e21\u0e32\u0e2a|\u0e1a\u0e23\u0e32\u0e0b\u0e34\u0e25|\u0e19\u0e34\u0e27\u0e0b\u0e35\u0e41\u0e25\u0e19\u0e14\u0e4c|\u0e42\u0e1a\u0e25\u0e34\u0e40\u0e27\u0e35\u0e22|\u0e1a\u0e23\u0e39\u0e44\u0e19|\u0e40\u0e1a\u0e2d\u0e23\u0e4c\u0e21\u0e34\u0e27\u0e14\u0e49\u0e32|\u0e19\u0e35\u0e22\u0e39|\u0e40\u0e1a\u0e19\u0e34\u0e19|\u0e1a\u0e38\u0e23\u0e38\u0e19\u0e14\u0e35|\u0e1a\u0e32\u0e2b\u0e4c\u0e40\u0e23\u0e19|\u0e1a\u0e31\u0e25\u0e41\u0e01\u0e40\u0e23\u0e35\u0e22|\u0e1a\u0e39\u0e23\u0e4c\u0e01\u0e34\u0e19\u0e32\u0e1f\u0e32\u0e42\u0e0b|\u0e40\u0e19\u0e1b\u0e32\u0e25|\u0e40\u0e1a\u0e25\u0e40\u0e22\u0e35\u0e22\u0e21|\u0e19\u0e2d\u0e23\u0e4c\u0e40\u0e27\u0e22\u0e4c|\u0e1a\u0e31\u0e07\u0e04\u0e25\u0e32\u0e40\u0e17\u0e28|\u0e1a\u0e32\u0e23\u0e4c\u0e40\u0e1a\u0e42\u0e14\u0e2a|\u0e0b\u0e34\u0e21\u0e1a\u0e32\u0e1a\u0e40\u0e27|\u0e40\u0e19\u0e40\u0e18\u0e2d\u0e23\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c|\u0e1a\u0e2d\u0e2a\u0e40\u0e19\u0e35\u0e22\u0e41\u0e25\u0e30\u0e40\u0e2e\u0e2d\u0e23\u0e4c\u0e40\u0e0b\u0e42\u0e01\u0e27\u0e35\u0e19\u0e32|\u0e19\u0e34\u0e04\u0e32\u0e23\u0e32\u0e01\u0e31\u0e27|\u0e44\u0e19\u0e08\u0e35\u0e40\u0e23\u0e35\u0e22|\u0e2d\u0e32\u0e40\u0e0b\u0e2d\u0e23\u0e4c\u0e44\u0e1a\u0e08\u0e32\u0e19|\u0e44\u0e19\u0e40\u0e08\u0e2d\u0e23\u0e4c|\u0e19\u0e34\u0e27\u0e41\u0e04\u0e25\u0e35\u0e42\u0e14\u0e40\u0e19\u0e35\u0e22|\u0e2d\u0e32\u0e23\u0e39\u0e1a\u0e32|\u0e41\u0e0b\u0e21\u0e40\u0e1a\u0e35\u0e22|\u0e2d\u0e2d\u0e2a\u0e40\u0e15\u0e23\u0e40\u0e25\u0e35\u0e22|\u0e19\u0e32\u0e21\u0e34\u0e40\u0e1a\u0e35\u0e22|\u0e2d\u0e2d\u0e2a\u0e40\u0e15\u0e23\u0e35\u0e22|\u0e2d\u0e32\u0e23\u0e4c\u0e40\u0e08\u0e19\u0e15\u0e34\u0e19\u0e32|\u0e41\u0e2d\u0e19\u0e15\u0e32\u0e23\u0e4c\u0e01\u0e15\u0e34\u0e01\u0e32|\u0e42\u0e21\u0e41\u0e0b\u0e21\u0e1a\u0e34\u0e04|\u0e41\u0e2d\u0e07\u0e42\u0e01\u0e25\u0e32|\u0e21\u0e32\u0e40\u0e25\u0e40\u0e0b\u0e35\u0e22|\u0e40\u0e19\u0e40\u0e2e\u0e2d\u0e23\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c\u0e41\u0e2d\u0e19\u0e17\u0e34\u0e25\u0e25\u0e34\u0e2a|\u0e40\u0e21\u0e47\u0e01\u0e0b\u0e34\u0e42\u0e01|\u0e2d\u0e32\u0e23\u0e4c\u0e40\u0e21\u0e40\u0e19\u0e35\u0e22|\u0e21\u0e32\u0e25\u0e32\u0e27\u0e35|\u0e41\u0e2d\u0e25\u0e40\u0e1a\u0e40\u0e19\u0e35\u0e22|\u0e41\u0e2d\u0e1f\u0e23\u0e34\u0e01\u0e32\u0e43\u0e15\u0e49|\u0e21\u0e2d\u0e23\u0e34\u0e40\u0e0a\u0e35\u0e22\u0e2a|\u0e21\u0e2d\u0e25\u0e15\u0e32|\u0e2d\u0e31\u0e19\u0e01\u0e34\u0e25\u0e48\u0e32|\u0e21\u0e2d\u0e19\u0e15\u0e4c\u0e40\u0e0b\u0e23\u0e4c\u0e41\u0e23\u0e47\u0e15|\u0e21\u0e2d\u0e23\u0e34\u0e40\u0e15\u0e40\u0e19\u0e35\u0e22|\u0e41\u0e2d\u0e19\u0e15\u0e34\u0e01\u0e32\u0e41\u0e25\u0e30\u0e1a\u0e32\u0e23\u0e4c\u0e1a\u0e39\u0e14\u0e32|\u0e21\u0e32\u0e23\u0e4c\u0e15\u0e34\u0e19\u0e35\u0e01|\u0e2d\u0e31\u0e1f\u0e01\u0e32\u0e19\u0e34\u0e2a\u0e16\u0e32\u0e19|\u0e2a\u0e2b\u0e23\u0e31\u0e10\u0e2d\u0e32\u0e2b\u0e23\u0e31\u0e1a\u0e40\u0e2d\u0e21\u0e34\u0e40\u0e23\u0e15\u0e2a\u0e4c|\u0e21\u0e32\u0e40\u0e01\u0e4a\u0e32 \u0e40\u0e02\u0e15\u0e1b\u0e01\u0e04\u0e23\u0e2d\u0e07\u0e1e\u0e34\u0e40\u0e28\u0e29\u0e1b\u0e23\u0e30\u0e40\u0e17\u0e28\u0e08\u0e35\u0e19|\u0e2d\u0e31\u0e19\u0e14\u0e2d\u0e23\u0e4c\u0e23\u0e32|\u0e21\u0e2d\u0e07\u0e42\u0e01\u0e40\u0e25\u0e35\u0e22|\u0e1e\u0e21\u0e48\u0e32|\u0e21\u0e32\u0e25\u0e35|\u0e21\u0e32\u0e0b\u0e34\u0e42\u0e14\u0e40\u0e19\u0e35\u0e22|\u0e22\u0e39\u0e42\u0e01\u0e2a\u0e25\u0e32\u0e40\u0e27\u0e35\u0e22|\u0e21\u0e32\u0e22\u0e2d\u0e15|\u0e21\u0e32\u0e14\u0e32\u0e01\u0e31\u0e2a\u0e01\u0e32\u0e23\u0e4c|\u0e21\u0e2d\u0e25\u0e42\u0e14\u0e27\u0e32|\u0e42\u0e21\u0e19\u0e32\u0e42\u0e01|\u0e42\u0e21\u0e23\u0e47\u0e2d\u0e01\u0e42\u0e01|\u0e40\u0e22\u0e40\u0e21\u0e19|\u0e25\u0e34\u0e40\u0e1a\u0e35\u0e22|\u0e25\u0e31\u0e15\u0e40\u0e27\u0e35\u0e22|\u0e25\u0e31\u0e01\u0e40\u0e0b\u0e21\u0e40\u0e1a\u0e34\u0e23\u0e4c\u0e01|\u0e25\u0e34\u0e17\u0e31\u0e27\u0e40\u0e19\u0e35\u0e22|\u0e40\u0e25\u0e42\u0e0b\u0e42\u0e17|\u0e44\u0e25\u0e1a\u0e35\u0e40\u0e23\u0e35\u0e22|\u0e28\u0e23\u0e35\u0e25\u0e31\u0e07\u0e01\u0e32|\u0e25\u0e34\u0e01\u0e40\u0e15\u0e19\u0e2a\u0e44\u0e15\u0e19\u0e4c|\u0e40\u0e25\u0e1a\u0e32\u0e19\u0e2d\u0e19|\u0e25\u0e32\u0e27|\u0e04\u0e32\u0e0b\u0e31\u0e04\u0e2a\u0e16\u0e32\u0e19|\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e40\u0e04\u0e22\u0e4c\u0e41\u0e21\u0e19|\u0e04\u0e39\u0e40\u0e27\u0e15|\u0e40\u0e01\u0e32\u0e2b\u0e25\u0e35\u0e43\u0e15\u0e49|\u0e40\u0e01\u0e32\u0e2b\u0e25\u0e35\u0e40\u0e2b\u0e19\u0e37\u0e2d|\u0e04\u0e2d\u0e42\u0e21\u0e42\u0e23\u0e2a|\u0e04\u0e34\u0e23\u0e34\u0e1a\u0e32\u0e2a|\u0e0b\u0e32\u0e21\u0e31\u0e27|\u0e01\u0e31\u0e21\u0e1e\u0e39\u0e0a\u0e32|\u0e04\u0e35\u0e23\u0e4c\u0e01\u0e34\u0e0b\u0e2a\u0e16\u0e32\u0e19|\u0e40\u0e04\u0e19\u0e22\u0e32|\u0e0d\u0e35\u0e48\u0e1b\u0e38\u0e48\u0e19|\u0e08\u0e2d\u0e23\u0e4c\u0e41\u0e14\u0e19|\u0e08\u0e32\u0e40\u0e21\u0e01\u0e32|\u0e27\u0e32\u0e19\u0e39\u0e2d\u0e32\u0e15\u0e39|\u0e40\u0e27\u0e35\u0e22\u0e14\u0e19\u0e32\u0e21|\u0e22\u0e39\u0e40\u0e2d\u0e2a\u0e40\u0e27\u0e2d\u0e23\u0e4c\u0e08\u0e34\u0e19\u0e44\u0e2d\u0e2a\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c|\u0e1a\u0e23\u0e34\u0e17\u0e34\u0e0a\u0e40\u0e27\u0e2d\u0e23\u0e4c\u0e08\u0e34\u0e19\u0e44\u0e2d\u0e2a\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c|\u0e40\u0e27\u0e40\u0e19\u0e0b\u0e38\u0e40\u0e2d\u0e25\u0e32|\u0e40\u0e0b\u0e19\u0e15\u0e4c\u0e27\u0e34\u0e19\u0e40\u0e0b\u0e19\u0e15\u0e4c\u0e41\u0e25\u0e30\u0e40\u0e01\u0e23\u0e19\u0e32\u0e14\u0e35\u0e19\u0e2a\u0e4c|\u0e2d\u0e34\u0e15\u0e32\u0e25\u0e35|\u0e44\u0e2d\u0e0b\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c|\u0e2d\u0e34\u0e2b\u0e23\u0e48\u0e32\u0e19|\u0e2d\u0e34\u0e23\u0e31\u0e01|\u0e2d\u0e38\u0e0b\u0e40\u0e1a\u0e01\u0e34\u0e2a\u0e16\u0e32\u0e19|\u0e2d\u0e38\u0e23\u0e38\u0e01\u0e27\u0e31\u0e22|\u0e2d\u0e34\u0e19\u0e40\u0e14\u0e35\u0e22|\u0e2d\u0e34\u0e2a\u0e23\u0e32\u0e40\u0e2d\u0e25|\u0e2a\u0e2b\u0e23\u0e31\u0e10\u0e2d\u0e40\u0e21\u0e23\u0e34\u0e01\u0e32|\u0e44\u0e2d\u0e23\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c|\u0e2d\u0e34\u0e19\u0e42\u0e14\u0e19\u0e35\u0e40\u0e0b\u0e35\u0e22|\u0e2d\u0e39\u0e01\u0e32\u0e19\u0e14\u0e32|\u0e22\u0e39\u0e40\u0e04\u0e23\u0e19|\u0e2e\u0e31\u0e07\u0e01\u0e32\u0e23\u0e35|\u0e40\u0e2e\u0e15\u0e34|\u0e42\u0e04\u0e23\u0e40\u0e2d\u0e40\u0e0a\u0e35\u0e22|\u0e17\u0e32\u0e19\u0e0b\u0e32\u0e40\u0e19\u0e35\u0e22|\u0e2e\u0e2d\u0e19\u0e14\u0e39\u0e23\u0e31\u0e2a|\u0e44\u0e15\u0e49\u0e2b\u0e27\u0e31\u0e19|\u0e2e\u0e48\u0e2d\u0e07\u0e01\u0e07 \u0e40\u0e02\u0e15\u0e1b\u0e01\u0e04\u0e23\u0e2d\u0e07\u0e1e\u0e34\u0e40\u0e28\u0e29\u0e1b\u0e23\u0e30\u0e40\u0e17\u0e28\u0e08\u0e35\u0e19|\u0e15\u0e23\u0e34\u0e19\u0e34\u0e41\u0e14\u0e14\u0e41\u0e25\u0e30\u0e42\u0e15\u0e40\u0e1a\u0e42\u0e01|\u0e15\u0e38\u0e23\u0e01\u0e35|\u0e15\u0e2d\u0e07\u0e01\u0e32|\u0e15\u0e39\u0e19\u0e34\u0e40\u0e0b\u0e35\u0e22|\u0e40\u0e15\u0e34\u0e23\u0e4c\u0e01\u0e40\u0e21\u0e19\u0e34\u0e2a\u0e16\u0e32\u0e19";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "es|ku|eo|ks|en|el|qu|ko|kn|km|kl|kk|wo|ka|dz|jv|pt|ps|de|pl|da|vo|ja|vi|cy|pa|cs|iu|it|co|is|uz|or|ik|ur|om|ca|ie|id|uk|ia|oc|ug|hy|br|hu|bo|bn|hr|bi|tw|bh|bg|tt|no|be|ts|hi|tr|nl|zu|ba|to|he|tn|tl|tk|ha|ne|az|ti|ay|th|tg|na|te|zh|as|ar|ta|gu|my|am|za|mt|ms|gn|sw|mr|sv|gl|su|af|st|mo|ss|mn|sr|sq|ml|ab|mk|aa|so|sn|mi|gd|sm|sl|mg|sk|ga|yo|si|sh|sg|yi|sd|fy|sa|fr|lv|lt|fo|rw|ru|lo|fj|ln|fi|ro|rn|rm|fa|la|xh|eu|ky|et";

  private static final String languagesValues = "\u0e2a\u0e40\u0e1b\u0e19|\u0e40\u0e04\u0e34\u0e14|\u0e40\u0e2d\u0e2a\u0e40\u0e1b\u0e2d\u0e23\u0e31\u0e19\u0e42\u0e15|\u0e04\u0e31\u0e0a\u0e21\u0e35\u0e23\u0e35|\u0e2d\u0e31\u0e07\u0e01\u0e24\u0e29|\u0e01\u0e23\u0e35\u0e01|\u0e04\u0e34\u0e27\u0e0a\u0e31\u0e27|\u0e40\u0e01\u0e32\u0e2b\u0e25\u0e35|\u0e01\u0e32\u0e19\u0e32\u0e14\u0e32|\u0e40\u0e02\u0e21\u0e23|\u0e01\u0e23\u0e35\u0e19\u0e41\u0e25\u0e19\u0e14\u0e4c\u0e14\u0e34\u0e04|\u0e04\u0e32\u0e0b\u0e31\u0e04|\u0e27\u0e39\u0e25\u0e2d\u0e1f|\u0e08\u0e2d\u0e23\u0e4c\u0e40\u0e08\u0e35\u0e22\u0e19|\u0e20\u0e39\u0e10\u0e32\u0e19\u0e35|\u0e0a\u0e27\u0e32|\u0e42\u0e1b\u0e23\u0e15\u0e38\u0e40\u0e01\u0e2a|\u0e1e\u0e32\u0e2a\u0e0a\u0e4c\u0e42\u0e15 (\u0e1e\u0e38\u0e2a\u0e0a\u0e4c\u0e42\u0e15)|\u0e40\u0e22\u0e2d\u0e23\u0e21\u0e31\u0e19|\u0e42\u0e1b\u0e41\u0e25\u0e19\u0e14\u0e4c|\u0e40\u0e14\u0e19\u0e21\u0e32\u0e23\u0e4c\u0e01|\u0e42\u0e27\u0e25\u0e32\u0e1e\u0e38\u0e01|\u0e0d\u0e35\u0e48\u0e1b\u0e38\u0e48\u0e19|\u0e40\u0e27\u0e35\u0e22\u0e14\u0e19\u0e32\u0e21|\u0e40\u0e27\u0e25\u0e2a\u0e4c|\u0e1b\u0e31\u0e0d\u0e08\u0e32\u0e1b|\u0e40\u0e0a\u0e47\u0e04|\u0e44\u0e2d\u0e19\u0e38\u0e01\u0e15\u0e34\u0e15\u0e31\u0e17|\u0e2d\u0e34\u0e15\u0e32\u0e25\u0e35|\u0e04\u0e2d\u0e23\u0e4c\u0e0b\u0e34\u0e01\u0e32|\u0e44\u0e2d\u0e0b\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c\u0e14\u0e34\u0e04|\u0e2d\u0e38\u0e2a\u0e40\u0e1a\u0e04|\u0e42\u0e2d\u0e23\u0e34\u0e22\u0e32|\u0e44\u0e2d\u0e19\u0e39\u0e40\u0e1b\u0e35\u0e22\u0e01|\u0e2d\u0e34\u0e23\u0e14\u0e39|\u0e42\u0e2d\u0e42\u0e23\u0e42\u0e21 (\u0e2d\u0e32\u0e1f\u0e32\u0e19)|\u0e41\u0e04\u0e15\u0e32\u0e41\u0e25\u0e19|\u0e2d\u0e34\u0e19\u0e40\u0e15\u0e2d\u0e23\u0e4c\u0e25\u0e34\u0e07\u0e04\u0e4c|\u0e2d\u0e34\u0e19\u0e42\u0e14\u0e19\u0e35\u0e40\u0e0a\u0e35\u0e22|\u0e22\u0e39\u0e40\u0e04\u0e23\u0e19|\u0e2d\u0e34\u0e19\u0e40\u0e15\u0e2d\u0e23\u0e4c\u0e25\u0e34\u0e07\u0e01\u0e27\u0e32|\u0e2d\u0e2d\u0e01\u0e0b\u0e34\u0e17\u0e31\u0e19|\u0e2d\u0e38\u0e22\u0e01\u0e31\u0e27|\u0e2d\u0e32\u0e23\u0e4c\u0e21\u0e35\u0e40\u0e19\u0e35\u0e22|\u0e1a\u0e23\u0e35\u0e17\u0e31\u0e19|\u0e2e\u0e31\u0e07\u0e01\u0e32\u0e23\u0e35|\u0e17\u0e34\u0e40\u0e1a\u0e15|\u0e40\u0e1a\u0e19\u0e01\u0e32\u0e23\u0e35|\u0e42\u0e04\u0e23\u0e40\u0e2d\u0e40\u0e17\u0e35\u0e22|\u0e1a\u0e34\u0e2a\u0e25\u0e32\u0e21\u0e32|\u0e17\u0e27\u0e35|\u0e1a\u0e34\u0e2e\u0e32\u0e23\u0e35|\u0e1a\u0e31\u0e25\u0e41\u0e01\u0e40\u0e23\u0e35\u0e22|\u0e15\u0e32\u0e14|\u0e19\u0e2d\u0e23\u0e4c\u0e40\u0e27\u0e22\u0e4c|\u0e1a\u0e32\u0e22\u0e42\u0e25\u0e23\u0e31\u0e2a\u0e40\u0e0b\u0e35\u0e22|\u0e0b\u0e2d\u0e07\u0e01\u0e32|\u0e2e\u0e34\u0e19\u0e14\u0e35|\u0e15\u0e38\u0e23\u0e01\u0e35|\u0e2e\u0e2d\u0e25\u0e31\u0e19\u0e14\u0e32|\u0e0b\u0e39\u0e25\u0e39|\u0e1a\u0e32\u0e2a\u0e0a\u0e4c\u0e01\u0e35\u0e23\u0e4c|\u0e17\u0e2d\u0e07\u0e01\u0e49\u0e32|\u0e2e\u0e34\u0e1a\u0e23\u0e39|\u0e40\u0e0b\u0e15\u0e2a\u0e27\u0e32\u0e19\u0e32|\u0e15\u0e32\u0e01\u0e32\u0e25\u0e47\u0e2d\u0e01|\u0e40\u0e15\u0e34\u0e23\u0e4c\u0e01\u0e40\u0e21\u0e19|\u0e42\u0e2e\u0e0b\u0e32|\u0e40\u0e19\u0e1b\u0e32\u0e25|\u0e2d\u0e32\u0e40\u0e0b\u0e2d\u0e23\u0e4c\u0e44\u0e1a\u0e08\u0e32\u0e19\u0e35|\u0e17\u0e34\u0e01\u0e23\u0e34\u0e19\u0e22\u0e32|\u0e44\u0e2d\u0e21\u0e32\u0e23\u0e32|\u0e44\u0e17\u0e22|\u0e17\u0e32\u0e08\u0e34\u0e04|\u0e19\u0e2d\u0e23\u0e39|\u0e17\u0e34\u0e25\u0e39\u0e01\u0e39|\u0e08\u0e35\u0e19|\u0e2d\u0e31\u0e2a\u0e2a\u0e31\u0e21\u0e21\u0e34\u0e2a|\u0e2d\u0e32\u0e23\u0e32\u0e1a\u0e34\u0e04|\u0e17\u0e21\u0e34\u0e2c|\u0e01\u0e39\u0e08\u0e32\u0e23\u0e32\u0e15\u0e34|\u0e1e\u0e21\u0e48\u0e32|\u0e2d\u0e31\u0e21\u0e2e\u0e32\u0e23\u0e34\u0e04|\u0e08\u0e27\u0e07|\u0e21\u0e2d\u0e25\u0e15\u0e32|\u0e21\u0e25\u0e32\u0e22\u0e39|\u0e01\u0e31\u0e27\u0e23\u0e32\u0e19\u0e35|\u0e0b\u0e27\u0e32\u0e2e\u0e34\u0e23\u0e35|\u0e21\u0e32\u0e23\u0e32\u0e17\u0e35|\u0e2a\u0e27\u0e35\u0e40\u0e14\u0e19|\u0e01\u0e30\u0e25\u0e35\u0e40\u0e0a\u0e35\u0e22|\u0e0b\u0e31\u0e19\u0e14\u0e32\u0e19\u0e35\u0e2a|\u0e41\u0e2d\u0e1f\u0e23\u0e34\u0e01\u0e31\u0e19|\u0e40\u0e0b\u0e42\u0e2a\u0e42\u0e17|\u0e42\u0e21\u0e14\u0e32\u0e40\u0e27\u0e35\u0e22|\u0e0b\u0e35\u0e2a\u0e27\u0e32\u0e15\u0e34|\u0e21\u0e2d\u0e07\u0e42\u0e01\u0e25|\u0e40\u0e0b\u0e2d\u0e23\u0e4c\u0e40\u0e1a\u0e35\u0e22|\u0e41\u0e2d\u0e25\u0e40\u0e1a\u0e40\u0e19\u0e35\u0e22|\u0e21\u0e32\u0e25\u0e32\u0e22\u0e32\u0e25\u0e31\u0e21|\u0e41\u0e2d\u0e1a\u0e01\u0e32\u0e40\u0e0b\u0e35\u0e22|\u0e41\u0e21\u0e0b\u0e35\u0e42\u0e14\u0e40\u0e19\u0e35\u0e22|\u0e2d\u0e32\u0e1f\u0e32|\u0e42\u0e0b\u0e21\u0e32\u0e25\u0e35|\u0e42\u0e0b\u0e19\u0e32|\u0e40\u0e21\u0e32\u0e23\u0e35|\u0e2a\u0e01\u0e47\u0e2d\u0e15\u0e2a\u0e4c\u0e40\u0e01\u0e25\u0e34\u0e04|\u0e0b\u0e32\u0e21\u0e31\u0e27|\u0e2a\u0e42\u0e25\u0e40\u0e27\u0e40\u0e19\u0e35\u0e22|\u0e21\u0e32\u0e25\u0e32\u0e01\u0e32\u0e0b\u0e35|\u0e2a\u0e42\u0e25\u0e27\u0e31\u0e04|\u0e44\u0e2d\u0e23\u0e34\u0e0a|\u0e42\u0e22\u0e23\u0e39\u0e1a\u0e32|\u0e2a\u0e34\u0e07\u0e2b\u0e25|\u0e40\u0e0b\u0e2d\u0e23\u0e4c\u0e42\u0e1a-\u0e42\u0e04\u0e23\u0e40\u0e2d\u0e40\u0e17\u0e35\u0e22\u0e19|\u0e2a\u0e31\u0e19\u0e42\u0e04|\u0e22\u0e35\u0e14\u0e34\u0e0a|\u0e0b\u0e34\u0e19\u0e14\u0e34|\u0e1f\u0e23\u0e35\u0e2a\u0e41\u0e25\u0e19\u0e14\u0e4c|\u0e2a\u0e31\u0e19\u0e2a\u0e01\u0e24\u0e15|\u0e1d\u0e23\u0e31\u0e48\u0e07\u0e40\u0e28\u0e2a|\u0e41\u0e25\u0e15\u0e40\u0e27\u0e35\u0e22 (\u0e40\u0e25\u0e17\u0e17\u0e34\u0e2a\u0e0a\u0e4c)|\u0e25\u0e34\u0e18\u0e31\u0e27\u0e40\u0e19\u0e35\u0e22|\u0e1f\u0e32\u0e42\u0e23\u0e2a|\u0e04\u0e34\u0e19\u0e22\u0e32\u0e27\u0e31\u0e19\u0e14\u0e32|\u0e23\u0e31\u0e2a\u0e40\u0e0b\u0e35\u0e22|\u0e25\u0e32\u0e27|\u0e1f\u0e34\u0e08\u0e34|\u0e25\u0e34\u0e07\u0e01\u0e32\u0e25\u0e32|\u0e1f\u0e34\u0e19|\u0e42\u0e23\u0e21\u0e31\u0e19|\u0e04\u0e34\u0e23\u0e31\u0e19\u0e14\u0e35|\u0e40\u0e23\u0e42\u0e15-\u0e42\u0e23\u0e41\u0e21\u0e19\u0e0b\u0e4c|\u0e40\u0e1b\u0e2d\u0e23\u0e4c\u0e40\u0e0b\u0e35\u0e22|\u0e25\u0e30\u0e15\u0e34\u0e19|\u0e42\u0e0b\u0e2a\u0e32|\u0e41\u0e1a\u0e2a\u0e01\u0e4c|\u0e40\u0e04\u0e2d\u0e23\u0e4c\u0e01\u0e34\u0e0b|\u0e40\u0e2d\u0e2a\u0e42\u0e15\u0e40\u0e19\u0e35\u0e22";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "localPatternChars", "GanjkHmsSEDFwWxhKzAeugXZ" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "ampms", ampms },
    { "shortDateFormat", "d/M/yyyy" },
    { "mediumDateFormat", "d MMM yyyy" },
    { "longDateFormat", "d MMMM yyyy" },
    { "fullDateFormat", "EEEE'\u0e17\u0e35\u0e48 'd MMMM G yyyy" },
    { "shortTimeFormat", "H:mm" },
    { "mediumTimeFormat", "H:mm:ss" },
    { "longTimeFormat", "H' \u0e19\u0e32\u0e2c\u0e34\u0e01\u0e32 'm' \u0e19\u0e32\u0e17\u0e35'" },
    { "fullTimeFormat", "H' \u0e19\u0e32\u0e2c\u0e34\u0e01\u0e32 'm' \u0e19\u0e32\u0e17\u0e35 'ss' \u0e27\u0e34\u0e19\u0e32\u0e17\u0e35'" },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
