#ifdef linux
#define DIRENT_ILLEGAL_ACCESS /* for dirent */
#endif

/*
 * readdir.c
 *
 * Copyright (C) 1993 Alain Knaff
 */
#include "sysincludes.h"


struct dirent *__libc_readdir(DIR * dir);


#ifdef oldlinux
/* old version of readdir */

/*
 * readdir fills up the buffer with the readdir system call. it also
 * gives a third parameter (currently ignored, but should be 1) that
 * can with a future kernel be enhanced to be the number of entries
 * to be gotten.
 *
 * Right now the readdir system call return the number of characters
 * in the name - in the future it will probably return the number of
 * entries gotten. No matter - right now we just check for positive:
 * that will always work (as we know that it cannot be bigger than 1
 * in the future: we just asked for one entry).
 */
struct dirent *__libc_readdir(DIR * dir)
{
  int result;
  int count = NUMENT;

  if (dir->dd_size <= dir->dd_nextloc) {
    /* read count of directory entries. For now it should be one. */
#if defined(__PIC__) || defined (__pic__)
	__asm__ volatile ("pushl %%ebx\n\t"
			  "movl %%esi,%%ebx\n\t"
			  "int $0x80\n\t"
			  "popl %%ebx"
	:"=a" (result)
	:"0" (SYS_readdir),"S" (dir->dd_fd),
	"c" ((long) dir->dd_buf),"d" (count));
#else
    __asm__("int $0x80"
	:"=a" (result)
	:"0" (SYS_readdir),"b" (dir->dd_fd),
	"c" ((long) dir->dd_buf),"d" (count));
#endif
    if (result <= 0) {
      if (result < 0)
	errno = -result;
      return NULL;
    }

    /*
     * Right now the readdir system call return the number of
     * characters in the name - in the future it will probably return
     * the number of entries gotten. No matter - right now we just
     * check for positive:
     */
    dir->dd_size = 1;

    dir->dd_nextloc = 0;
  }

  return &(dir->dd_buf [(dir->dd_nextloc)++]);
}
#endif


static void adjust_name(int fd, struct dirent *de)
{
  int l;
  char *extension;
  
  if (zlib_mode & CM_VERBOSE)
    fprintf(stderr,"adjust name: %s\n", de->d_name);

  l = NAMLEN(de);

  /* substitute .z by nothing */
  if (l > zlib_extlen){
    /* we ask for name-length stricly bigger than extlen, in order to
     * avoid empty file names :-) */
    extension = (de->d_name + l - zlib_extlen);
    if (strncmp(extension, zlib_ext, zlib_extlen) == 0 ){
      *extension='\0';
      if ( (zlib_getfiletype(de->d_name,fd) & PM_READ_MASK) >=
	   PM_DIR_LEAVE_COMPR)
	/* put back into place, if we "hide" these files */
	*extension=*zlib_ext;
#ifdef HAVE_NAMLEN
      else
	de->d_namlen -= zlib_extlen;
#endif
    }
  }
}

#ifdef SYS_getdents

int getdents(int fd, struct dirent *dirp, unsigned int count)
{
  int left;

  count=real_getdents(fd, dirp, count);
  if(count<=0)
    return count;

  zlib_initialise();

  if(zlib_mode & ( CM_DISAB | CM_READDIR_COMPR))
    return count;

  if (zlib_mode & CM_VERBOSE)
    fprintf(stderr,"getdents\n");
  
  for(left = count;
      left;
      left -= dirp->d_reclen,
      dirp = (struct dirent *) ((char *)dirp + dirp->d_reclen))
    adjust_name(fd, dirp);
  return count;
}

#endif


#ifdef SYS_readdir

struct dirent *readdir(DIR *dirp)
{
  struct dirent *de;

  de = real_readdir(dirp);

  if(!de)
    return de;

  zlib_initialise();
  if(zlib_mode & ( CM_DISAB | CM_READDIR_COMPR))
    return de;
  adjust_name(dirp->dd_fd, de);
  return de;
}

#endif


#if 0
/* SunOS */

struct dirent *readdir(DIR *dirp)
{
  struct dirent *ptr;
  char *extension;
  int l;

  if (!dirp) {
    errno = EBADF;
    return NULL; 
  }

  if ( dirp->dd_size){
    ptr = (struct dirent *) ( dirp->dd_buf + dirp->dd_loc);
    dirp->dd_loc += ptr->d_reclen;
  }
    
  if ( dirp->dd_size <= dirp->dd_loc ){
    dirp->dd_size=getdents( dirp->dd_fd, dirp->dd_buf, dirp->dd_bsize);
    if ( dirp->dd_size == 0 )
      return 0;
    dirp->dd_loc = 0;
  }

  ptr = (struct dirent *) ( dirp->dd_buf + dirp->dd_loc);
  dirp->dd_off = ptr->d_off;

  zlib_initialise();
  adjust_name(dirp->dd_fd,ptr);  
  return ptr;
}
#endif

