/************************************************************************/
/* File		dataelement.h						*/
/*									*/
/* Purpose	This C++ header file contains the definition for the	*/
/*		DataElement class. The DataElement class is used to	*/
/*		store individual elements of a DataBase record. Each	*/
/*		element can contain a specific type of information.	*/
/*									*/
/* Author	This C++ header file was written by Charles Henry	*/
/*		Schoonover for Padre Software. You can contact Charles	*/
/*		Henry Schoonover at charles@padresoftware.com.		*/
/*									*/
/* Owner	The contents of this C++ header file were written for	*/
/*		Padre Software. You can contact Padre Software at	*/
/*		webmaster@padresoftware.com.				*/
/*									*/
/* Version	00.00.00 (Prototype)					*/
/*									*/
/* Date		Sunday, June 23, 2002.					*/
/*									*/
/* Copyright	(C) 2002 by Padre Software Incorporated.		*/
/*		All rights are reserved.				*/
/*									*/
/*		Padre Software has released the source code in this	*/
/*		file to the public domain under the terms of the GNU	*/
/*		General Public License. (See the file COPYING).		*/
/*									*/
/*		This program is free software; you can redistribute it	*/
/*		and/or modify it under the terms of the GNU General	*/
/*		Public License as published by the Free Software	*/
/*		Foundation; either version 2 of the License, or (at	*/
/*		your option) any later version.				*/
/************************************************************************/

#ifndef DATAELEMENT_H			// If not defined...
#define DATAELEMENT_H			// Then process header file.

/* Enumeration	The following enumeration defines the basic data types	*/
/*		that a DataElement object can contain. A DataElement	*/
/*		object is initialized to DataElementUndefined.		*/

enum DataElementType
   {
      DataElementUndefined	= 0,	// Undefined element.
      DataElementString		= 1,	// String element.
      DataElementNumber		= 2,	// Number element.
      DataElementFloat		= 3,	// Float element.
      DataElementTime		= 4,	// Time element.
      DataElementDate		= 5,	// Date element.
   };

/* Type		The following type defines the data structure that is	*/
/*		used to store data of the type time in a DataElement	*/
/*		object. This structure is modeled after the 'struct tm'	*/
/*		data structure that is defined in time.h.		*/

typedef struct DataElementTimeType
   {
      int		seconds;	// Same as tm_sec.
      int		minutes;	// Same as tm_min.
      int		hours;		// Same as tm_hour.
   };

/* Type		The following type defines the data structure that is	*/
/*		used to store data of the type date in a DataElement	*/
/*		object. This structure is modeled after the 'struct tm'	*/
/*		data structure that is defined in time.h.		*/

typedef struct DataElementDateType
   {
      int		day;		// Same as tm_mday.
      int		month;		// Same as tm_mon.
      int		year;		// Same as tm_year.
      int		dayinweek;	// Same as tm_wday.
      int		dayinyear;	// Same as tm_yday.
      int		daylight;	// Same as tm_isdst.
   };

/* Class	The following class defines the DataElement class. The	*/
/*		DataElement class is the basic storage unit of a	*/
/*		DataRecord object.					*/

class DataElement
   {
      public:
	 DataElement();
	 DataElement(const DataElementType);
	 DataElement(const DataElement&);
	 ~DataElement();

	 int Record_Size(void);
	 status Read_From_File(File&, const int);
	 status Write_To_File(File&, const int);

	 void Set_Element_Type(const DataElementType);
	 DataElementType Get_Element_Type(void) const;
	 void Clear_Element(void);
	 void Copy_Element(const DataElement&);

	 void Set_Data(const String&);
	 void Set_Data(const int&);
	 void Set_Data(const float&);
	 void Set_Data(const DataElementTimeType&);
	 void Set_Data(const DataElementDateType&);

	 void Get_Data(String&) const;
	 void Get_Data(int&) const;
	 void Get_Data(float&) const;
	 void Get_Data(DataElementTimeType&) const;
	 void Get_Data(DataElementDateType&) const;

      private:
	 DataElementType	itstype;
	 void*			itsdata;

	 void delete_element_data(void);
	 void allocate_element_data(const DataElementType);
   };

#endif				// DATAELEMENT_H
