/*
 * Copyright (C) 1997 - 2001 Loic Dachary
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */
#ifndef _html_h
#define _html_h

#include <webbase_url.h>

typedef struct html_content_data {
  webbase_url_t* webbase_url;
  int extract_length;
} html_content_data_t;

#ifdef WEBBASE_CONTENT_BASE
int html_href(char* content, int content_length, webbase_url_t* webbase_url, int size_limit);
#else /* WEBBASE_CONTENT_BASE */
int html_href(char* path, webbase_url_t* webbase_url, int size_limit);
#endif /* WEBBASE_CONTENT_BASE */
int html_content_begin(char* buffer, int buffer_length, webbase_url_t* webbase_url);

#endif /* _html_h */
