/* Source Installer, Copyright (c) 2005,2006,2007 Claudio Fontana

 menu.c - Source Installer menu

 This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
     (at your option) any later version.

 This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
     along with this program (look for the file called COPYING);
     if not, write to the Free Software Foundation, Inc.,
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     You can contact the author (Claudio Fontana) by sending a mail
     to claudio@gnu.org
*/

#include "global.h"
#include "gui.h"
#include "menu.h"

#include <gdk/gdkkeysyms.h>

GtkWidget* w_menu[W_MENU_N];

static GtkWidget* menu_file;
static GtkWidget* menu_edit;
static GtkWidget* menu_package;
static GtkWidget* menu_package_export;
static GtkWidget* menu_window;
static GtkWidget* menu_help;

void menu_create(void) {
  int i;

  w_menu[W_MENU] = gtk_menu_bar_new();

  menu_file = gtk_menu_new();
  menu_edit = gtk_menu_new();

  menu_package = gtk_menu_new(); menu_package_export = gtk_menu_new();
  menu_window = gtk_menu_new();
  menu_help = gtk_menu_new();

  w_menu[W_MENU_FILE] = gtk_menu_item_new_with_mnemonic("_File");
  w_menu[W_MENU_FILE_QUIT] = gtk_image_menu_item_new_from_stock(GTK_STOCK_QUIT, acc);
  w_menu[W_MENU_EDIT] = gtk_menu_item_new_with_mnemonic("_Edit");
  w_menu[W_MENU_EDIT_CUT] = gtk_image_menu_item_new_from_stock(GTK_STOCK_CUT, acc);
  w_menu[W_MENU_EDIT_COPY] = gtk_image_menu_item_new_from_stock(GTK_STOCK_COPY, acc);
  w_menu[W_MENU_EDIT_PASTE] = gtk_image_menu_item_new_from_stock(GTK_STOCK_PASTE, acc);
  w_menu[W_MENU_EDIT_DEL] = gtk_image_menu_item_new_from_stock(GTK_STOCK_DELETE, acc);
  w_menu[W_MENU_EDIT_PREF] = gtk_image_menu_item_new_from_stock(GTK_STOCK_PREFERENCES, acc);

  for (i = W_MENU_EDIT_CUT; i <= W_MENU_EDIT_DEL; i++)
    gtk_widget_set_sensitive(w_menu[i], FALSE);
      
  w_menu[W_MENU_PACKAGE] = gtk_menu_item_new_with_mnemonic("_Package");
  w_menu[W_MENU_PACKAGE_ADD] = gtk_image_menu_item_new_from_stock(GTK_STOCK_ADD, acc);
  gtk_widget_add_accelerator(w_menu[W_MENU_PACKAGE_ADD], "activate", acc,
			     GDK_a, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  w_menu[W_MENU_PACKAGE_REMOVE] = gtk_image_menu_item_new_from_stock(GTK_STOCK_REMOVE, acc);
  gtk_widget_add_accelerator(w_menu[W_MENU_PACKAGE_REMOVE], "activate", acc,
			     GDK_r, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  w_menu[W_MENU_PACKAGE_INSTALL] = gtk_image_menu_item_new_with_mnemonic("_Install");
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(w_menu[W_MENU_PACKAGE_INSTALL]), gtk_image_new_from_stock(GTK_STOCK_FLOPPY, GTK_ICON_SIZE_MENU));
  gtk_widget_add_accelerator(w_menu[W_MENU_PACKAGE_INSTALL], "activate", acc,
			     GDK_i, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  w_menu[W_MENU_PACKAGE_UNINSTALL] = gtk_image_menu_item_new_with_mnemonic("_Uninstall");
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(w_menu[W_MENU_PACKAGE_UNINSTALL]), gtk_image_new_from_stock(GTK_STOCK_CLEAR, GTK_ICON_SIZE_MENU));
  gtk_widget_add_accelerator(w_menu[W_MENU_PACKAGE_UNINSTALL], "activate", acc,
			     GDK_u, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  w_menu[W_MENU_PACKAGE_UPGRADE] = gtk_image_menu_item_new_with_mnemonic("Up_grade");
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(w_menu[W_MENU_PACKAGE_UPGRADE]), gtk_image_new_from_stock(GTK_STOCK_CONVERT, GTK_ICON_SIZE_MENU));
  gtk_widget_add_accelerator(w_menu[W_MENU_PACKAGE_UPGRADE], "activate", acc,
			     GDK_g, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  w_menu[W_MENU_PACKAGE_EXPORT] = gtk_menu_item_new_with_mnemonic("E_xport");
  w_menu[W_MENU_PACKAGE_EXPORT_INFO] = gtk_menu_item_new_with_mnemonic("Package _information");
  w_menu[W_MENU_PACKAGE_EXPORT_BIN] = gtk_menu_item_new_with_mnemonic("As _binary package (experimental)");
  w_menu[W_MENU_PACKAGE_EXPORT_ALL] = gtk_menu_item_new_with_mnemonic("_All packages information");

  w_menu[W_MENU_WINDOW] = gtk_menu_item_new_with_mnemonic("_Window");
  w_menu[W_MENU_WINDOW_DEFAULT] = gtk_menu_item_new_with_mnemonic("_Default size");
  w_menu[W_MENU_HELP] = gtk_menu_item_new_with_mnemonic("_Help");
  
#if GTK_CHECK_VERSION(2, 6, 0)
  w_menu[W_MENU_HELP_ABOUT] = gtk_image_menu_item_new_from_stock(GTK_STOCK_ABOUT, acc);
#else
  w_menu[W_MENU_HELP_ABOUT] = gtk_image_menu_item_new_from_stock(GTK_STOCK_HELP, acc);
#endif

  gtk_menu_item_set_submenu(GTK_MENU_ITEM(w_menu[W_MENU_FILE]), menu_file);
  gtk_menu_shell_append(GTK_MENU_SHELL(menu_file), w_menu[W_MENU_FILE_QUIT]);

  gtk_menu_item_set_submenu(GTK_MENU_ITEM(w_menu[W_MENU_EDIT]), menu_edit);
  gtk_menu_shell_append(GTK_MENU_SHELL(menu_edit), w_menu[W_MENU_EDIT_CUT]);
  gtk_menu_shell_append(GTK_MENU_SHELL(menu_edit), w_menu[W_MENU_EDIT_COPY]);
  gtk_menu_shell_append(GTK_MENU_SHELL(menu_edit), w_menu[W_MENU_EDIT_PASTE]);
  gtk_menu_shell_append(GTK_MENU_SHELL(menu_edit), w_menu[W_MENU_EDIT_DEL]);
  gtk_menu_shell_append(GTK_MENU_SHELL(menu_edit), gtk_separator_menu_item_new());
  gtk_menu_shell_append(GTK_MENU_SHELL(menu_edit), w_menu[W_MENU_EDIT_PREF]);

  gtk_menu_item_set_submenu(GTK_MENU_ITEM(w_menu[W_MENU_PACKAGE]), menu_package);
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(w_menu[W_MENU_PACKAGE_EXPORT]), menu_package_export);
  gtk_menu_shell_append(GTK_MENU_SHELL(menu_package), w_menu[W_MENU_PACKAGE_ADD]);
  gtk_menu_shell_append(GTK_MENU_SHELL(menu_package), w_menu[W_MENU_PACKAGE_REMOVE]);
  gtk_menu_shell_append(GTK_MENU_SHELL(menu_package), w_menu[W_MENU_PACKAGE_INSTALL]);
  gtk_menu_shell_append(GTK_MENU_SHELL(menu_package), w_menu[W_MENU_PACKAGE_UNINSTALL]);
  gtk_menu_shell_append(GTK_MENU_SHELL(menu_package), w_menu[W_MENU_PACKAGE_UPGRADE]);
  gtk_menu_shell_append(GTK_MENU_SHELL(menu_package), w_menu[W_MENU_PACKAGE_EXPORT]);
  gtk_menu_shell_append(GTK_MENU_SHELL(menu_package_export), w_menu[W_MENU_PACKAGE_EXPORT_INFO]);
  gtk_menu_shell_append(GTK_MENU_SHELL(menu_package_export), w_menu[W_MENU_PACKAGE_EXPORT_BIN]);
  gtk_menu_shell_append(GTK_MENU_SHELL(menu_package_export), gtk_separator_menu_item_new());
  gtk_menu_shell_append(GTK_MENU_SHELL(menu_package_export), w_menu[W_MENU_PACKAGE_EXPORT_ALL]);

  gtk_menu_item_set_submenu(GTK_MENU_ITEM(w_menu[W_MENU_WINDOW]), menu_window);
  gtk_menu_shell_append(GTK_MENU_SHELL(menu_window), w_menu[W_MENU_WINDOW_DEFAULT]);
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(w_menu[W_MENU_HELP]), menu_help);
  /*  gtk_menu_shell_append(GTK_MENU_SHELL(menu_help), w_menu[W_MENU_HELP_CONTENTS]); */
  gtk_menu_shell_append(GTK_MENU_SHELL(menu_help), w_menu[W_MENU_HELP_ABOUT]);

  gtk_menu_bar_append(GTK_MENU_BAR(w_menu[W_MENU]), w_menu[W_MENU_FILE]);
  gtk_menu_bar_append(GTK_MENU_BAR(w_menu[W_MENU]), w_menu[W_MENU_EDIT]);
  gtk_menu_bar_append(GTK_MENU_BAR(w_menu[W_MENU]), w_menu[W_MENU_PACKAGE]);
  gtk_menu_bar_append(GTK_MENU_BAR(w_menu[W_MENU]), w_menu[W_MENU_WINDOW]);
  gtk_menu_bar_append(GTK_MENU_BAR(w_menu[W_MENU]), w_menu[W_MENU_HELP]);
}

void menu_update(void) {
/* update menu widget depending on current state */

  if (state.actions_locked) {
    gtk_widget_set_sensitive(w_menu[W_MENU_EDIT], FALSE);
    gtk_widget_set_sensitive(w_menu[W_MENU_PACKAGE], FALSE);
    
  } else {
    int installed; int source_available;

    if (state.package) {
      installed = srcinst_is_installed(state.package);
      source_available = srcinst_is_source_available(state.package);
    }

    gtk_widget_set_sensitive(w_menu[W_MENU_EDIT], TRUE);
    gtk_widget_set_sensitive(w_menu[W_MENU_PACKAGE], TRUE);

    gtk_widget_set_sensitive(w_menu[W_MENU_PACKAGE_REMOVE], 
			     state.package ? TRUE : FALSE);

    gtk_widget_set_sensitive(w_menu[W_MENU_PACKAGE_INSTALL], 
			     state.package && source_available &&
			     !installed ? TRUE : FALSE);

    gtk_widget_set_sensitive(w_menu[W_MENU_PACKAGE_UNINSTALL], 
			     state.package && installed ? TRUE : FALSE);

    gtk_widget_set_sensitive(w_menu[W_MENU_PACKAGE_UPGRADE], 
			     state.package ? TRUE : FALSE);

    gtk_widget_set_sensitive(w_menu[W_MENU_PACKAGE_EXPORT_INFO], 
			     state.package ? TRUE : FALSE);

    gtk_widget_set_sensitive(w_menu[W_MENU_PACKAGE_EXPORT_BIN], 
			     state.package && installed);
  }
}

void menu_popup(guint button, guint32 time) {
  gtk_menu_popup(GTK_MENU(menu_package), NULL, NULL, NULL, NULL, button, time);
}
