/* Source Installer, Copyright (c) 2005-2006 Claudio Fontana

 pref.h - header for interface fundamentals

 This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.

 This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
     along with this program (look for the file called COPYING);
     if not, write to the Free Software Foundation, Inc.,
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     You can contact the author (Claudio Fontana) by sending a mail
     to claudio@gnu.org
*/

#ifndef PREF_H
#define PREF_H

enum {
  W_PREF,
  W_PREF_PREFIX, W_PREF_PREFIX_BROWSE,
  W_PREF_ADD, W_PREF_ADD_BROWSE,
  W_PREF_INSTALL, W_PREF_SOURCE, W_PREF_CONFIGURE, W_PREF_STRIP,
  W_PREF_QUIET,
  W_PREF_COMP,
  W_PREF_SAVE, W_PREF_APPLY, W_PREF_CANCEL,

  W_PREF_N
};

extern GtkWidget* w_pref[W_PREF_N];

void pref_create(void);
void pref_reset(void); /* set field values from options */
void pref_show(void);
void pref_hide(void);

void pref_directory_browse_clicked(GtkWidget* browse, GtkWidget* entry);
gboolean pref_delete_event(GtkWidget* w, GdkEvent* e, gpointer data);

void pref_save_clicked(GtkWidget* unused_w, gpointer unused_data);
void pref_apply_clicked(GtkWidget* unused_w, gpointer unused_data);
void pref_cancel_clicked(GtkWidget* unused_w, gpointer unused_data);

#endif /* PREF_H */
