/* Source Installer, Copyright (c) 2005-2006 Claudio Fontana

 pref.c - preferences dialog

 This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.

 This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
     along with this program (look for the file called COPYING);
     if not, write to the Free Software Foundation, Inc.,
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     You can contact the author (Claudio Fontana) by sending a mail
     to claudio@gnu.org
*/

#include "global.h"
#include "gui.h"
#include "dialog.h"
#include "pref.h"

/* this function creates a directory selection entry and returns the
   containing hbox */

GtkWidget* w_pref[W_PREF_N];

static GtkWidget* pref_create_direntry(char* label, int widx, int wbrowse) {
  GtkWidget* hbox, *lbl;

  hbox = gtk_hbox_new(FALSE, 0);
  
  lbl = gtk_label_new(label);
  gtk_box_pack_start(GTK_BOX(hbox), lbl, TRUE, TRUE, 0);

  gtk_misc_set_alignment(GTK_MISC(lbl), 0.0, 0.5);

  w_pref[widx] = gtk_entry_new();
  w_pref[wbrowse] = gtk_button_new_with_label("Browse...");
  gtk_box_pack_start(GTK_BOX(hbox), w_pref[widx], FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(hbox), w_pref[wbrowse], FALSE, FALSE, 0);
  return hbox;
}

void pref_create(void) {
  GtkWidget* content, *frame, *vbox, *hbox, *lbl;

  w_pref[W_PREF] = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(w_pref[W_PREF]), "GNU Source Installer - Preferences");
  gtk_window_set_modal(GTK_WINDOW(w_pref[W_PREF]), TRUE);
  gtk_window_set_transient_for(GTK_WINDOW(w_pref[W_PREF]), GTK_WINDOW(w_main[W_MAIN]));
  gtk_window_set_destroy_with_parent(GTK_WINDOW(w_pref[W_PREF]), TRUE);
  
  content = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(w_pref[W_PREF]), content);

  /* Directories */
  frame = gtk_frame_new(NULL);
  gtk_box_pack_start(GTK_BOX(content), frame, FALSE, FALSE, 0);

  vbox = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(frame), vbox);
  gtk_container_set_border_width(GTK_CONTAINER(vbox), bw);
  
  hbox = pref_create_direntry("Installation directory prefix: ", 
			      W_PREF_PREFIX, 
			      W_PREF_PREFIX_BROWSE);

  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
  
  /* add directory */
  hbox = pref_create_direntry("Add directory: ", 
			      W_PREF_ADD, W_PREF_ADD_BROWSE);

  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);

  /* Installation options */

  frame = gtk_frame_new(NULL);
  gtk_box_pack_start(GTK_BOX(content), frame, FALSE, FALSE, 0);

  vbox = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(frame), vbox);
  gtk_container_set_border_width(GTK_CONTAINER(vbox), bw);

  w_pref[W_PREF_INSTALL] = gtk_check_button_new_with_mnemonic("Install _binaries");
  w_pref[W_PREF_SOURCE] = gtk_check_button_new_with_mnemonic("Install sou_rce");
  w_pref[W_PREF_CONFIGURE] = gtk_check_button_new_with_mnemonic("Show confi_guration");
  w_pref[W_PREF_STRIP] = gtk_check_button_new_with_mnemonic("Stri_p binaries (not recommended)");

  gtk_box_pack_start(GTK_BOX(vbox), w_pref[W_PREF_INSTALL], FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), w_pref[W_PREF_SOURCE], FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), w_pref[W_PREF_CONFIGURE], FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), w_pref[W_PREF_STRIP], FALSE, FALSE, 0);

  /* Compression format */
  frame = gtk_frame_new(NULL);
  gtk_box_pack_start(GTK_BOX(content), frame, FALSE, FALSE, 0);

  hbox = gtk_hbox_new(FALSE, 0);
  gtk_container_set_border_width(GTK_CONTAINER(hbox), bw);
  gtk_container_add(GTK_CONTAINER(frame), hbox);
  
  lbl = gtk_label_new("Compression format: ");
  gtk_box_pack_start(GTK_BOX(hbox), lbl, FALSE, FALSE, 0);

  w_pref[W_PREF_COMP] = gtk_combo_box_new_text();
  gtk_combo_box_append_text(GTK_COMBO_BOX(w_pref[W_PREF_COMP]), 
			    "gzip (.gz)");
  gtk_combo_box_append_text(GTK_COMBO_BOX(w_pref[W_PREF_COMP]),
			    "bzip2 (.bz2)");
  gtk_combo_box_append_text(GTK_COMBO_BOX(w_pref[W_PREF_COMP]),
			    "compress (.Z)");
  gtk_box_pack_start(GTK_BOX(hbox), w_pref[W_PREF_COMP], FALSE, FALSE, 0);

  /* Action buttons */

  hbox = gtk_hbutton_box_new();
  gtk_box_pack_start(GTK_BOX(content), hbox, FALSE, FALSE, 0);

  gtk_container_set_border_width(GTK_CONTAINER(hbox), bw);
  gtk_button_box_set_layout(GTK_BUTTON_BOX(hbox), GTK_BUTTONBOX_SPREAD);

  w_pref[W_PREF_SAVE] = gtk_button_new_from_stock(GTK_STOCK_SAVE);
  w_pref[W_PREF_APPLY] = gtk_button_new_from_stock(GTK_STOCK_APPLY);
  w_pref[W_PREF_CANCEL] = gtk_button_new_from_stock(GTK_STOCK_CANCEL);
  
  gtk_container_add(GTK_CONTAINER(hbox), w_pref[W_PREF_SAVE]);
  gtk_container_add(GTK_CONTAINER(hbox), w_pref[W_PREF_APPLY]);
  gtk_container_add(GTK_CONTAINER(hbox), w_pref[W_PREF_CANCEL]);
}

void pref_reset(void) {
  gtk_entry_set_text(GTK_ENTRY(w_pref[W_PREF_PREFIX]),
		     state.o.prefix ? state.o.prefix : "");

  gtk_entry_set_text(GTK_ENTRY(w_pref[W_PREF_ADD]),
		     state.o.add_directory ? state.o.add_directory : "");

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w_pref[W_PREF_INSTALL]),
			       state.o.install ? TRUE : FALSE);

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w_pref[W_PREF_SOURCE]),
			       state.o.source ? TRUE : FALSE);

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w_pref[W_PREF_CONFIGURE]),
			       state.o.manual_conf ? TRUE : FALSE);

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w_pref[W_PREF_STRIP]),
			       state.o.strip ? TRUE : FALSE);

  gtk_combo_box_set_active(GTK_COMBO_BOX(w_pref[W_PREF_COMP]),
			   state.o.src_compress == SRCINST_COMP_Z ? 2 :
			   state.o.src_compress == SRCINST_COMP_BZ2 ? 1 : 0);

}

void pref_show(void) {
  pref_reset();
  gtk_widget_show_all(w_pref[W_PREF]);
}

void pref_hide(void) {
  gtk_widget_hide_all(w_pref[W_PREF]);
}

void pref_directory_browse_clicked(GtkWidget* browse, GtkWidget* entry) {
  char* dirname; char* startpath;

  startpath = gtk_entry_get_text(GTK_ENTRY(entry));
  dirname = dialog_input_opendir("Choose a directory", startpath);

  if (dirname) {
    gtk_entry_set_text(GTK_ENTRY(entry), dirname);
    free(dirname);
  }
}

gboolean pref_delete_event(GtkWidget* w, GdkEvent* e, gpointer data) {
  pref_hide();
  return TRUE;
}

void pref_save_clicked(GtkWidget* unused_w, gpointer unused_data) {
  char* title = "Saving preferences";

  pref_apply_clicked(unused_w, unused_data);

  if (state.o.prefix)
    srcinst_set_pref_prefix(state.o.prefix);

  if (state.o.add_directory)
    srcinst_set_pref_add_directory(state.o.add_directory);

  srcinst_set_pref_install(state.o.install);
  srcinst_set_pref_keep_source(state.o.source);
  srcinst_set_pref_manual_conf(state.o.manual_conf);
  srcinst_set_pref_strip(state.o.strip);
  srcinst_set_pref_src_compress(state.o.src_compress);

  if (srcinst_save_pref()) {
    dialog_message(title, "Preferences saved successfully", "Preferences for this user have been successfully saved.", 0);
  } else {
    dialog_warning(title, "Could not save preferences", "Your changes will apply to the current session only: an error has occured trying to save preferences to ", srcinst_get_file(SRCINST_FILE_CFG));
  }
}

void pref_apply_clicked(GtkWidget* unused_w, gpointer unused_data) {
  char* title = "Applying changes to preferences";
  char* newtext; gint active;

  pref_hide();

  newtext = gtk_entry_get_text(GTK_ENTRY(w_pref[W_PREF_PREFIX]));

  if (value_updated(state.o.prefix, newtext)) {
    SRCINST_TYPE ft;
    if (state.o.prefix) free(state.o.prefix);
    state.o.prefix = srcinst_strdup(newtext);

    if ((ft = srcinst_file_type(state.o.prefix)) == SRCINST_TYPE_NONE) {
      dialog_warning(title, "Prefix directory not found", state.o.prefix, " has not been found. However, it could be automatically created by the installation scripts of the first package installed.");

    } else if (ft != SRCINST_TYPE_DIR) {
      dialog_warning(title, "Prefix is not a directory", state.o.prefix, " is not a directory. Either remove/rename the existing file, or change your preference.");
    }
  }

  newtext = gtk_entry_get_text(GTK_ENTRY(w_pref[W_PREF_ADD]));

  if (value_updated(state.o.add_directory, newtext)) {
    if (state.o.add_directory) free(state.o.add_directory);
    state.o.add_directory = srcinst_strdup(newtext);

    if (srcinst_file_type(state.o.add_directory) != SRCINST_TYPE_DIR) {
      dialog_warning(title, "Not an existing directory", state.o.add_directory, " is not an existing directory, and will be ignored.");
    }
  }
  
  state.o.install = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w_pref[W_PREF_INSTALL])) == TRUE;

  state.o.source = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w_pref[W_PREF_INSTALL])) == TRUE;

  if (!state.o.install && !state.o.source) {
    dialog_warning(title, "Neither binaries nor source code will be installed.", "Both the 'install binaries' and 'install source' options are disabled. Adding packages will have no effect.", 0);
  }

  state.o.manual_conf = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w_pref[W_PREF_CONFIGURE])) == TRUE;

  state.o.strip = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w_pref[W_PREF_STRIP])) == TRUE;
  
  active = gtk_combo_box_get_active(GTK_COMBO_BOX(w_pref[W_PREF_COMP]));
  
  state.o.src_compress = 
    active == 2 ? SRCINST_COMP_Z :
    active == 1 ? SRCINST_COMP_BZ2 : SRCINST_COMP_GZ;
}

void pref_cancel_clicked(GtkWidget* unused_w, gpointer unused_data) {
  pref_hide();
}
