/* Source Installer, Copyright (c) 2005 Claudio Fontana

 sourceinstall-gtk.c - sourceinstall GTK frontend

 This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.

 This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
     along with this program (look for the file called COPYING);
     if not, write to the Free Software Foundation, Inc.,
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     You can contact the author (Claudio Fontana) by sending a mail
     to claudio@gnu.org
*/

#include "global.h"

#include "gui.h"
#include "menu.h"
#include "events.h"
#include "package_list.h"
#include "greeting.h"
#include "dialog.h"

#include "sourceinstall-gtk.h"

void state_init(void) {
  state.actions_locked = 0;
  state.package = 0;
  options_init(&state.o);
}

int main(int argc, char* argv[]) {
  char* title = "main";
  gtk_init(&argc, &argv);
   
  if (!srcinst_init(SRCINST_FLAG_LOAD_ONDEMAND)) {
    dialog_error(title, "libsrcinst error", "could not initialize libsrcinst", 0);
  }
  atexit(srcinst_fini);

  state_init();

  gui_init();
  events_bind();
  package_list_fill();
  gui_show();
  greeting_show();
  
  gtk_main();
  return 0;
}

