/* Source Installer, Copyright (c) 2005,2006,2007 Claudio Fontana

 actions.h - actions implementation

 This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
     (at your option) any later version.

 This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
     along with this program (look for the file called COPYING);
     if not, write to the Free Software Foundation, Inc.,
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     You can contact the author (Claudio Fontana) by sending a mail
     to claudio@gnu.org
*/

#ifndef SRCINST_ACTIONS_H
#define SRCINST_ACTIONS_H

#include "mf_features.h"

SRCINST_ERR _action_init_build(struct _package_info *info, char *fn,
			       char *subdir);
SRCINST_ERR _action_chdir_build(struct _package_info *info, char *subdir);
SRCINST_ERR _action_fini_build(struct _package_info *info);

SRCINST_ERR _action_build(struct _package_info *info,
			  struct _makefile_features *mf);
SRCINST_ERR _action_test_install(struct _package_info *i,
				 struct _makefile_features *mf, int strip);
int _action_get_conflict_list(struct _package_info *i,
			      struct srcinst_string_list *list);
SRCINST_ERR _action_install_binary(struct _package_info *i,
				   struct _makefile_features *mf,
				   int strip);
SRCINST_ERR _action_install_source(struct _package_info *i,
				   SRCINST_COMP format);
SRCINST_ERR _action_uninstall_binary(struct _package_info *info);
SRCINST_ERR _action_uninstall_source(struct _package_info *info);

SRCINST_ERR _action_find_configure(struct _package_info *i,
				   struct srcinst_string_list *scripts);
SRCINST_ERR _action_configure(struct _package_info *i, char *prefix,
			      struct srcinst_string_list *argv);
struct _makefile_features *_action_detect_makefile_features(struct
							    _package_info
							    *i);
SRCINST_ERR _action_detect_configure_opt(struct _package_info *i,
					 struct srcinst_configure_sets
					 *sets);
void _action_free_configure_opt(struct srcinst_configure_sets *sets);
SRCINST_ERR _action_detect_autoconf(struct _package_info *i,
				    float *version);
SRCINST_ERR _action_rename_package(struct _package_element *e,
				   char *newname);


/* find files in DIRNAME and its subdirs recursively, filling FILES with
   the files matching GOOD_FILES */
int _find_files_aux(struct srcinst_string_list *files, char *dirname,
		    char **good_files);

/* get the Makefile name in current directory */
char *_get_makefile(void);

/* remove pending stuff from a package that has been upgraded */
SRCINST_ERR _action_upgrade(struct _package_info *from,
			    struct _package_info *to);

/* decide what to do based on current state */
int _update_package(struct _package_list *l, struct _package_element *e);

/* detect a configure script, running autogen scripts if necessary. */

int _detect_configure(void);

/* check whether build is ready, and init it if not. */
SRCINST_ERR _check_build_ready(struct _package_info *i);

/* clear and recreate builddirs */
int _clear_builddirs(void);

#endif
