/* Source Installer, Copyright (c) 2005 Claudio Fontana

   srcerror.c - custom error handling

   This program is free software; you can redistribute it and/or modify
       it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
       (at your option) any later version.

   This program is distributed in the hope that it will be useful,
       but WITHOUT ANY WARRANTY; without even the implied warranty of
       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
       GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
       along with this program (look for the file called COPYING);
       if not, write to the Free Software Foundation, Inc.,
           51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

       You can contact the author (Claudio Fontana) by sending a mail
       to claudio@gnu.org
*/

#include "src_stdinc.h"

static char* _error_strings[] = {
  "",				/* SRCINST_ERR_OK      */
  "core error",			/* SRCINST_ERR_CORE    */
  "heap error",			/* SRCINST_ERR_HEAP    */
  "regular expression error",	/* SRCINST_ERR_REGEX   */
  "user lock-file error",	/* SRCINST_ERR_LOCK    */
  "action error",		/* SRCINST_ERR_ACTION  */
  "parser error",		/* SRCINST_ERR_PARSER  */
  "permission denied",		/* SRCINST_ERR_PERM    */
  "invalid",		        /* SRCINST_ERR_INVALID */
  "missing",			/* SRCINST_ERR_MISSING */
  "policy error",		/* SRCINST_ERR_POLICY  */
  "interrupted", 		/* SRCINST_ERR_INTR    */
  "resource already exists",	/* SRCINST_ERR_BUSY    */
  0
};

void srcinst_error(int errcode, char* s, char* t) {
  if (errcode > 0 && errcode < SRCINST_ERR_N) {
    fprintf(stderr, "srcinst: <%s> %s", _error_strings[errcode], s);
    
    if (t) {
      fprintf(stderr, ": %s", t);
    }

    fprintf(stderr, ".\n");
  }

  srcinst_exit(errcode);
}

void srcinst_warning(int errcode, char* s, char* t) {
  if (errcode > 0 && errcode < SRCINST_ERR_N) {
    fprintf(stderr, "srcinst: <%s> %s", _error_strings[errcode], s);
    
    if (t) {
      fprintf(stderr, ": %s", t);
    }

    fprintf(stderr, ".\n");
  }
}

char* srcinst_error_string(int errcode) {
  if (errcode > 0 && errcode < SRCINST_ERR_N) {
    return _error_strings[errcode];
  }
  return 0;
}
