@c  Copyright (C) 2000, 2001, 2002  Tom Cato Amundsen
@c  Permission is granted to copy, distribute and/or modify this document
@c  under the terms of the GNU Free Documentation License, Version 1.1
@c  or any later version published by the Free Software Foundation;
@c  with no Invariant Sections.

m4_include(texidefinitions.m4)

@settitle Music format
@section  Music format

The music parser understand a language inspired by mudela (MUsic DEfinition
LAnguage), as used by @uref{http://www.lilypond.org, GNU Lilypond}
An example will tell more than I can explain:
@example
\staff@{
c, g cisis' < e' g' cis'' > cis'' 
@}
@end example

@image{../png/simple}

Apostroph (') and comma (,) is used to tell what octave the note
is in. Notenames are: c d e f g a b, with endings like this to get
accidentals: @code{ceses ces cis cisis eses es eis eisis}. Rests are
entered with an @code{r}.  Notes to be stacked as a chord is inside
'less than' and 'greater than' chars: <c e g>

@subsection @code{\relative}
A very useful @code{\relative} mode, like what you find in Lilypond,
saves you from typing lots of commas and apostrophes. The parser will
look at what octave the previous tone is, and place the note in the
octave that make the intervall smallest possible.  See the next two
examples:

@example
\staff\relative c'@{
\key d; \time 3/4;
d a a | a2 fis8 a | d4 b b | b2
@}
@end example
@image{../png/fist}

@example
\staff\relative c'@{
c e g c e g c e g
@}
@end example
@image{../png/ceg-relative}

@subsection Clefs
You can set the clef with the @code{\clef clefname;} command.
The default clef is @code{violin} clef. The following clefs
are supported:
@itemize
@item @code{subbass}
@item @code{bass}
@item @code{baritone}
@item @code{varbaritone}
@item @code{tenor}
@item @code{alto}
@item @code{mezzosoprano}
@item @code{soprano}
@item @code{violin} (also called @code{treble})
@item @code{french}
@end itemize

A simple example:
@example
\staff@{
\clef bass;
c e g <c e g c'>
@}
@end example
@image{../png/clef}

@subsection @code{\addvoice}
Use @code{addvoice} to enter polyphonic music:
@example
\staff\relative c'@{
\stemup c d e f | g2 g
@}
\addvoice\relative c'@{
\stemdown c4  b c2 e2 e
@}
@end example
@image{../png/addvoice}

@subsection Ties
Tie notes together using the tilde @code{~} character.
An example:
@example
\staff\relative c''@{
g ~ [g8 e] f4~ <g f c> ~ <g e c>
@} 
@end example

@image{../png/tie}

