AC_DEFUN(GST_HAVE_TCLTK, [

AC_ARG_WITH(tcl, 
	[  --with-tcl=path         set path to tclConfig.sh [default=ask tclsh]])

AC_ARG_WITH(tk, 
	[  --with-tk=path          set path to tkConfig.sh [default=same as Tcl]])

AC_MSG_CHECKING(for Tcl 8.x)
if test -z "$with_tcl" -o "$with_tcl" = yes; then
  exec AC_FD_MSG>/dev/null
  AC_PATH_PROG(TCLSH, tclsh)
  test "$silent" != yes && exec AC_FD_MSG>&1
  if test -n "$TCLSH"; then
    # Remove the last component from the path
    with_tcl=`echo 'puts $tcl_library' | $TCLSH | sed 's,\(.*\)/.*,\1,'`
  else
    with_tcl=no
  fi
fi
if test -z "$with_tk" -o "${with_tk}" = yes; then
  with_tk=$with_tcl
fi
test -f "$with_tcl/tclConfig.sh" || with_tcl=no
test -f "$with_tk/tkConfig.sh" || with_tk=no

AC_MSG_RESULT($with_tcl)
AC_MSG_CHECKING(for Tk 8.x)
AC_MSG_RESULT($with_tk)

AC_CACHE_CHECK(how to link with Tcl/Tk 8.x, gst_cv_tcltk_libs, [
  exec AC_FD_MSG>/dev/null

  gst_cv_tcltk_libs="not found"

  if test "$with_tcl" != no -a "$with_tk" != no; then
    # Get the values we need from the Tcl/Tk configuration files
    . $with_tcl/tclConfig.sh
    . $with_tk/tkConfig.sh

    # The indirection is required by Tcl/Tk
    gst_cv_tcltk_libs="$TCL_LIBS $TK_XLIBSW $TCL_LIB_SPEC $TK_LIB_SPEC"
    gst_cv_tcltk_libs=`eval echo $gst_cv_tcltk_libs`
    gst_cv_tcltk_includes="$TK_XINCLUDES -I$TCL_PREFIX/include"

    test "$TCL_PREFIX" != "$TK_PREFIX" &&
      gst_cv_tcltk_includes="$gst_cv_tcltk_includes -I$TK_PREFIX/include"

    save_cppflags="$CPPFLAGS"
    save_libs="$LIBS"
    CPPFLAGS="$CPPFLAGS $gst_cv_tcltk_includes"
    LIBS="$LIBS $gst_cv_tcltk_libs"

    # Check the headers & libraries
    AC_EGREP_CPP(everything_fine, [
#include <tcl.h>
#include <tk.h>
#ifdef TCL_MAJOR_VERSION
#ifdef TK_MAJOR_VERSION
#if ((TCL_MAJOR_VERSION == $TCL_MAJOR_VERSION) && (TCL_MINOR_VERSION == $TCL_MINOR_VERSION))
#if ((TK_MAJOR_VERSION == $TK_MAJOR_VERSION) && (TCL_MINOR_VERSION == $TCL_MINOR_VERSION))
    everything_fine
#endif
#endif
#endif
#endif], , gst_cv_tcltk_libs="not found")

    AC_CHECK_FUNC(Tcl_ObjSetVar2, , gst_cv_tcltk_libs="not found")
    AC_CHECK_FUNC(Tk_CreatePhotoImageFormat, , gst_cv_tcltk_libs="not found")
    CPPFLAGS="$save_cppflags"
    LIBS="$save_libs"
  fi
  test "$silent" != yes && exec AC_FD_MSG>&1
])

if test "$gst_cv_tcltk_libs" != "not found"; then
  AC_MSG_CHECKING(include path for Tcl/Tk)
  AC_MSG_RESULT($gst_cv_tcltk_includes)
  TCL_LIBS="$gst_cv_tcltk_libs"
  TCL_INCLUDES="$gst_cv_tcltk_includes"
  AC_DEFINE(HAVE_TCLTK)
fi

AC_SUBST(TCL_LIBS)
AC_SUBST(TCL_INCLUDES)
])dnl
