/******************************** -*- C -*- ****************************
 *
 *	System specific module declarations
 *
 *	$Revision: 1.8.5$
 *	$Date: 2000/12/27 10:45:49$
 *	$Author: pb$
 *
 ***********************************************************************/

/***********************************************************************
 *
 * Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
 * Written by Steve Byrne.
 *
 * This file is part of GNU Smalltalk.
 *
 * GNU Smalltalk is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any later 
 * version.
 * 
 * GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 *
 ***********************************************************************/


#ifndef __GSTSYSDEP__
#define __GSTSYSDEP__

#ifdef sgi
# define _BSD_SIGNALS
#endif

#include <stdio.h>
#include <signal.h>

#ifdef SIG_BLOCK
typedef sigset_t *		IntState;
#else
#ifdef INTERRUPT_STATE_TYPE
typedef INTERRUPT_STATE_TYPE	IntState;
#else
typedef int			IntState;
#endif
#endif


/* These nice tests are simple, guaranteed and independent of byte order. */
#define isFinite(dbl)		(((dbl) == (dbl)) && ((dbl) != ((dbl) * 1.5 + 1.0)))
#define isNaN(dbl)		 ((dbl) != (dbl))

typedef RETSIGTYPE (*SigHandler)(SIG_ARG_TYPE);

extern IntState		disableInterrupts();
extern SigHandler	setSignalHandler();
extern void		enableInterrupts(), signalAfter(),  relinquish(),
			initSysdep(), flushCode(), debug();
extern unsigned long	getMilliTime();
extern long		getTime(), getFileModifyTime(),
			adjustTimeZone(), currentTimeZoneBias();
extern char		*getFullFileName(), *getCurDirName(),
			*currentTimeZoneName();
extern mst_Boolean	fileIsReadable(), fileIsWriteable();
extern FILE		*openPipe(), *openFile();
extern int		closePipe();

#ifndef HAVE_GETDTABLESIZE
extern int		getdtablesize();
#endif

#ifdef HAVE_STDARG_H
extern void		debugf(const char *, ...);
#else
extern void		debugf();
#endif

#ifndef HAVE_LDEXP
#define frexp(dbl, exponentPtr)	   (*(exponentPtr) = 1 + (int) logb(dbl))
#define ldexp(dbl, exponent)	   scalbn((dbl), (exponent))
#endif

#endif /* __GSTSYSDEP__ */
