/******************************** -*- C -*- ****************************
 *
 *	Register optimization.
 *
 *	Some compilers underestimate the use of the local variables and
 *	and don't put them in hardware registers, or (especially) do
 *	unneeded spills and reloads.  This slows down the interpreter
 *	considerably.  For GCC, this provides the ability to hand-assign
 *	hardware registers for several common architectures.
 *
 *	$Revision: 1.8.5$
 *	$Date: 2000/12/27 10:45:49$
 *	$Author: pb$
 *
 ***********************************************************************/

/***********************************************************************
 *
 * Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
 * Written by Paolo Bonzini.
 *
 * This file is part of GNU Smalltalk.
 *
 * GNU Smalltalk is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any later 
 * version.
 * 
 * GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 *
 */

#ifndef __REGISTER_H
#define __REGISTER_H


#if !defined(__DECL_REG1) && defined(__mips__)
# define __DECL_REG1 "$16"
# define __DECL_REG2 "$17"
# define __DECL_REG3 "$18"
#endif

#if !defined(__DECL_REG1) && defined(__sparc__)
# define __DECL_REG1 "%10"
# define __DECL_REG2 "%11"
# define __DECL_REG3 "%12"
#endif

#if !defined(__DECL_REG1) && defined(__alpha__)
# define __DECL_REG1 "$9"
# define __DECL_REG2 "$10"
# define __DECL_REG3 "$11"
#endif

#if !defined(__DECL_REG1) && defined(__i386__)
# define __DECL_REG1 "%esi"
# define __DECL_REG2 "%edi"
# define __DECL_REG3 "%ebx"
#endif

#if !defined(__DECL_REG1) && defined(PPC) || defined(_POWER) || defined(_IBMR2)
# define __DECL_REG1 "26"
# define __DECL_REG2 "27"
# define __DECL_REG3 "28"
#endif

#if !defined(__DECL_REG1) && defined(__hppa__)
# define __DECL_REG1 "%r16"
# define __DECL_REG2 "%r17"
# define __DECL_REG3 "%r18"
#endif

#if !defined(__DECL_REG1) && defined(__mc68000__)
# define __DECL_REG1 "a5"
# define __DECL_REG2 "a4"
# define __DECL_REG3 "d7"
#endif

#ifndef __GNUC__
# define __DECL_REG(k)
#else
# ifndef __DECL_REG1
#  warning unknown architecture - register variables not optimized
#  define __DECL_REG(k)
# else /* __DECL_REG1 */
#  define __DECL_REG(k)		__asm__ (k)
# endif /* !__GNUC__ */
#endif /* __DECL_REG1 */


#define REGISTER(reg, decl)	register decl __DECL_REG(__DECL_REG##reg)

#endif
