/******************************** -*- C -*- ****************************
 *
 *	Byte code interpreter inlines
 *
 *	$Revision: 1.8.5$
 *	$Date: 2000/12/27 10:45:49$
 *	$Author: pb$
 *
 ***********************************************************************/

/***********************************************************************
 *
 * Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
 * Written by Steve Byrne.
 *
 * This file is part of GNU Smalltalk.
 *
 * GNU Smalltalk is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any later 
 * version.
 * 
 * GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 *
 ***********************************************************************/


#ifndef __GSTINTERP_INLINES__
#define __GSTINTERP_INLINES__

#include "dict.h"

#define getMethodByteCodes(methodOOP) \
  ( ((Method)oopToObj(methodOOP))->bytecodes )

#define getMethodLiterals(methodOOP) \
  ( oopToObj(((Method)oopToObj(methodOOP))->literals)->data )

/* using stackAt is correct: numArgs == 0 means that there's just the
 * receiver on the stack, at 0.  numArgs = 1 means that at location 0 is
 * the arg, location 1 is the receiver.  And so on. */
#define sendMessage(sendSelector, sendArgs, dummy) do {			\
  register OOP __receiver;						\
  __receiver = stackAt(sendArgs);					\
  sendMessageInternal(sendSelector, sendArgs, __receiver, 		\
    isInt(__receiver) ? smallIntegerClass : oopClass(__receiver));	\
} while(0);


#endif
