/******************************** -*- C -*- ****************************
 *
 *	`shl_load' (HPUX) Dynamic Linking support code
 *
 *	$Revision: 1.8.5$
 *	$Date: 2000/12/27 10:45:49$
 *	$Author: pb$
 *
 ***********************************************************************/

/***********************************************************************
 *
 * Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
 * Written by Paolo Bonzini.
 *
 * This file is part of GNU Smalltalk.
 *
 * GNU Smalltalk is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any later 
 * version.
 * 
 * GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 *
 ***********************************************************************/


#include "dld_gst.h"
#include <errno.h>
#include <string.h>
#include <stdio.h>
#include <dl.h>

static int	dld_errnum = 0;

char	*gst_dld_exts[] = { ".sl", NULL };

voidPtr
gst_dld_open (path)
     char *path; 
{
  shl_t lib;

  if (!path) {
    dld_errnum = EINVAL;
    return NULL;
  }

  lib = shl_load(path, BIND_DEFERRED, 0);
  dld_errnum = (lib ? 0 : errno);

  return (voidPtr) lib;
}

voidPtr
gst_dld_sym (handle, symbol)
     voidPtr handle;
     char *symbol;
{
  voidPtr p = NULL;
  
  if (!handle) {
    dld_errnum = EINVAL;
    return NULL;
  }

  /* If shl_findsym does not return 0, something went wrong */
  if (shl_findsym((shl_t *) &handle, symbol, TYPE_UNDEFINED, (voidPtr) &p)) {
    p = NULL;
  }
  dld_errnum = (p ? 0 : errno);

  return p;
}

char *
gst_dld_error ()
{
  return (dld_errnum ? strerror(dld_errnum) : NULL);
}


int
gst_dld_init (dldArgv0)
char *dldArgv0;
{
  return 0;
}
