CStruct newStruct: #CSockAddrStruct declaration: #( 
	(sinFamily short)
	(sinPort (array byte 2))
	(sinAddr (array byte 4))
	(sinZero (array byte 8))
)!

IPAddress class
	defineCFunc: 'TCPlookupAllHostAddr'
        withSelectorArgs: 'lookupAllHostAddr: name'
	returning: #cObject
	args: #(string).

IPAddress class
	defineCFunc: 'TCPgetHostByAddr'
        withSelectorArgs: 'primName: address'
	returning: #stringOut
	args: #(byteArray).
!

IPAddress class
	defineCFunc: 'TCPgetLocalName'
        withSelectorArgs: 'primLocalName'
	returning: #stringOut
	args: #().
!

IPAddress class
	defineCFunc: 'TCPgetAnyLocalAddress'
        withSelectorArgs: 'primAnyLocalAddress: hostName in: byteArray'
	returning: #void
	args: #(string byteArray).
!


#(('TCPgetAF' 		  'afInet'		IPAddress)
  ('TCPgetPF'		  'pfInet' 		IPAddress)
  ('TCPsolSocket'         'solSocket'     	AbstractSocketImpl)
  ('TCPipprotoIp'    	  'ipprotoIp'    	AbstractSocketImpl)
  ('TCPipprotoTcp'    	  'ipprotoTcp'    	AbstractSocketImpl)
  ('TCPipMulticastTtl'	  'ipMulticastTtl'	DatagramSocketImpl)
  ('TCPipMulticastIf'	  'ipMulticastIf'	DatagramSocketImpl)
  ('TCPipAddMembership'	  'ipAddMembership'	DatagramSocketImpl)
  ('TCPipDropMembership'  'ipDropMembership'	DatagramSocketImpl))

do: [ :each |
    (Smalltalk classAt: (each at: 3)) class
    	defineCFunc: (each at: 1)
        withSelectorArgs: (each at: 2)
	returning: #long
	args: #().
].


#(('TCPaccept'  'accept: socket  peer: peer addrLen: len' int (int byteArray byteArray))
  ('TCPbind'    'bind: socket    to: addr   addrLen: len' int (int byteArray int))
  ('TCPconnect' 'connect: socket to: addr   addrLen: len' int (int byteArray int))
  ('TCPlisten'  'listen: socket  log: len'                int (int int))

  ('TCPgetpeername' 'getPeerName: socket addr: addr addrLen: len' int (int byteArray byteArray))
  ('TCPgetsockname' 'getSockName: socket addr: addr addrLen: len' int (int byteArray byteArray))

  ('TCPrecvfrom' 'receive: socket buffer: buf size: len flags: flags from: addr size: addrLen' int (int byteArray int int byteArray int))
  ('TCPsendto'   'send:    socket buffer: buf size: len flags: flags to: addr   size: addrLen' int (int byteArray int int unknown   int))

  ('TCPsetsockopt'  'option: socket level: level at: name put: value size: len' int (int int int byteArray int))
  ('TCPgetsockopt'  'option: socket level: level at: name get: value size: len' int (int int int byteArray int))

  ('TCPsocket'      'create: family type: type protocol: protocol' int (int int int))

  ('TCPavailable'   'available: socket' int (int))
)

do: [ :each |
    TCPSocketImpl
        perform: #defineCFunc:withSelectorArgs:returning:args:
        withArguments: each.

    UDPSocketImpl
        perform: #defineCFunc:withSelectorArgs:returning:args:
        withArguments: each.
]!
