"======================================================================
|
|   UDPSocketImpl
|
|   $Revision: 1.6.2$
|   $Date: 1999/08/31 11:23:18$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1990, 91, 92, 94, 95, 99 Free Software Foundation, Inc.
| Written by Steve Byrne.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"

DatagramSocketImpl subclass: #UDPSocketImpl
	   instanceVariableNames: 'bufSize'
	   classVariableNames: ''
	   poolDictionaries: ''
	   category: 'Sockets-Protocols'
!

!UDPSocketImpl methodsFor: 'implementation'!

available
    ^self available: self fd
!

bindTo: ipAddress port: port
    | addr |
    addr := ipAddress port: port.
    self bind: self fd to: addr addrLen: addr size.
    port = 0
        ifTrue: [ self boundTo: ipAddress port: self getSockPort ]
        ifFalse: [ self boundTo: ipAddress port: port ]
!

create
    self initFd: (self
        socket: IPAddress afInet
        type: self class sockDgram
        protocol: IPAddress pfInit)
!

optionAt: opt level: level size: size
    | result |
    result := ByteArray new: size.
    self
        option: self fd
        level: level 
        at: opt
        get: result
        size: size.
    ^result
!

optionAt: opt level: level put: anObject
    | byteArray |
    "Awful!!"
    anObject == true
        ifTrue: [ byteArray := ByteArray with: 1 ].

    (anObject == false) | (anObject == nil)
        ifTrue: [ byteArray := ByteArray new: CInt sizeof ].

    (anObject class == ByteArray)
        ifTrue: [ byteArray := anObject ].

    (anObject class == IPAddress)
        ifTrue: [ byteArray := anObject asByteArray ].

    (anObject class == Integer)
        ifTrue: [
            byteArray := ByteArray new: CInt sizeof.
            byteArray intAt: 1 put: anObject
        ].

    self
        option: self fd
        level: level
        at: opt
        put: byteArray
        size: byteArray size.
!

receive: flags datagram: aDatagram
    | address port data from |
    data := ByteArray new: self bufferSize.
    from := ByteArray new: CSockAddrStruct sizeof.
    self
        receive: self fd
        buffer: data
        size: data size
        flags: flags
        from: from
        size: from size.

    port := ValueHolder new.
    ^aDatagram
        data: data;
        address: (IPAddress fromSockAddr: from port: port);
        port: port value;
        yourself
!

send: aDatagram to: receiverOrNil port: port
    | size receiver |
    receiverOrNil isNil
        ifTrue: [ receiver := size := 0 ]
        ifFalse: [ receiver := receiverOrNil port: port. size := receiver size ].

    self
        send: self fd
        buffer: aDatagram data
        size: aDatagram data size
        flags: 0
        to: receiver
        size: size
! !

!UDPSocketImpl methodsFor: 'accessing'!

bufferSize
    ^bufSize
!

bufferSize: size
    bufSize := size
! !

!UDPSocketImpl methodsFor: 'private'!

getSockPort
    | peer port sizePtr |
    peer := ByteArray new: CSockAddrStruct sizeof.
    sizePtr := ByteArray new: CInt sizeof.
    sizePtr intAt: 1 put: CSockAddrStruct sizeof.

    self
        getSockName: self fd
        addr: peer
        addrLen: sizePtr.

    port := ValueHolder new.
    IPAddress fromSockAddr: peer port: port.
    ^port value
! !
