"======================================================================
|
|   DatagramSocket wrapper class
|
|   $Revision: 1.6.2$
|   $Date: 1999/08/31 11:23:18$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1990, 91, 92, 94, 95, 99 Free Software Foundation, Inc.
| Written by Steve Byrne and Paolo Bonzini.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================
"

AbstractSocket subclass: #DatagramSocket
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Sockets-Streams'
!

DatagramSocket defaultImplementationClass: UDPSocketImpl!

!DatagramSocket class methodsFor: 'instance creation'!

new
    ^self local: nil port: 0
!

port: localPort
    ^self local: nil port: localPort
!

local: ipAddress port: localPort
    (localPort < 0) | (localPort > 16rFFFF)
        ifTrue: [ self error: 'port out of range' ].

    ^super new
        local: ipAddress port: localPort
! !

!DatagramSocket methodsFor: 'accessing'!

address
    ^self localAddress
!

port
    ^self localPort
!

receive: datagram
    ^self implementation receive: datagram
! !


!DatagramSocket methodsFor: 'direct operations'!

nextFrom: ipAddress port: port
    ^self implementation nextFrom: ipAddress port: port
!

nextPut: packet to: ipAddress port: port
    ^self implementation nextPut: packet to: ipAddress port: port
! !

!DatagramSocket methodsFor: 'private'!

create
    self implementation create
!

local: ipAddress port: localPort

    self create.
    self implementation
        bindTo: (ipAddress isNil
            ifTrue: [ IPAddress anyLocalAddress ]
            ifFalse: [ ipAddress ])
	port: localPort.
!

newBuffer
    ^self implementation
! !
