"======================================================================
|
|   Test the Smalltalk-in-Smalltalk parser.
|
|   $Revision: 1.6.2$
|   $Date: 1999/08/31 11:23:18$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1990, 91, 92, 94, 95, 99 Free Software Foundation, Inc.
| Written by Steve Byrne.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"

(STFileInParser on: 'test/geometry.st') parseSmalltalk; close!

| code |

code := '
   | i |
   i := 0.
   [ i < 5 ] whileTrue:  [ i printNl. i := i + 1 ].
   [ i = 9 ] whileFalse: [ i printNl. i := i + 1 ].
   i even ifTrue: [ i printNl ].
   i odd ifFalse: [ i printNl ].
   (i even or: [i odd])  ifTrue: [ ''okay'' printNl] ifFalse: [ ''huh?!?'' printNl ].
   (i even and: [i odd]) ifFalse: [ ''okay'' printNl] ifTrue: [ ''huh?!?'' printNl ].
   Transcript
       nextPutAll: ''now I''''m testing '';
       print: ''Cascading'';
       nl.

   #(53 $a [1 2 3] (1 2 3) [1 2 3] perform: ''
What strange arrays... and even multi-line strings'') printNl.

   #(''and now'' '' blocks with parameters...'') do: [ :each |
       Transcript nextPutAll: each ].

   [ :a :b :c | | temp |
       temp := Transcript.
       temp
           nl;
           print: (i = 9 ifTrue: [ ''okay'' ] ifFalse: [ ''huh?!?'' ]);
           nl; nextPutAll: a;
           nl; nextPutAll: b;
           nl; nextPutAll: c;
           nl
   ]
       value: ''finally, many parameters, ''
       value: ''cascading ''
       value: ''and block temporaries too! ''
!'.

code := ReadStream on: code.

(STFileInParser onStream: code) parseSmalltalk; close! 

"Smalltalk quitPrimitive!

| p |
 #(
  'builtins.st' 
  'Object.st'
  'Message.st'
  'Magnitude.st'
  'Character.st'
  'Date.st'
  'Time.st'
  'Number.st'
  'Float.st'
  'Integer.st'
  'LookupKey.st'
  'Association.st'
  'Link.st'
  'Process.st'
  'Collection.st'
  'SequenceableCollection.st'
  'LinkedList.st'
  'Semaphore.st'
  'ArrayedCollection.st'
  'Array.st'
  'String.st'
  'Symbol.st'
  'ByteArray.st'
  'CompiledMethod.st'
  'Interval.st'
  'OrderedCollection.st'
  'SortedCollection.st'
  'Bag.st'
  'MappedCollection.st'
  'Set.st'
  'Dictionary.st'
  'IdentityDictionary.st'
  'SystemDictionary.st'
  'Stream.st'
  'PositionableStream.st'
  'ReadStream.st'
  'WriteStream.st'
  'ReadWriteStream.st'
  'FileStream.st'
  'TokenStream.st'
  'Random.st'
  'UndefinedObject.st'
  'Boolean.st'
  'False.st'
  'True.st'
  'ProcessorScheduler.st'
  'Delay.st'
  'SharedQueue.st'
  'Behavior.st'
  'ClassDescription.st'
  'Class.st'
  'Metaclass.st'
  'MethodContext.st'
  'BlockContext.st'
  'Memory.st'
  'WordMemory.st'
  'ByteMemory.st'
  'MethodInfo.st'
  'FileSegment.st'
  'SymLink.st'
  'initialize.st'
  'CFuncs.st'
  'CType.st'
  'CObject.st'
  'CStruct.st'
  'Autoload.st'
  'Fraction.st'
  'UnixStream.st'
  'IOCtl.st'
  'changes.st' 
  'Browser.st'

) do:
   [ :file | stdout nextPutAll: '
======================================================================
======================================================================

Parsing: '; nextPutAll: file; nextPutAll: '

======================================================================
======================================================================
'.
	     
	     p := STFileInParser on: file.
             p parseSmalltalk ].

!

Smalltalk quitPrimitive!

"