" Smalltalk Toolkit for the X Protocol

 (w) Ulf Dambacher 960330

"
Object subclass: #Case
	  instanceVariableNames: 'test found result'
	  classVariableNames: ''
	  poolDictionaries: ''
	  category: 'Extensions'
!

Case comment:
'A nice class for switch-like tests. Slower than cascaded ifs but clearer.
Uses identity for testing because of speed (you'll likely use it with
symbols, integers, characters, and the like).

e.g.

Case new test: myObject;
    case: 5				   do: [ ''got five''	    printNl ];
    when: [ :testVal | testVal isInteger ] do: [ ''an integer''     printNl ];
    else: 				       [ :testVal | testVal printNl ]

You can use (Case test: myObject) instead of the first line above. Whether
it is clearer or not it is a matter of taste.'!

!Case class methodsFor: 'instance creation'!

test: anObject
    ^self new test: anObject
!!

!Case methodsFor: 'testing'!

test: anObject
    test _ anObject.
    found _ false.
!

reset
    found _ false
!

else: aBlock
    ^found
	ifFalse: [ self do: aBlock ]
	ifTrue: [ result ].
!

case: anObject do: aBlock
    ^(found not and: [test == anObject])
	ifTrue: [ self do: aBlock ]
	ifFalse: [ result ].
!

when: aBlock do: aBlock2
    ^(found not and: [aBlock value: test])
	ifTrue: [ self do: aBlock ]
	ifFalse: [ result ].
!!

!Case methodsFor: 'private'!

do: aBlock
    found _ true.
    ^result := (aBlock argumentCount = 0
        ifTrue: [ aBlock value ]
        ifFalse: [ aBlock value: test ])
!!
