"File Prompter.st
======================================================================
|
| Copyright 1990, 91, 92, 94, 95, 99 Free Software Foundation, Inc.
| Written by Brad Diller.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================
"

Gui subclass:  #Prompter
        instanceVariableNames: 'defaultResponse'
        classVariableNames: ''
        poolDictionaries: ''
        category: 'Graphics-Windows'
!

!Prompter class methodsFor: 'instance creation'!

openFileName: aString default: default in: view
    ^BDialog
        chooseFileToOpen: view rootView blox
        label: aString
        default: default
        defaultExtension: 'st'
        types: #(
            ('Smalltalk files'  '.st')
            ('Text files'  '.txt'))
!

saveFileName: aString default: default in: view
    ^BDialog
        chooseFileToSave: view rootView blox
        label: aString
        default: default
        defaultExtension: 'st'
        types: #(
            ('Smalltalk files'  '.st')
            ('Text files'  '.txt'))
!

message: aString default: aResponse in: view
    ^self new message: aString default: aResponse in: view
!

message: aString in: view
    ^self new message: aString default: '' in: view
!!

!Prompter methodsFor: 'initialize-delete'!

message: queryString default: aResponse in: view
| dialogShell  |
    "Prompt user for string input.  The default response, queryString, is displayed in
     text portion"
    defaultResponse := aResponse.
    dialogShell := BTransientWindow new: 'Prompter dialog' in: (view rootView blox).
    dialogShell width: 300.
    self blox: (BDialog new: dialogShell label: queryString prompt: aResponse).
    dialogShell createToplevelWindow: 'Prompter dialog'.
    blox addButton: 'OK' receiver: self message: #accept.
    blox addButton: 'Cancel' receiver: self message: #cancel.
    dialogShell map.
    self blox center.
    self blox loop.
!!

!Prompter methodsFor: 'accessing'!

accept 
| index |
    "Truncate string after newline character"
    defaultResponse := blox contents.
    (index := defaultResponse findFirst: [ :ch | ch == Character nl ]) > 0
        ifTrue: [ defaultResponse := defaultResponse copyFrom: 1 to: index - 1].
!

cancel
    defaultResponse := ''.
!

response
"Return default response"
    ^defaultResponse
!!

