"File Primitive.st
======================================================================
|
| Copyright 1990, 91, 92, 94, 95, 99 Free Software Foundation, Inc.
| Written by Brad Diller.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================
"

View subclass:  #Primitive
        instanceVariableNames: 'menu dirty stateChangeMsg messageDispatch '
        classVariableNames: 'Views'
        poolDictionaries: ''
        category: 'Graphics-Windows'
!

!Primitive class methodsFor: 'initialize'!

new
     ^super new
         dirty: false;
     	 yourself
!

initViews
     Views := Set new.
!

views
     ^Views
!!

!Primitive class methodsFor: 'displaying'!

updateViews
    "Update all the primitive views"
    "Views do: [ :i | i update ]."
    "It is noticably expensive to iterate through all the instances this way,
     but it's even worse to keep the Views collection up-to-date"

    self allSubclassesDo: [:s | s allInstancesDo: [ :i | i update ]].
!!

!Primitive methodsFor: 'initialize-delete'!

stateChange: theStateChange updateWith: block
| viewState |
     messageDispatch isNil
        ifTrue: [ messageDispatch := Dictionary new].
     viewState := Dictionary new. 
     viewState at: #counter put: 0. 
     viewState at: #block put: block.
     messageDispatch at: theStateChange put: viewState.
!

handleUserChange: changeSelector
"This is used to update the data object in response to a user
modification of the view"
     stateChangeMsg := changeSelector.
!

menuInit: theMenu
"The popup menu, theMenu, is stored in menu"
     menu := theMenu
!

remove
     super remove.
     "Views remove: self."
!!

!Primitive methodsFor: 'accessing'!

dirty: aBoolean
        dirty := aBoolean.
!

isDirty 
    ^dirty
!

menu
     ^menu
!

data: aData
     data := aData.
!!

!Primitive methodsFor: 'displaying'!

getViewState
     ^messageDispatch
!

redisplay: stateChanges
"Update object based on stateChanges"
| viewState |
     stateChanges do: [ :sc | viewState := messageDispatch at: (sc at: #state).
         viewState at: #counter put: (sc at: #counter). 
         (viewState at: #block) value ]
!

update
"Send a getStateChanges: currentViewState message to data object to compute state changes. Send a redisplay: stateChanges message to self to redisplay object"
| stateChanges |
     data isNil  ifTrue: [^self].
     stateChanges := data getStateChanges: self getViewState.
     stateChanges notNil 
          ifTrue: [self redisplay: stateChanges].
!

display
"Overridden in subclasses.  This method is used to support change/update 
mechanism.  In the normal case, this method redraws entire view"
     ^self subclassResponsibility
!!

!Primitive methodsFor: 'blue button menu items'!

close
    | tv |
    tv := self rootView blox.
    self rootView close ifTrue: [tv destroy ].
!!


